/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.lookahead;

import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.components.impl.TaskScheduler;
import es.bsc.compss.scheduler.exceptions.BlockedActionException;
import es.bsc.compss.scheduler.exceptions.UnassignedActionException;
import es.bsc.compss.scheduler.lookahead.LookaheadRS;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.ObjectValue;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.util.ActionSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import org.json.JSONObject;

public abstract class LookaheadTS
extends TaskScheduler {
    protected final ActionSet unassignedReadyActions = new ActionSet();
    protected Set<AllocatableAction> upgradedActions = new HashSet<AllocatableAction>();

    public <T extends WorkerResourceDescription> void workerLoadUpdate(ResourceScheduler<T> resource) {
        LOGGER.debug("[ReadyScheduler] Update load on worker " + resource.getName() + ". Nothing to do.");
    }

    public <T extends WorkerResourceDescription> void workerFeaturesUpdate(ResourceScheduler<T> worker, T modification, List<AllocatableAction> unblockedActions, List<AllocatableAction> blockedCandidates) {
        LinkedList<AllocatableAction> dataFreeActions = new LinkedList<AllocatableAction>();
        List<AllocatableAction> resourceFreeActions = unblockedActions;
        this.tryToLaunchFreeActions(dataFreeActions, resourceFreeActions, blockedCandidates, worker);
    }

    public abstract Score generateActionScore(AllocatableAction var1);

    public abstract <T extends WorkerResourceDescription> LookaheadRS<T> generateSchedulerForResource(Worker<T> var1, JSONObject var2, JSONObject var3);

    protected void scheduleAction(AllocatableAction action, Score actionScore) throws BlockedActionException {
        if (!action.hasDataPredecessors() && !action.hasStreamProducers()) {
            try {
                action.schedule(actionScore);
            }
            catch (UnassignedActionException ex) {
                this.unassignedReadyActions.addAction(action);
            }
        }
    }

    protected <T extends WorkerResourceDescription> void scheduleAction(AllocatableAction action, ResourceScheduler<T> targetWorker, Score actionScore) throws BlockedActionException, UnassignedActionException {
        if (!action.hasDataPredecessors() && !action.hasStreamProducers()) {
            action.schedule(targetWorker, actionScore);
        }
    }

    public void upgradeAction(AllocatableAction action) {
        if (DEBUG) {
            LOGGER.debug(" Upgrading action " + action);
        }
        this.upgradedActions.add(action);
    }

    public List<AllocatableAction> getUnassignedActions() {
        return this.unassignedReadyActions.getAllActions();
    }

    public final <T extends WorkerResourceDescription> void handleDependencyFreeActions(List<AllocatableAction> dataFreeActions, List<AllocatableAction> resourceFreeActions, List<AllocatableAction> blockedCandidates, ResourceScheduler<T> resource) {
        LOGGER.debug("[ReadyScheduler] Handling dependency free actions.");
        this.tryToLaunchFreeActions(dataFreeActions, resourceFreeActions, blockedCandidates, resource);
    }

    protected <T extends WorkerResourceDescription> PriorityQueue<ObjectValue<AllocatableAction>> getCandidateFreeActions(List<AllocatableAction> dataFreeActions, List<AllocatableAction> resourceFreeActions, ActionSet unassignedActions, List<AllocatableAction> blockedCandidates, ResourceScheduler<T> resource) {
        ObjectValue obj;
        Score fullScore;
        Score actionScore;
        PriorityQueue<ObjectValue<AllocatableAction>> executableActions = new PriorityQueue<ObjectValue<AllocatableAction>>();
        for (AllocatableAction freeAction : dataFreeActions) {
            actionScore = this.generateActionScore(freeAction);
            fullScore = freeAction.schedulingScore(resource, actionScore);
            obj = new ObjectValue((Object)freeAction, fullScore);
            executableActions.add((ObjectValue<AllocatableAction>)obj);
        }
        for (AllocatableAction freeAction : resourceFreeActions) {
            obj = new ObjectValue((Object)freeAction, fullScore = freeAction.schedulingScore(resource, actionScore = this.generateActionScore(freeAction)));
            if (executableActions.contains(obj)) continue;
            executableActions.add((ObjectValue<AllocatableAction>)obj);
        }
        for (AllocatableAction freeAction : unassignedActions.removeAllActions()) {
            obj = new ObjectValue((Object)freeAction, fullScore = freeAction.schedulingScore(resource, actionScore = this.generateActionScore(freeAction)));
            if (executableActions.contains(obj)) continue;
            executableActions.add((ObjectValue<AllocatableAction>)obj);
        }
        return executableActions;
    }

    private PriorityQueue<ObjectValue<AllocatableAction>> sortActions(Iterable<AllocatableAction> actions) {
        if (DEBUG) {
            LOGGER.debug("[ReadyScheduler] Managing " + this.upgradedActions.size() + " upgraded actions.");
        }
        PriorityQueue<ObjectValue<AllocatableAction>> sortedActions = new PriorityQueue<ObjectValue<AllocatableAction>>();
        for (AllocatableAction action : actions) {
            Score fullScore = this.generateActionScore(action);
            ObjectValue obj = new ObjectValue((Object)action, fullScore);
            sortedActions.add((ObjectValue<AllocatableAction>)obj);
        }
        return sortedActions;
    }

    private void manageUpgradedActions() {
        if (!this.upgradedActions.isEmpty()) {
            PriorityQueue<ObjectValue<AllocatableAction>> executableActions = this.sortActions(this.upgradedActions);
            while (!executableActions.isEmpty()) {
                ObjectValue<AllocatableAction> obj = executableActions.poll();
                AllocatableAction freeAction = (AllocatableAction)obj.getObject();
                try {
                    freeAction.schedule((Collection)freeAction.getCompatibleWorkers(), obj.getScore());
                    this.tryToLaunch(freeAction);
                    this.upgradedActions.remove(freeAction);
                    this.unassignedReadyActions.removeAction(freeAction);
                }
                catch (UnassignedActionException unassignedActionException) {}
            }
        }
    }

    private void manageUpgradedActions(ResourceScheduler<?> resource) {
        if (!this.upgradedActions.isEmpty()) {
            if (DEBUG) {
                LOGGER.debug("[ReadyScheduler] Managing " + this.upgradedActions.size() + " upgraded actions.");
            }
            PriorityQueue<ObjectValue<AllocatableAction>> executableActions = this.sortActions(this.upgradedActions);
            while (!executableActions.isEmpty()) {
                ObjectValue<AllocatableAction> obj = executableActions.poll();
                AllocatableAction freeAction = (AllocatableAction)obj.getObject();
                if (!freeAction.getCompatibleWorkers().contains(resource) || !resource.canRunSomething()) continue;
                try {
                    freeAction.schedule(resource, obj.getScore());
                    this.tryToLaunch(freeAction);
                    this.upgradedActions.remove(freeAction);
                    this.unassignedReadyActions.removeAction(freeAction);
                }
                catch (UnassignedActionException unassignedActionException) {}
            }
        }
    }

    private <T extends WorkerResourceDescription> void tryToLaunchFreeActions(List<AllocatableAction> dataFreeActions, List<AllocatableAction> resourceFreeActions, List<AllocatableAction> blockedCandidates, ResourceScheduler<T> resource) {
        this.manageUpgradedActions(resource);
        PriorityQueue<ObjectValue<AllocatableAction>> executableActions = this.getCandidateFreeActions(dataFreeActions, resourceFreeActions, this.unassignedReadyActions, blockedCandidates, resource);
        Set<AllocatableAction> oldUpgradedActions = this.upgradedActions;
        while (!executableActions.isEmpty()) {
            ObjectValue<AllocatableAction> obj = executableActions.poll();
            AllocatableAction freeAction = (AllocatableAction)obj.getObject();
            Score actionScore = obj.getScore();
            this.upgradedActions = new HashSet<AllocatableAction>();
            LOGGER.debug("[ReadyScheduler] Trying to launch action " + freeAction);
            try {
                this.scheduleAction(freeAction, actionScore);
                this.tryToLaunch(freeAction);
                if (this.upgradedActions.isEmpty()) continue;
                this.manageUpgradedActions();
                oldUpgradedActions.addAll(this.upgradedActions);
            }
            catch (BlockedActionException e) {
                blockedCandidates.add(freeAction);
            }
        }
        this.upgradedActions = oldUpgradedActions;
    }
}

