/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.lookahead;

import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.scheduler.exceptions.BlockedActionException;
import es.bsc.compss.scheduler.exceptions.UnassignedActionException;
import es.bsc.compss.scheduler.lookahead.LookaheadTS;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.ObjectValue;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.util.ActionSet;
import java.util.List;
import java.util.PriorityQueue;

public abstract class SuccessorsTS
extends LookaheadTS {
    @Override
    public <T extends WorkerResourceDescription> PriorityQueue<ObjectValue<AllocatableAction>> getCandidateFreeActions(List<AllocatableAction> dataFreeActions, List<AllocatableAction> resourceFreeActions, ActionSet unassignedActions, List<AllocatableAction> blockedCandidates, ResourceScheduler<T> resource) {
        LOGGER.debug("[DataScheduler] Treating dependency free actions");
        PriorityQueue<ObjectValue> executableActions = new PriorityQueue<ObjectValue>();
        for (AllocatableAction action : dataFreeActions) {
            Score actionScore = this.generateActionScore(action);
            Score fullScore = action.schedulingScore(resource, actionScore);
            ObjectValue obj = new ObjectValue((Object)action, fullScore);
            executableActions.add(obj);
        }
        dataFreeActions.clear();
        while (!executableActions.isEmpty()) {
            ObjectValue obj = (ObjectValue)executableActions.poll();
            AllocatableAction freeAction = (AllocatableAction)obj.getObject();
            try {
                this.scheduleAction(freeAction, resource, obj.getScore());
                this.tryToLaunch(freeAction);
            }
            catch (BlockedActionException e) {
                blockedCandidates.add(freeAction);
            }
            catch (UnassignedActionException e) {
                dataFreeActions.add(freeAction);
            }
        }
        return super.getCandidateFreeActions(dataFreeActions, resourceFreeActions, unassignedActions, blockedCandidates, resource);
    }
}

