/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.lookahead.successors.lifo;

import es.bsc.compss.scheduler.lookahead.LookaheadRS;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import org.json.JSONObject;

public class LifoRS<T extends WorkerResourceDescription>
extends LookaheadRS<T> {
    public LifoRS(Worker<T> w, JSONObject resJSON, JSONObject implJSON) {
        super(w, resJSON, implJSON);
    }

    public Score generateBlockedScore(AllocatableAction action) {
        long priority = action.getPriority();
        long groupId = action.getGroupPriority();
        long resourceScore = action.getId();
        long waitingScore = 0L;
        long implementationScore = 0L;
        return new Score(priority, groupId, resourceScore, waitingScore, implementationScore);
    }

    public Score generateResourceScore(AllocatableAction action, TaskDescription params, Score actionScore) {
        long priority = actionScore.getPriority();
        long groupId = action.getGroupPriority();
        long resource = actionScore.getResourceScore();
        long waitingScore = 0L;
        long implementationScore = 0L;
        return new Score(priority, groupId, resource, waitingScore, implementationScore);
    }

    public Score getRunnableImplScore(AllocatableAction action, TaskDescription params, Implementation impl, Score resourceScore) {
        long priority = resourceScore.getPriority();
        long groupId = action.getGroupPriority();
        long resourcePriority = resourceScore.getResourceScore();
        long waitingScore = resourceScore.getWaitingScore();
        long implScore = -this.getProfile(impl).getAverageExecutionTime();
        return new Score(priority, groupId, resourcePriority, waitingScore, implScore);
    }

    public String toString() {
        return "LifoResourceScheduler@" + this.getName();
    }
}

