/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.orderstrict;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import org.json.JSONObject;

public abstract class OrderStrictRS<T extends WorkerResourceDescription>
extends ResourceScheduler<T> {
    public OrderStrictRS(Worker<T> w, JSONObject resJSON, JSONObject implJSON) {
        super(w, resJSON, implJSON);
    }

    public Score generateResourceScore(AllocatableAction action, TaskDescription params, Score actionScore) {
        long priority = actionScore.getPriority();
        long groupId = action.getGroupPriority();
        long waitingScore = -this.blocked.size();
        long resourceScore = 0L;
        if (this.myWorker == Comm.getAppHost()) {
            ++resourceScore;
        }
        return new Score(priority, groupId, resourceScore, waitingScore, 0L);
    }

    public Score generateImplementationScore(AllocatableAction action, TaskDescription params, Implementation impl, Score resourceScore) {
        long priority = resourceScore.getPriority();
        long groupId = action.getGroupPriority();
        long resource = resourceScore.getResourceScore();
        if (!this.myWorker.canRunNow(impl.getRequirements())) {
            return null;
        }
        long waitingScore = resourceScore.getWaitingScore();
        long implScore = -this.getProfile(impl).getAverageExecutionTime();
        return new Score(priority, groupId, resource, waitingScore, implScore);
    }
}

