/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.orderstrict;

import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.components.impl.TaskScheduler;
import es.bsc.compss.scheduler.exceptions.BlockedActionException;
import es.bsc.compss.scheduler.exceptions.UnassignedActionException;
import es.bsc.compss.scheduler.types.ActionOrchestrator;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.ObjectValue;
import es.bsc.compss.scheduler.types.SchedulingInformation;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import org.json.JSONObject;

public abstract class OrderStrictTS
extends TaskScheduler {
    protected final PriorityQueue<ObjectValue<AllocatableAction>> readyQueue;
    protected Set<AllocatableAction> upgradedActions;
    protected final Map<AllocatableAction, ObjectValue<AllocatableAction>> addedActions;

    public OrderStrictTS(ActionOrchestrator orchestrator) {
        super(orchestrator);
        LOGGER.debug("[OrderStrict] Loading OrderStrict TS");
        this.readyQueue = new PriorityQueue();
        this.upgradedActions = new HashSet<AllocatableAction>();
        this.addedActions = new HashMap<AllocatableAction, ObjectValue<AllocatableAction>>();
    }

    public abstract <T extends WorkerResourceDescription> ResourceScheduler<T> generateSchedulerForResource(Worker<T> var1, JSONObject var2, JSONObject var3);

    public <T extends WorkerResourceDescription> SchedulingInformation generateSchedulingInformation(ResourceScheduler<T> rs, List<? extends Parameter> params, Integer coreId) {
        return new SchedulingInformation(rs);
    }

    public void upgradeAction(AllocatableAction action) {
        if (DEBUG) {
            LOGGER.debug("[OrderStrict] Upgrading action " + action);
        }
        this.upgradedActions.add(action);
        ObjectValue<AllocatableAction> obj = this.addedActions.remove(action);
        this.readyQueue.remove(obj);
    }

    private PriorityQueue<ObjectValue<AllocatableAction>> sortActions(Iterable<AllocatableAction> actions) {
        if (DEBUG) {
            LOGGER.debug("[OrcerStrict] Managing " + this.upgradedActions.size() + " upgraded actions.");
        }
        PriorityQueue<ObjectValue<AllocatableAction>> sortedActions = new PriorityQueue<ObjectValue<AllocatableAction>>();
        for (AllocatableAction action : actions) {
            Score fullScore = this.generateActionScore(action);
            ObjectValue obj = new ObjectValue((Object)action, fullScore);
            sortedActions.add((ObjectValue<AllocatableAction>)obj);
        }
        return sortedActions;
    }

    private void manageUpgradedActions(ResourceScheduler<?> resource) {
        if (!this.upgradedActions.isEmpty()) {
            if (DEBUG) {
                LOGGER.debug("[OrderStrict] Managing " + this.upgradedActions.size() + " upgraded actions.");
            }
            PriorityQueue<ObjectValue<AllocatableAction>> executableActions = this.sortActions(this.upgradedActions);
            while (!executableActions.isEmpty()) {
                ObjectValue<AllocatableAction> obj = executableActions.poll();
                AllocatableAction freeAction = (AllocatableAction)obj.getObject();
                if (!freeAction.getCompatibleWorkers().contains(resource) || !resource.canRunSomething()) continue;
                try {
                    freeAction.schedule(resource, obj.getScore());
                    this.tryToLaunch(freeAction);
                    this.upgradedActions.remove(freeAction);
                }
                catch (UnassignedActionException unassignedActionException) {}
            }
        }
    }

    private void addActionToReadyQueue(AllocatableAction action, Score actionScore) {
        ObjectValue obj = new ObjectValue((Object)action, actionScore);
        this.addedActions.put(action, (ObjectValue<AllocatableAction>)obj);
        this.readyQueue.add((ObjectValue<AllocatableAction>)obj);
    }

    protected void scheduleAction(AllocatableAction action, Score actionScore) throws BlockedActionException {
        if (!action.hasDataPredecessors() && this.upgradedActions.isEmpty()) {
            ObjectValue<AllocatableAction> topReady = this.readyQueue.peek();
            if (topReady == null || actionScore.isBetter(topReady.getScore())) {
                try {
                    action.schedule(actionScore);
                }
                catch (UnassignedActionException uae) {
                    this.addActionToReadyQueue(action, actionScore);
                }
            } else {
                if (action.getCompatibleWorkers().isEmpty()) {
                    throw new BlockedActionException();
                }
                this.addActionToReadyQueue(action, actionScore);
            }
        }
    }

    public final <T extends WorkerResourceDescription> void handleDependencyFreeActions(List<AllocatableAction> dataFreeActions, List<AllocatableAction> resourceFreeActions, List<AllocatableAction> blockedCandidates, ResourceScheduler<T> resource) {
        this.manageUpgradedActions(resource);
        PriorityQueue<ObjectValue> executableActions = new PriorityQueue<ObjectValue>();
        for (AllocatableAction freeAction : dataFreeActions) {
            Score actionScore = this.generateActionScore(freeAction);
            ObjectValue obj = new ObjectValue((Object)freeAction, actionScore);
            executableActions.add(obj);
        }
        boolean canExecute = true;
        boolean readyQueueEmpty = this.readyQueue.isEmpty();
        boolean executableActionsEmpty = executableActions.isEmpty();
        ObjectValue topPriority = null;
        while (!(!canExecute || executableActionsEmpty && readyQueueEmpty)) {
            ObjectValue topReadyQueue = this.readyQueue.peek();
            ObjectValue topExecutableActions = (ObjectValue)executableActions.peek();
            Score topReadyQueueScore = null;
            Score topExecutableActionsScore = null;
            if (!readyQueueEmpty) {
                topReadyQueueScore = topReadyQueue.getScore();
            }
            if (!executableActionsEmpty) {
                topExecutableActionsScore = topExecutableActions.getScore();
            }
            topPriority = Score.isBetter((Score)topReadyQueueScore, (Score)topExecutableActionsScore) ? topReadyQueue : topExecutableActions;
            AllocatableAction aa = (AllocatableAction)topPriority.getObject();
            try {
                aa.schedule(topPriority.getScore());
                this.tryToLaunch(aa);
                if (topReadyQueue == topPriority) {
                    this.readyQueue.poll();
                    this.addedActions.remove(aa);
                    readyQueueEmpty = this.readyQueue.isEmpty();
                    continue;
                }
                executableActions.poll();
                executableActionsEmpty = executableActions.isEmpty();
            }
            catch (UnassignedActionException uae) {
                canExecute = false;
            }
            catch (BlockedActionException bae) {
                this.addToBlocked(aa);
            }
        }
        if (!executableActions.isEmpty()) {
            this.readyQueue.addAll(executableActions);
        }
    }
}

