/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.orderstrict;

import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.components.impl.TaskScheduler;
import es.bsc.compss.scheduler.exceptions.BlockedActionException;
import es.bsc.compss.scheduler.exceptions.UnassignedActionException;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.ObjectValue;
import es.bsc.compss.scheduler.types.SchedulingInformation;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import java.util.List;
import java.util.PriorityQueue;
import org.json.JSONObject;

public abstract class OrderStrictTS
extends TaskScheduler {
    protected final PriorityQueue<ObjectValue<AllocatableAction>> readyQueue = new PriorityQueue();

    public abstract <T extends WorkerResourceDescription> ResourceScheduler<T> generateSchedulerForResource(Worker<T> var1, JSONObject var2, JSONObject var3);

    public <T extends WorkerResourceDescription> SchedulingInformation generateSchedulingInformation(ResourceScheduler<T> rs, List<? extends Parameter> params, Integer coreId) {
        return new SchedulingInformation(rs);
    }

    private void addActionToReadyQueue(AllocatableAction action, Score actionScore) {
        ObjectValue obj = new ObjectValue((Object)action, actionScore);
        this.readyQueue.add((ObjectValue<AllocatableAction>)obj);
    }

    protected void scheduleAction(AllocatableAction action, Score actionScore) throws BlockedActionException {
        if (!action.hasDataPredecessors()) {
            ObjectValue<AllocatableAction> topReady = this.readyQueue.peek();
            if (topReady == null || actionScore.isBetter(topReady.getScore())) {
                try {
                    action.schedule(actionScore);
                }
                catch (UnassignedActionException uae) {
                    this.addActionToReadyQueue(action, actionScore);
                }
            } else {
                if (action.getCompatibleWorkers().isEmpty()) {
                    throw new BlockedActionException();
                }
                this.addActionToReadyQueue(action, actionScore);
            }
        }
    }

    public final <T extends WorkerResourceDescription> void handleDependencyFreeActions(List<AllocatableAction> dataFreeActions, List<AllocatableAction> resourceFreeActions, List<AllocatableAction> blockedCandidates, ResourceScheduler<T> resource) {
        PriorityQueue<ObjectValue> executableActions = new PriorityQueue<ObjectValue>();
        for (AllocatableAction freeAction : dataFreeActions) {
            Score actionScore = this.generateActionScore(freeAction);
            ObjectValue obj = new ObjectValue((Object)freeAction, actionScore);
            executableActions.add(obj);
        }
        boolean canExecute = true;
        boolean readyQueueEmpty = this.readyQueue.isEmpty();
        boolean executableActionsEmpty = executableActions.isEmpty();
        ObjectValue topPriority = null;
        while (!(!canExecute || executableActionsEmpty && readyQueueEmpty)) {
            ObjectValue topReadyQueue = this.readyQueue.peek();
            ObjectValue topExecutableActions = (ObjectValue)executableActions.peek();
            Score topReadyQueueScore = null;
            Score topExecutableActionsScore = null;
            if (!readyQueueEmpty) {
                topReadyQueueScore = topReadyQueue.getScore();
            }
            if (!executableActionsEmpty) {
                topExecutableActionsScore = topExecutableActions.getScore();
            }
            topPriority = Score.isBetter((Score)topReadyQueueScore, (Score)topExecutableActionsScore) ? topReadyQueue : topExecutableActions;
            AllocatableAction aa = (AllocatableAction)topPriority.getObject();
            try {
                aa.schedule(topPriority.getScore());
                this.tryToLaunch(aa);
                if (topReadyQueue == topPriority) {
                    this.readyQueue.poll();
                    readyQueueEmpty = this.readyQueue.isEmpty();
                    continue;
                }
                executableActions.poll();
                executableActionsEmpty = executableActions.isEmpty();
            }
            catch (UnassignedActionException uae) {
                canExecute = false;
            }
            catch (BlockedActionException bae) {
                this.addToBlocked(aa);
            }
        }
        if (!executableActions.isEmpty()) {
            this.readyQueue.addAll(executableActions);
        }
    }
}

