/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.orderstrict.fifo;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.scheduler.orderstrict.OrderStrictRS;
import es.bsc.compss.scheduler.orderstrict.fifo.types.FIFOScore;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import org.json.JSONObject;

public class FifoRS<T extends WorkerResourceDescription>
extends OrderStrictRS<T> {
    public FifoRS(Worker<T> w, JSONObject resJSON, JSONObject implJSON) {
        super(w, resJSON, implJSON);
    }

    public Score generateBlockedScore(AllocatableAction action) {
        long priority = action.getPriority();
        long groupId = action.getGroupPriority();
        long actionId = action.getId();
        long resourceScore = 0L;
        long waitingScore = 0L;
        long implementationScore = 0L;
        return new FIFOScore(priority, groupId, actionId, resourceScore, waitingScore, implementationScore);
    }

    public Score generateResourceScore(AllocatableAction action, TaskDescription params, Score actionScore) {
        long priority = actionScore.getPriority();
        long groupId = action.getGroupPriority();
        long actionId = action.getId();
        long waitingScore = -this.blocked.size();
        long resourceScore = 0L;
        if (this.myWorker == Comm.getAppHost()) {
            ++resourceScore;
        }
        return new FIFOScore(priority, groupId, actionId, resourceScore, waitingScore, 0L);
    }

    public Score generateImplementationScore(AllocatableAction action, TaskDescription params, Implementation impl, Score resourceScore) {
        long priority = resourceScore.getPriority();
        long groupId = action.getGroupPriority();
        long actionId = action.getId();
        long resource = resourceScore.getResourceScore();
        if (!this.myWorker.canRunNow(impl.getRequirements())) {
            return null;
        }
        long waitingScore = resourceScore.getWaitingScore();
        long implScore = -this.getProfile(impl).getAverageExecutionTime();
        return new FIFOScore(priority, groupId, actionId, resource, waitingScore, implScore);
    }

    public String toString() {
        return "FIFOResourceScheduler@" + this.getName();
    }
}

