/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.readynew;

import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.components.impl.TaskScheduler;
import es.bsc.compss.scheduler.exceptions.BlockedActionException;
import es.bsc.compss.scheduler.exceptions.UnassignedActionException;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.ObjectValue;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.util.ErrorManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ReadyScheduler
extends TaskScheduler {
    protected static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Components.TaskDispatcher.TaskScheduler");
    protected HashMap<ResourceScheduler<?>, TreeSet<ObjectValue<AllocatableAction>>> unassignedReadyActions = new HashMap();
    protected final HashSet<ResourceScheduler<?>> availableWorkers;
    protected final HashMap<ResourceScheduler<?>, Future<?>> resourceTokens = new HashMap();
    protected int amountOfWorkers = 0;
    ThreadPoolExecutor schedulerExecutor;

    public ReadyScheduler() {
        this.availableWorkers = new HashSet();
        this.schedulerExecutor = new ThreadPoolExecutor(15, 40, 180L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        this.schedulerExecutor.allowCoreThreadTimeOut(true);
    }

    public <T extends WorkerResourceDescription> void workerLoadUpdate(ResourceScheduler<T> resource) {
        LOGGER.debug("[ReadyScheduler] Update load on worker " + resource.getName() + ". Nothing to do.");
    }

    protected <T extends WorkerResourceDescription> void workerDetected(ResourceScheduler<T> resource) {
        super.workerDetected(resource);
        this.availableWorkers.add(resource);
        this.resourceTokens.put(resource, null);
        ++this.amountOfWorkers;
        if (this.unassignedReadyActions.size() > 0) {
            TreeSet<ObjectValue> orderedActions = new TreeSet<ObjectValue>();
            Iterator<Map.Entry<ResourceScheduler<?>, TreeSet<ObjectValue<AllocatableAction>>>> iter = this.unassignedReadyActions.entrySet().iterator();
            TreeSet<ObjectValue<AllocatableAction>> actionList = iter.next().getValue();
            for (ObjectValue<AllocatableAction> actionValue : actionList) {
                AllocatableAction action = (AllocatableAction)actionValue.getObject();
                Score actionScore = this.generateActionScore(action);
                Score fullScore = action.schedulingScore(resource, actionScore);
                ObjectValue obj = new ObjectValue((Object)action, fullScore);
                orderedActions.add(obj);
            }
            this.unassignedReadyActions.put(resource, orderedActions);
        } else {
            TreeSet orderedActions = new TreeSet();
            this.unassignedReadyActions.put(resource, orderedActions);
        }
    }

    protected <T extends WorkerResourceDescription> void workerRemoved(ResourceScheduler<T> resource) {
        super.workerRemoved(resource);
        this.availableWorkers.remove(resource);
        this.resourceTokens.remove(resource);
        --this.amountOfWorkers;
        if (this.amountOfWorkers == 0) {
            for (ObjectValue<AllocatableAction> actionValue : this.unassignedReadyActions.get(resource)) {
                AllocatableAction action = (AllocatableAction)actionValue.getObject();
                this.addToBlocked(action);
            }
        }
        this.unassignedReadyActions.remove(resource);
    }

    public <T extends WorkerResourceDescription> void workerFeaturesUpdate(ResourceScheduler<T> worker, T modification, List<AllocatableAction> unblockedActions, List<AllocatableAction> blockedCandidates) {
        LinkedList<AllocatableAction> dataFreeActions = new LinkedList<AllocatableAction>();
        List<AllocatableAction> resourceFreeActions = unblockedActions;
        this.purgeFreeActions(dataFreeActions, resourceFreeActions, blockedCandidates, worker);
        this.tryToLaunchFreeActions(dataFreeActions, resourceFreeActions, blockedCandidates, worker);
    }

    public abstract Score generateActionScore(AllocatableAction var1);

    protected void scheduleAction(AllocatableAction action, Score actionScore) throws BlockedActionException {
        if (!action.hasDataPredecessors() && !action.hasStreamProducers()) {
            try {
                List uselessWorkers = action.tryToSchedule(this.generateActionScore(action), this.availableWorkers);
                for (ResourceScheduler worker : uselessWorkers) {
                    this.availableWorkers.remove(worker);
                }
                ResourceScheduler resource = action.getAssignedResource();
                if (!resource.canRunSomething()) {
                    this.availableWorkers.remove(resource);
                }
                this.removeActionFromSchedulerStructures(action);
            }
            catch (UnassignedActionException ex) {
                this.addActionToSchedulerStructures(action);
            }
        }
    }

    protected <T extends WorkerResourceDescription> void scheduleAction(AllocatableAction action, ResourceScheduler<T> targetWorker, Score actionScore) throws BlockedActionException, UnassignedActionException {
        if (!action.hasDataPredecessors() && !action.hasStreamProducers()) {
            action.schedule(targetWorker, actionScore);
            this.removeActionFromSchedulerStructures(action);
        }
    }

    public final void newAllocatableAction(AllocatableAction action) {
        LOGGER.info("[ReadyScheduler] Registering new AllocatableAction " + action);
        if (!action.hasDataPredecessors()) {
            this.addToReady(action);
            if (!this.availableWorkers.isEmpty()) {
                try {
                    List uselessWorkers = action.tryToSchedule(this.generateActionScore(action), this.availableWorkers);
                    for (ResourceScheduler worker : uselessWorkers) {
                        this.availableWorkers.remove(worker);
                    }
                    this.tryToLaunch(action);
                }
                catch (BlockedActionException bae) {
                    this.removeFromReady(action);
                    this.addToBlocked(action);
                }
                catch (UnassignedActionException uae) {
                    this.addActionToSchedulerStructures(action);
                }
            } else {
                this.addActionToSchedulerStructures(action);
            }
        }
    }

    public List<AllocatableAction> getUnassignedActions() {
        LinkedList<AllocatableAction> unassigned = new LinkedList<AllocatableAction>();
        Iterator<Map.Entry<ResourceScheduler<?>, TreeSet<ObjectValue<AllocatableAction>>>> iter = this.unassignedReadyActions.entrySet().iterator();
        TreeSet<ObjectValue<AllocatableAction>> actionList = iter.next().getValue();
        ResourceScheduler resource = (ResourceScheduler)((Map.Entry)((Object)iter)).getKey();
        Future<?> resourceToken = this.resourceTokens.get(resource);
        if (resourceToken != null) {
            try {
                resourceToken.get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
                LOGGER.fatal("Unexpected thread interruption");
                ErrorManager.fatal((String)"Unexpected thread interruption");
            }
        }
        for (ObjectValue<AllocatableAction> actionObject : actionList) {
            unassigned.add((AllocatableAction)actionObject.getObject());
        }
        return unassigned;
    }

    public final <T extends WorkerResourceDescription> void handleDependencyFreeActions(List<AllocatableAction> dataFreeActions, List<AllocatableAction> resourceFreeActions, List<AllocatableAction> blockedCandidates, ResourceScheduler<T> resource) {
        if (DEBUG) {
            LOGGER.debug("[ReadyScheduler] Treating dependency free actions on resource " + resource.getName());
        }
        if (resource.canRunSomething()) {
            this.availableWorkers.add(resource);
        }
        this.purgeFreeActions(dataFreeActions, resourceFreeActions, blockedCandidates, resource);
        this.tryToLaunchFreeActions(dataFreeActions, resourceFreeActions, blockedCandidates, resource);
    }

    public <T extends WorkerResourceDescription> void purgeFreeActions(List<AllocatableAction> dataFreeActions, List<AllocatableAction> resourceFreeActions, List<AllocatableAction> blockedCandidates, ResourceScheduler<T> resource) {
    }

    private void addActionToResource(Map.Entry<ResourceScheduler<?>, TreeSet<ObjectValue<AllocatableAction>>> currentEntry, AllocatableAction action) {
        ResourceScheduler<?> resource = currentEntry.getKey();
        TreeSet<ObjectValue<AllocatableAction>> actionList = currentEntry.getValue();
        Score fullScore = action.schedulingScore(resource, this.generateActionScore(action));
        if (fullScore != null) {
            ObjectValue obj = new ObjectValue((Object)action, fullScore);
            actionList.add((ObjectValue<AllocatableAction>)obj);
        }
    }

    private void removeActionFromResource(Map.Entry<ResourceScheduler<?>, TreeSet<ObjectValue<AllocatableAction>>> currentEntry, AllocatableAction action) {
        currentEntry.getKey();
        TreeSet<ObjectValue<AllocatableAction>> actionList = currentEntry.getValue();
        Score fullScore = action.schedulingScore(currentEntry.getKey(), this.generateActionScore(action));
        if (fullScore != null) {
            ObjectValue obj = new ObjectValue((Object)action, fullScore);
            actionList.remove(obj);
        }
    }

    private Runnable createAddRunnable(final Map.Entry<ResourceScheduler<?>, TreeSet<ObjectValue<AllocatableAction>>> currentEntry, final AllocatableAction action, final Future<?> token) {
        Runnable addRunnable = new Runnable(){

            @Override
            public void run() {
                if (token != null) {
                    try {
                        token.get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        e.printStackTrace();
                        LOGGER.fatal("Unexpected thread interruption");
                        ErrorManager.fatal((String)"Unexpected thread interruption");
                    }
                }
                ReadyScheduler.this.addActionToResource(currentEntry, action);
            }
        };
        return addRunnable;
    }

    private Runnable createRemoveRunnable(final Map.Entry<ResourceScheduler<?>, TreeSet<ObjectValue<AllocatableAction>>> currentEntry, final AllocatableAction action, final Future<?> token) {
        Runnable removeRunnable = new Runnable(){

            @Override
            public void run() {
                if (token != null) {
                    try {
                        token.get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        e.printStackTrace();
                        LOGGER.fatal("Unexpected thread interruption");
                        ErrorManager.fatal((String)"Unexpected thread interruption");
                    }
                }
                ReadyScheduler.this.removeActionFromResource(currentEntry, action);
            }
        };
        return removeRunnable;
    }

    private void addActionToSchedulerStructures(AllocatableAction action) {
        if (!this.unassignedReadyActions.isEmpty()) {
            Score actionScore;
            ResourceScheduler<?> resource;
            Score fullScore;
            ObjectValue obj;
            Iterator<Map.Entry<ResourceScheduler<?>, TreeSet<ObjectValue<AllocatableAction>>>> iter;
            Map.Entry<ResourceScheduler<?>, TreeSet<ObjectValue<AllocatableAction>>> currentEntry;
            TreeSet<ObjectValue<AllocatableAction>> actionList;
            if (DEBUG) {
                LOGGER.debug("[ReadyScheduler] Add action to scheduler structures " + action);
            }
            if (!(actionList = (currentEntry = (iter = this.unassignedReadyActions.entrySet().iterator()).next()).getValue()).add((ObjectValue<AllocatableAction>)(obj = new ObjectValue((Object)action, fullScore = action.schedulingScore(resource = currentEntry.getKey(), actionScore = this.generateActionScore(action)))))) {
                return;
            }
            while (iter.hasNext()) {
                currentEntry = iter.next();
                resource = currentEntry.getKey();
                Future<?> lastToken = this.resourceTokens.get(resource);
                this.resourceTokens.put(resource, this.schedulerExecutor.submit(this.createAddRunnable(currentEntry, action, lastToken)));
            }
        } else {
            if (DEBUG) {
                LOGGER.debug("[ReadyScheduler] Cannot add action " + action + " because there are not available resources");
            }
            this.addToBlocked(action);
        }
    }

    private void removeActionFromSchedulerStructures(AllocatableAction action) {
        if (!this.unassignedReadyActions.isEmpty()) {
            Score actionScore;
            Score fullScore;
            ObjectValue obj;
            if (DEBUG) {
                LOGGER.debug("[ReadyScheduler] Remove action from scheduler structures " + action);
            }
            Iterator<Map.Entry<ResourceScheduler<?>, TreeSet<ObjectValue<AllocatableAction>>>> iter = this.unassignedReadyActions.entrySet().iterator();
            Map.Entry<ResourceScheduler<?>, TreeSet<ObjectValue<AllocatableAction>>> currentEntry = iter.next();
            ResourceScheduler<?> resource = currentEntry.getKey();
            TreeSet<ObjectValue<AllocatableAction>> actionList = currentEntry.getValue();
            if (!actionList.remove(obj = new ObjectValue((Object)action, fullScore = action.schedulingScore(resource, actionScore = this.generateActionScore(action))))) {
                return;
            }
            while (iter.hasNext()) {
                currentEntry = iter.next();
                resource = currentEntry.getKey();
                Future<?> lastToken = this.resourceTokens.get(resource);
                this.resourceTokens.put(resource, this.schedulerExecutor.submit(this.createRemoveRunnable(currentEntry, action, lastToken)));
            }
        }
    }

    protected <T extends WorkerResourceDescription> void tryToLaunchFreeActions(List<AllocatableAction> dataFreeActions, List<AllocatableAction> resourceFreeActions, List<AllocatableAction> blockedCandidates, ResourceScheduler<T> resource) {
        if (DEBUG) {
            LOGGER.debug("[ReadyScheduler] Try to launch free actions on resource " + resource.getName() + " with " + this.unassignedReadyActions.get(resource).size() + " candidates in this worker");
        }
        for (AllocatableAction freeAction : dataFreeActions) {
            if (DEBUG) {
                LOGGER.debug("[ReadyScheduler] Introducing action " + freeAction + " into the scheduler from data free");
            }
            this.addActionToSchedulerStructures(freeAction);
        }
        dataFreeActions = new LinkedList<AllocatableAction>();
        for (AllocatableAction freeAction : resourceFreeActions) {
            if (DEBUG) {
                LOGGER.debug("[ReadyScheduler] Introducing action " + freeAction + " into the scheduler from resource free");
            }
            this.addActionToSchedulerStructures(freeAction);
        }
        resourceFreeActions = new LinkedList<AllocatableAction>();
        for (AllocatableAction freeAction : blockedCandidates) {
            if (DEBUG) {
                LOGGER.debug("[ReadyScheduler] Introducing action " + freeAction + " into the scheduler from blocked");
            }
            this.addActionToSchedulerStructures(freeAction);
        }
        blockedCandidates = new LinkedList<AllocatableAction>();
        Future<?> lastToken = this.resourceTokens.get(resource);
        if (lastToken != null) {
            try {
                lastToken.get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
                LOGGER.fatal("Unexpected thread interruption");
                ErrorManager.fatal((String)"Unexpected thread interruption");
            }
        }
        this.resourceTokens.put(resource, null);
        Iterator<ObjectValue<AllocatableAction>> executableActionsIterator = this.unassignedReadyActions.get(resource).iterator();
        HashSet<ObjectValue<AllocatableAction>> objectValueToErase = new HashSet<ObjectValue<AllocatableAction>>();
        while (executableActionsIterator.hasNext() && !this.availableWorkers.isEmpty()) {
            ObjectValue<AllocatableAction> obj = executableActionsIterator.next();
            AllocatableAction allocatableAction = (AllocatableAction)obj.getObject();
            try {
                List uselessWorkers = allocatableAction.tryToSchedule(this.generateActionScore(allocatableAction), this.availableWorkers);
                for (ResourceScheduler worker : uselessWorkers) {
                    this.availableWorkers.remove(worker);
                }
                ResourceScheduler assignedResource = allocatableAction.getAssignedResource();
                this.tryToLaunch(allocatableAction);
                if (!assignedResource.canRunSomething()) {
                    this.availableWorkers.remove(assignedResource);
                }
                objectValueToErase.add(obj);
            }
            catch (BlockedActionException e) {
                objectValueToErase.add(obj);
                this.addToBlocked(allocatableAction);
            }
            catch (UnassignedActionException e) {
                if (!DEBUG) continue;
                LOGGER.debug("[ReadyScheduler] Action " + allocatableAction + " could not be assigned to any of the available resources");
            }
        }
        for (ObjectValue objectValue : objectValueToErase) {
            AllocatableAction action = (AllocatableAction)objectValue.getObject();
            this.removeActionFromSchedulerStructures(action);
        }
    }
}

