/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.readynew;

import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.components.impl.TaskScheduler;
import es.bsc.compss.scheduler.exceptions.BlockedActionException;
import es.bsc.compss.scheduler.exceptions.UnassignedActionException;
import es.bsc.compss.scheduler.readynew.ReadyResourceScheduler;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.ObjectValue;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.util.ErrorManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ReadyScheduler
extends TaskScheduler {
    protected static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Components.TaskDispatcher.TaskScheduler");
    protected final HashSet<ResourceScheduler<?>> availableWorkers;
    protected final HashMap<ResourceScheduler<?>, Future<?>> resourceTokens = new HashMap();
    protected int amountOfWorkers = 0;
    ThreadPoolExecutor schedulerExecutor;
    protected Set<AllocatableAction> upgradedActions;

    public ReadyScheduler() {
        this.availableWorkers = new HashSet();
        this.schedulerExecutor = new ThreadPoolExecutor(15, 40, 180L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        this.schedulerExecutor.allowCoreThreadTimeOut(true);
        this.upgradedActions = new HashSet<AllocatableAction>();
    }

    public <T extends WorkerResourceDescription> void workerLoadUpdate(ResourceScheduler<T> resource) {
        LOGGER.debug("[ReadyScheduler] Update load on worker " + resource.getName() + ". Nothing to do.");
        if (resource.canRunSomething()) {
            this.availableWorkers.add(resource);
        }
    }

    public void shutdown() {
        this.schedulerExecutor.shutdown();
        super.shutdown();
    }

    protected <T extends WorkerResourceDescription> void workerDetected(ResourceScheduler<T> resource) {
        super.workerDetected(resource);
        if (this.getWorkers().size() > 0) {
            for (AllocatableAction action : this.getUnassignedActions()) {
                Score actionScore = this.generateActionScore(action);
                this.addActionToResource((ReadyResourceScheduler)resource, actionScore, action);
            }
        }
        this.availableWorkers.add(resource);
        this.resourceTokens.put(resource, null);
        ++this.amountOfWorkers;
    }

    protected <T extends WorkerResourceDescription> void workerRemoved(ResourceScheduler<T> resource) {
        this.availableWorkers.remove(resource);
        this.resourceTokens.remove(resource);
        --this.amountOfWorkers;
        ReadyResourceScheduler rs = (ReadyResourceScheduler)resource;
        if (this.amountOfWorkers == 0) {
            for (ObjectValue<AllocatableAction> actionValue : rs.getUnassignedActions()) {
                AllocatableAction action = (AllocatableAction)actionValue.getObject();
                this.addToBlocked(action);
            }
        }
        rs.resetUnassignedActions();
        super.workerRemoved(resource);
    }

    public <T extends WorkerResourceDescription> void workerFeaturesUpdate(ResourceScheduler<T> worker, T modification, List<AllocatableAction> unblockedActions, List<AllocatableAction> blockedCandidates) {
        LinkedList<AllocatableAction> dataFreeActions = new LinkedList<AllocatableAction>();
        List<AllocatableAction> resourceFreeActions = unblockedActions;
        this.purgeFreeActions(dataFreeActions, resourceFreeActions, blockedCandidates, worker);
        this.tryToLaunchFreeActions(dataFreeActions, resourceFreeActions, blockedCandidates, worker);
    }

    public abstract Score generateActionScore(AllocatableAction var1);

    protected void scheduleAction(AllocatableAction action, Score actionScore) throws BlockedActionException {
        if (!action.hasDataPredecessors() && !action.hasStreamProducers()) {
            try {
                List uselessWorkers = action.tryToSchedule(this.generateActionScore(action), this.availableWorkers);
                for (ResourceScheduler worker : uselessWorkers) {
                    this.availableWorkers.remove(worker);
                }
                ResourceScheduler resource = action.getAssignedResource();
                if (!resource.canRunSomething()) {
                    this.availableWorkers.remove(resource);
                }
                this.removeActionFromSchedulerStructures(action);
            }
            catch (UnassignedActionException ex) {
                this.addActionToSchedulerStructures(action);
            }
        }
    }

    protected <T extends WorkerResourceDescription> void scheduleAction(AllocatableAction action, ResourceScheduler<T> targetWorker, Score actionScore) throws BlockedActionException, UnassignedActionException {
        if (!action.hasDataPredecessors() && !action.hasStreamProducers()) {
            action.schedule(targetWorker, actionScore);
            this.removeActionFromSchedulerStructures(action);
        }
    }

    public final void newAllocatableAction(AllocatableAction action) {
        LOGGER.info("[ReadyScheduler] Registering new AllocatableAction " + action);
        if (!action.hasDataPredecessors()) {
            this.addToReady(action);
            if (!this.availableWorkers.isEmpty()) {
                try {
                    List uselessWorkers = action.tryToSchedule(this.generateActionScore(action), this.availableWorkers);
                    for (ResourceScheduler worker : uselessWorkers) {
                        this.availableWorkers.remove(worker);
                    }
                    this.tryToLaunch(action);
                }
                catch (BlockedActionException bae) {
                    this.removeFromReady(action);
                    this.addToBlocked(action);
                }
                catch (UnassignedActionException uae) {
                    this.addActionToSchedulerStructures(action);
                }
            } else {
                this.addActionToSchedulerStructures(action);
            }
        }
    }

    public Collection<AllocatableAction> getUnassignedActions() {
        HashSet<AllocatableAction> unassigned = new HashSet<AllocatableAction>();
        for (ReadyResourceScheduler resource : this.getWorkers()) {
            Future<?> resourceToken = this.resourceTokens.get((Object)resource);
            if (resourceToken != null) {
                try {
                    resourceToken.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    LOGGER.fatal("Unexpected thread interruption", (Throwable)e);
                    ErrorManager.fatal((String)"Unexpected thread interruption", (Exception)e);
                }
            }
            for (ObjectValue<AllocatableAction> actionObject : resource.getUnassignedActions()) {
                unassigned.add((AllocatableAction)actionObject.getObject());
            }
        }
        return unassigned;
    }

    public final <T extends WorkerResourceDescription> void handleDependencyFreeActions(List<AllocatableAction> dataFreeActions, List<AllocatableAction> resourceFreeActions, List<AllocatableAction> blockedCandidates, ResourceScheduler<T> resource) {
        if (DEBUG) {
            LOGGER.debug("[ReadyScheduler] Handling dependency free actions on resource " + resource.getName());
        }
        this.manageUpgradedActions(resource);
        if (resource.canRunSomething()) {
            this.availableWorkers.add(resource);
        }
        this.purgeFreeActions(dataFreeActions, resourceFreeActions, blockedCandidates, resource);
        this.tryToLaunchFreeActions(dataFreeActions, resourceFreeActions, blockedCandidates, resource);
    }

    public <T extends WorkerResourceDescription> void purgeFreeActions(List<AllocatableAction> dataFreeActions, List<AllocatableAction> resourceFreeActions, List<AllocatableAction> blockedCandidates, ResourceScheduler<T> resource) {
    }

    private void manageUpgradedActions(ResourceScheduler<?> resource) {
        if (!this.upgradedActions.isEmpty()) {
            if (DEBUG) {
                LOGGER.debug("[ReadyScheduler] Managing " + this.upgradedActions.size() + " upgraded actions.");
            }
            HashSet candidates = new HashSet();
            candidates.add(resource);
            PriorityQueue<ObjectValue> executableActions = new PriorityQueue<ObjectValue>();
            for (AllocatableAction action : this.upgradedActions) {
                Score fullScore = action.schedulingScore(resource, this.generateActionScore(action));
                ObjectValue obj = new ObjectValue((Object)action, fullScore);
                executableActions.add(obj);
            }
            while (!executableActions.isEmpty() && resource.canRunSomething()) {
                ObjectValue obj = (ObjectValue)executableActions.poll();
                AllocatableAction freeAction = (AllocatableAction)obj.getObject();
                try {
                    freeAction.tryToSchedule(obj.getScore(), candidates);
                    this.tryToLaunch(freeAction);
                    this.upgradedActions.remove(freeAction);
                }
                catch (BlockedActionException | UnassignedActionException throwable) {}
            }
        }
    }

    private void updateActionToSchedulerStructures(AllocatableAction action) {
        if (!this.getWorkers().isEmpty()) {
            if (DEBUG) {
                LOGGER.debug("[ReadyScheduler] Updating action to scheduler structures " + action);
            }
            if (action.isTargetResourceEnforced()) {
                ReadyResourceScheduler resource = (ReadyResourceScheduler)action.getEnforcedTargetResource();
                this.updateActionInResource(resource, action);
            } else {
                this.updateActionInAllResources(action);
            }
        } else {
            if (DEBUG) {
                LOGGER.debug("[ReadyScheduler] Cannot add action " + action + " because there are not available resources");
            }
            this.addToBlocked(action);
        }
    }

    private void addActionToSchedulerStructures(AllocatableAction action) {
        if (!this.getWorkers().isEmpty()) {
            if (DEBUG) {
                LOGGER.debug("[ReadyScheduler] Add action to scheduler structures " + action);
            }
            Score actionScore = this.generateActionScore(action);
            if (action.isTargetResourceEnforced()) {
                ReadyResourceScheduler resource = (ReadyResourceScheduler)action.getEnforcedTargetResource();
                this.addActionToResource(resource, actionScore, action);
            } else {
                this.addActionInAllResources(actionScore, action);
            }
        } else {
            if (DEBUG) {
                LOGGER.debug("[ReadyScheduler] Cannot add action " + action + " because there are not available resources");
            }
            this.addToBlocked(action);
        }
    }

    private void addActionInAllResources(Score actionScore, AllocatableAction action) {
        Iterator iter = this.getWorkers().iterator();
        if (iter.hasNext()) {
            ReadyResourceScheduler resource = (ReadyResourceScheduler)((Object)iter.next());
            if (!this.addActionToResource(resource, actionScore, action)) {
                if (DEBUG) {
                    LOGGER.debug("[ReadyScheduler] Action already added " + action);
                }
                return;
            }
            while (iter.hasNext()) {
                resource = (ReadyResourceScheduler)((Object)iter.next());
                Future<?> lastToken = this.resourceTokens.get((Object)resource);
                this.resourceTokens.put(resource, this.schedulerExecutor.submit(new AddRunnable(resource, actionScore, action, lastToken)));
            }
        } else if (DEBUG) {
            LOGGER.debug("[ReadyScheduler] No resources to addAction");
        }
    }

    private void updateActionInAllResources(AllocatableAction action) {
        for (ReadyResourceScheduler resource : this.getWorkers()) {
            Future<?> lastToken = this.resourceTokens.get((Object)resource);
            this.resourceTokens.put(resource, this.schedulerExecutor.submit(new UpdateRunnable(resource, action, lastToken)));
        }
    }

    private void removeActionFromSchedulerStructures(AllocatableAction action) {
        if (!this.getWorkers().isEmpty()) {
            if (DEBUG) {
                LOGGER.debug("[ReadyScheduler] Remove action from scheduler structures " + action);
            }
            if (action.isTargetResourceEnforced()) {
                ReadyResourceScheduler resource = (ReadyResourceScheduler)action.getEnforcedTargetResource();
                this.removeActionFromResource(resource, action);
            } else {
                this.removeActionFromAllResources(action);
            }
        }
    }

    private void removeActionFromAllResources(AllocatableAction action) {
        Iterator iter = this.getWorkers().iterator();
        if (iter.hasNext()) {
            ReadyResourceScheduler resource = (ReadyResourceScheduler)((Object)iter.next());
            if (!this.removeActionFromResource(resource, action)) {
                if (DEBUG) {
                    LOGGER.debug("[ReadyScheduler] Action already added " + action);
                }
                return;
            }
            while (iter.hasNext()) {
                resource = (ReadyResourceScheduler)((Object)iter.next());
                Future<?> lastToken = this.resourceTokens.get((Object)resource);
                this.resourceTokens.put(resource, this.schedulerExecutor.submit(new RemoveRunnable(resource, action, lastToken)));
            }
        } else if (DEBUG) {
            LOGGER.debug("[ReadyScheduler] No resources to addAction");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected <T extends WorkerResourceDescription> void tryToLaunchFreeActions(List<AllocatableAction> dataFreeActions, List<AllocatableAction> resourceFreeActions, List<AllocatableAction> blockedCandidates, ResourceScheduler<T> resource) {
        if (DEBUG) {
            LOGGER.debug("[ReadyScheduler] Try to launch free actions on resource " + resource.getName());
        }
        for (AllocatableAction freeAction : dataFreeActions) {
            if (DEBUG) {
                LOGGER.debug("[ReadyScheduler] Introducing data free action " + freeAction + " into the scheduler.");
            }
            this.addActionToSchedulerStructures(freeAction);
        }
        for (AllocatableAction freeAction : resourceFreeActions) {
            if (DEBUG) {
                LOGGER.debug("[ReadyScheduler] Introducing resource free action " + freeAction + " into the scheduler.");
            }
            this.addActionToSchedulerStructures(freeAction);
        }
        for (AllocatableAction freeAction : blockedCandidates) {
            if (DEBUG) {
                LOGGER.debug("[ReadyScheduler] Introducing blocked action " + freeAction + " into the scheduler.");
            }
            this.addActionToSchedulerStructures(freeAction);
        }
        Future<?> lastToken = this.resourceTokens.get(resource);
        if (lastToken != null) {
            try {
                lastToken.get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.fatal("Unexpected thread interruption", (Throwable)e);
                ErrorManager.fatal((String)"Unexpected thread interruption", (Exception)e);
            }
        }
        Semaphore sem = new Semaphore(0);
        this.resourceTokens.put(resource, this.schedulerExecutor.submit(new WaitSchedulingRunnable(resource, sem)));
        Set<ObjectValue<AllocatableAction>> unassignedActions = ((ReadyResourceScheduler)resource).getUnassignedActions();
        if (unassignedActions != null) {
            HashSet<ObjectValue<AllocatableAction>> objectValueToErase = new HashSet<ObjectValue<AllocatableAction>>();
            Iterator<ObjectValue<AllocatableAction>> executableActionsIterator = unassignedActions.iterator();
            if (DEBUG) {
                LOGGER.debug("[ReadyScheduler]  ***** Trying to schedule " + unassignedActions.size() + " unassigned actions to " + this.availableWorkers.size() + " workers");
            }
            while (executableActionsIterator.hasNext() && !this.availableWorkers.isEmpty()) {
                ObjectValue<AllocatableAction> obj = executableActionsIterator.next();
                AllocatableAction allocatableAction = (AllocatableAction)obj.getObject();
                if (DEBUG) {
                    LOGGER.debug("[ReadyScheduler] -- Trying to schedule " + allocatableAction);
                }
                try {
                    List uselessWorkers = null;
                    if (allocatableAction.isTargetResourceEnforced()) {
                        if (!resource.canRunSomething()) throw new UnassignedActionException();
                        HashSet<ResourceScheduler<T>> resourceSet = new HashSet<ResourceScheduler<T>>();
                        resourceSet.add(resource);
                        uselessWorkers = allocatableAction.tryToSchedule(this.generateActionScore(allocatableAction), resourceSet);
                    } else {
                        uselessWorkers = allocatableAction.tryToSchedule(this.generateActionScore(allocatableAction), this.availableWorkers);
                    }
                    this.availableWorkers.removeAll(uselessWorkers);
                    ResourceScheduler assignedResource = allocatableAction.getAssignedResource();
                    this.tryToLaunch(allocatableAction);
                    if (assignedResource != null) {
                        if (DEBUG) {
                            LOGGER.debug("[ReadyScheduler] -- Action " + allocatableAction + " successfully scheduled and launched in " + assignedResource.getName());
                        }
                        if (!assignedResource.canRunSomething()) {
                            this.availableWorkers.remove(assignedResource);
                        }
                    }
                    objectValueToErase.add(obj);
                }
                catch (BlockedActionException e) {
                    if (DEBUG) {
                        LOGGER.debug("[ReadyScheduler] -- Action " + allocatableAction + " added to blocked and removed from unassigned.");
                    }
                    objectValueToErase.add(obj);
                    this.addToBlocked(allocatableAction);
                }
                catch (UnassignedActionException e) {
                    if (!DEBUG) continue;
                    LOGGER.debug("[ReadyScheduler] -- Action " + allocatableAction + " could not be assigned to any of the available resources");
                }
            }
            sem.release();
            if (DEBUG) {
                LOGGER.debug("[ReadyScheduler]  ***** Unassigned actions scheduling finished. Removing " + objectValueToErase.size() + " actions from scheduler structures.");
            }
            for (ObjectValue objectValue : objectValueToErase) {
                AllocatableAction action = (AllocatableAction)objectValue.getObject();
                this.removeActionFromSchedulerStructures(action);
            }
        }
        if (!DEBUG) return;
        LOGGER.debug("[ReadyScheduler] Try to launch free actions on resource " + resource.getName() + " finished.");
    }

    private boolean removeActionFromResource(ReadyResourceScheduler<?> scheduler, AllocatableAction action) {
        Set<ObjectValue<AllocatableAction>> actionList = scheduler.getUnassignedActions();
        ObjectValue<AllocatableAction> obj = scheduler.getAddedActions().remove(action);
        if (obj != null) {
            return actionList.remove(obj);
        }
        return false;
    }

    private boolean addActionToResource(ReadyResourceScheduler<?> scheduler, Score actionScore, AllocatableAction action) {
        Score fullScore;
        ObjectValue obj;
        Set<ObjectValue<AllocatableAction>> actionList = scheduler.getUnassignedActions();
        boolean added = actionList.add((ObjectValue<AllocatableAction>)(obj = new ObjectValue((Object)action, fullScore = action.schedulingScore(scheduler, actionScore))));
        if (added) {
            scheduler.getAddedActions().put(action, (ObjectValue<AllocatableAction>)obj);
        }
        return added;
    }

    private void updateActionInResource(ReadyResourceScheduler<?> scheduler, AllocatableAction action) {
        Score fullScore;
        boolean added;
        Set<ObjectValue<AllocatableAction>> actionList = scheduler.getUnassignedActions();
        ObjectValue obj = scheduler.getAddedActions().remove(action);
        if (obj != null && actionList.remove(obj) && (added = actionList.add((ObjectValue<AllocatableAction>)(obj = new ObjectValue((Object)action, fullScore = action.schedulingScore(scheduler, this.generateActionScore(action))))))) {
            scheduler.getAddedActions().put(action, (ObjectValue<AllocatableAction>)obj);
        }
    }

    public void upgradeAction(AllocatableAction action) {
        if (DEBUG) {
            LOGGER.debug(" Upgrading action " + action);
        }
        this.upgradedActions.add(action);
        this.updateActionToSchedulerStructures(action);
    }

    private class UpdateRunnable
    implements Runnable {
        private ReadyResourceScheduler<?> scheduler;
        private AllocatableAction action;
        private Future<?> token;

        public UpdateRunnable(ReadyResourceScheduler<?> scheduler, AllocatableAction action, Future<?> token) {
            this.scheduler = scheduler;
            this.action = action;
            this.token = token;
        }

        @Override
        public void run() {
            if (this.token != null) {
                try {
                    this.token.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    LOGGER.fatal("Unexpected thread interruption", (Throwable)e);
                    ErrorManager.fatal((String)"Unexpected thread interruption", (Exception)e);
                    Thread.currentThread().interrupt();
                }
            }
            ReadyScheduler.this.updateActionInResource(this.scheduler, this.action);
        }
    }

    private class AddRunnable
    implements Runnable {
        private ReadyResourceScheduler<?> scheduler;
        private AllocatableAction action;
        private Future<?> token;
        private Score actionScore;

        public AddRunnable(ReadyResourceScheduler<?> scheduler, Score actionScore, AllocatableAction action, Future<?> token) {
            this.scheduler = scheduler;
            this.actionScore = actionScore;
            this.action = action;
            this.token = token;
        }

        @Override
        public void run() {
            if (this.token != null) {
                try {
                    this.token.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    LOGGER.fatal("Unexpected thread interruption", (Throwable)e);
                    ErrorManager.fatal((String)"Unexpected thread interruption", (Exception)e);
                    Thread.currentThread().interrupt();
                }
            }
            ReadyScheduler.this.addActionToResource(this.scheduler, this.actionScore, this.action);
        }
    }

    private class WaitSchedulingRunnable
    implements Runnable {
        private ResourceScheduler<?> scheduler;
        private Semaphore sem;

        public WaitSchedulingRunnable(ResourceScheduler<?> resource, Semaphore sem) {
            this.scheduler = resource;
            this.sem = sem;
        }

        @Override
        public void run() {
            try {
                this.sem.acquire();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class RemoveRunnable
    implements Runnable {
        private ReadyResourceScheduler<?> scheduler;
        private AllocatableAction action;
        private Future<?> token;

        public RemoveRunnable(ReadyResourceScheduler<?> scheduler, AllocatableAction action, Future<?> token) {
            this.scheduler = scheduler;
            this.action = action;
            this.token = token;
        }

        @Override
        public void run() {
            if (this.token != null) {
                try {
                    this.token.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    LOGGER.fatal("Unexpected thread interruption", (Throwable)e);
                    ErrorManager.fatal((String)"Unexpected thread interruption", (Exception)e);
                    Thread.currentThread().interrupt();
                }
            }
            ReadyScheduler.this.removeActionFromResource(this.scheduler, this.action);
        }
    }
}

