/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.scheduler.readyScheduler;

import integratedtoolkit.components.impl.ResourceScheduler;
import integratedtoolkit.components.impl.TaskScheduler;
import integratedtoolkit.scheduler.exceptions.BlockedActionException;
import integratedtoolkit.scheduler.exceptions.UnassignedActionException;
import integratedtoolkit.scheduler.types.AllocatableAction;
import integratedtoolkit.scheduler.types.ObjectValue;
import integratedtoolkit.scheduler.types.Score;
import integratedtoolkit.types.resources.WorkerResourceDescription;
import integratedtoolkit.util.ActionSet;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ReadyScheduler
extends TaskScheduler {
    protected static final Logger LOGGER = LogManager.getLogger((String)"integratedtoolkit.Components.TaskDispatcher.TaskScheduler");
    protected final ActionSet unassignedReadyActions = new ActionSet();

    public <T extends WorkerResourceDescription> void workerLoadUpdate(ResourceScheduler<T> resource) {
    }

    public abstract Score generateActionScore(AllocatableAction var1);

    protected void scheduleAction(AllocatableAction action, Score actionScore) throws BlockedActionException {
        if (!action.hasDataPredecessors()) {
            try {
                action.schedule(actionScore);
            }
            catch (UnassignedActionException ex) {
                this.unassignedReadyActions.addAction(action);
            }
        }
    }

    protected <T extends WorkerResourceDescription> void scheduleAction(AllocatableAction action, ResourceScheduler<T> targetWorker, Score actionScore) throws BlockedActionException, UnassignedActionException {
        if (!action.hasDataPredecessors()) {
            action.schedule(targetWorker, actionScore);
        }
    }

    public List<AllocatableAction> getUnassignedActions() {
        return this.unassignedReadyActions.getAllActions();
    }

    public final <T extends WorkerResourceDescription> void handleDependencyFreeActions(List<AllocatableAction> dataFreeActions, List<AllocatableAction> resourceFreeActions, List<AllocatableAction> blockedCandidates, ResourceScheduler<T> resource) {
        this.purgeFreeActions(dataFreeActions, resourceFreeActions, blockedCandidates, resource);
        this.tryToLaunchFreeActions(dataFreeActions, resourceFreeActions, blockedCandidates, resource);
    }

    protected abstract <T extends WorkerResourceDescription> void purgeFreeActions(List<AllocatableAction> var1, List<AllocatableAction> var2, List<AllocatableAction> var3, ResourceScheduler<T> var4);

    private <T extends WorkerResourceDescription> void tryToLaunchFreeActions(List<AllocatableAction> dataFreeActions, List<AllocatableAction> resourceFreeActions, List<AllocatableAction> blockedCandidates, ResourceScheduler<T> resource) {
        ObjectValue obj;
        Score fullScore;
        Score actionScore;
        PriorityQueue<ObjectValue> executableActions = new PriorityQueue<ObjectValue>();
        for (AllocatableAction freeAction : dataFreeActions) {
            actionScore = this.generateActionScore(freeAction);
            fullScore = freeAction.schedulingScore(resource, actionScore);
            obj = new ObjectValue((Object)freeAction, fullScore);
            executableActions.add(obj);
        }
        for (AllocatableAction freeAction : resourceFreeActions) {
            obj = new ObjectValue((Object)freeAction, fullScore = freeAction.schedulingScore(resource, actionScore = this.generateActionScore(freeAction)));
            if (executableActions.contains(obj)) continue;
            executableActions.add(obj);
        }
        while (!executableActions.isEmpty()) {
            AllocatableAction freeAction;
            ObjectValue obj2 = (ObjectValue)executableActions.poll();
            freeAction = (AllocatableAction)obj2.getObject();
            try {
                this.scheduleAction(freeAction, obj2.getScore());
                this.tryToLaunch(freeAction);
            }
            catch (BlockedActionException e) {
                this.removeFromReady(freeAction);
                this.addToBlocked(freeAction);
            }
        }
    }
}

