/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.readyScheduler;

import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.components.impl.TaskScheduler;
import es.bsc.compss.scheduler.exceptions.BlockedActionException;
import es.bsc.compss.scheduler.exceptions.UnassignedActionException;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.ObjectValue;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.util.ActionSet;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ReadyScheduler
extends TaskScheduler {
    protected static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Components.TaskDispatcher.TaskScheduler");
    protected final ActionSet unassignedReadyActions = new ActionSet();

    public <T extends WorkerResourceDescription> void workerLoadUpdate(ResourceScheduler<T> resource) {
    }

    public <T extends WorkerResourceDescription> void workerFeaturesUpdate(ResourceScheduler<T> worker, T modification, List<AllocatableAction> unblockedActions, List<AllocatableAction> blockedCandidates) {
        LinkedList<AllocatableAction> dataFreeActions = new LinkedList<AllocatableAction>();
        List<AllocatableAction> resourceFreeActions = unblockedActions;
        this.purgeFreeActions(dataFreeActions, resourceFreeActions, blockedCandidates, worker);
        this.tryToLaunchFreeActions(dataFreeActions, resourceFreeActions, blockedCandidates, worker);
    }

    public abstract Score generateActionScore(AllocatableAction var1);

    protected void scheduleAction(AllocatableAction action, Score actionScore) throws BlockedActionException {
        if (!action.hasDataPredecessors() && !action.hasStreamProducers()) {
            try {
                action.schedule(actionScore);
            }
            catch (UnassignedActionException ex) {
                this.unassignedReadyActions.addAction(action);
            }
        }
    }

    protected <T extends WorkerResourceDescription> void scheduleAction(AllocatableAction action, ResourceScheduler<T> targetWorker, Score actionScore) throws BlockedActionException, UnassignedActionException {
        if (!action.hasDataPredecessors() && !action.hasStreamProducers()) {
            action.schedule(targetWorker, actionScore);
        }
    }

    public List<AllocatableAction> getUnassignedActions() {
        return this.unassignedReadyActions.getAllActions();
    }

    public final <T extends WorkerResourceDescription> void handleDependencyFreeActions(List<AllocatableAction> dataFreeActions, List<AllocatableAction> resourceFreeActions, List<AllocatableAction> blockedCandidates, ResourceScheduler<T> resource) {
        this.purgeFreeActions(dataFreeActions, resourceFreeActions, blockedCandidates, resource);
        this.tryToLaunchFreeActions(dataFreeActions, resourceFreeActions, blockedCandidates, resource);
    }

    protected abstract <T extends WorkerResourceDescription> void purgeFreeActions(List<AllocatableAction> var1, List<AllocatableAction> var2, List<AllocatableAction> var3, ResourceScheduler<T> var4);

    private <T extends WorkerResourceDescription> void tryToLaunchFreeActions(List<AllocatableAction> dataFreeActions, List<AllocatableAction> resourceFreeActions, List<AllocatableAction> blockedCandidates, ResourceScheduler<T> resource) {
        ObjectValue obj;
        Score fullScore;
        Score actionScore;
        PriorityQueue<ObjectValue> executableActions = new PriorityQueue<ObjectValue>();
        for (AllocatableAction freeAction : dataFreeActions) {
            actionScore = this.generateActionScore(freeAction);
            fullScore = freeAction.schedulingScore(resource, actionScore);
            obj = new ObjectValue((Object)freeAction, fullScore);
            executableActions.add(obj);
        }
        for (AllocatableAction freeAction : resourceFreeActions) {
            obj = new ObjectValue((Object)freeAction, fullScore = freeAction.schedulingScore(resource, actionScore = this.generateActionScore(freeAction)));
            if (executableActions.contains(obj)) continue;
            executableActions.add(obj);
        }
        while (!executableActions.isEmpty()) {
            AllocatableAction freeAction;
            ObjectValue obj2 = (ObjectValue)executableActions.poll();
            freeAction = (AllocatableAction)obj2.getObject();
            actionScore = obj2.getScore();
            try {
                this.scheduleAction(freeAction, actionScore);
                this.tryToLaunch(freeAction);
            }
            catch (BlockedActionException e) {
                blockedCandidates.add(freeAction);
            }
        }
    }
}

