/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.types;

import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.components.impl.TaskScheduler;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.fake.FakeAllocatableAction;
import es.bsc.compss.scheduler.types.fake.FakeResourceDescription;
import es.bsc.compss.scheduler.types.fake.FakeWorker;
import es.bsc.compss.types.resources.ResourceDescription;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.junit.Assert;

public abstract class Validator {
    protected final TaskScheduler ts;
    private final HashMap<FakeAllocatableAction, ActionState> actions;
    protected final HashMap<String, FakeWorker> resources;
    private final LinkedList<FakeAllocatableAction> tsBlocked;
    private final List<FakeAllocatableAction> ready;
    private final HashMap<FakeAllocatableAction, List<FakeAllocatableAction>> actionSuccessors;
    private final HashMap<FakeAllocatableAction, int[]> dependencyCount;

    public Validator(TaskScheduler ts) {
        this.ts = ts;
        this.actions = new HashMap();
        this.resources = new HashMap();
        this.actionSuccessors = new HashMap();
        this.dependencyCount = new HashMap();
        this.tsBlocked = new LinkedList();
        this.ready = new LinkedList<FakeAllocatableAction>();
    }

    public final void addResource(String name, FakeResourceDescription description) {
        FakeWorker worker = new FakeWorker(name, description, 1000);
        this.resources.put(name, worker);
        Iterator it = this.tsBlocked.iterator();
        LinkedList<FakeAllocatableAction> unblockedActions = new LinkedList<FakeAllocatableAction>();
        while (it.hasNext()) {
            FakeAllocatableAction action = (FakeAllocatableAction)((Object)it.next());
            FakeResourceDescription requirements = (FakeResourceDescription)action.getImplementations()[0].getDescription().getConstraints();
            if (description.getCoreCount() < requirements.getCoreCount()) continue;
            it.remove();
            unblockedActions.add(action);
            this.ready.add(action);
            this.actions.put(action, ActionState.READY);
        }
        this.workerAdded(worker, unblockedActions);
    }

    public abstract void workerAdded(FakeWorker var1, List<FakeAllocatableAction> var2);

    public final void removeResource(String name) {
        FakeWorker worker = this.resources.remove(name);
        Iterator<FakeAllocatableAction> it = this.ready.iterator();
        LinkedList<FakeAllocatableAction> blockedActions = new LinkedList<FakeAllocatableAction>();
        while (it.hasNext()) {
            FakeAllocatableAction action = it.next();
            FakeResourceDescription requirements = (FakeResourceDescription)action.getImplementations()[0].getDescription().getConstraints();
            boolean hasCompatibles = false;
            for (Map.Entry<String, FakeWorker> entry : this.resources.entrySet()) {
                FakeWorker w = entry.getValue();
                FakeResourceDescription description = (FakeResourceDescription)w.getDescription();
                if (description.getCoreCount() < requirements.getCoreCount()) continue;
                hasCompatibles = true;
            }
            if (hasCompatibles) continue;
            it.remove();
            this.tsBlocked.add(action);
            this.actions.put(action, ActionState.BLOCKED);
        }
        this.workerRemoved(worker, blockedActions);
    }

    public abstract void workerRemoved(FakeWorker var1, List<FakeAllocatableAction> var2);

    public final void registerAction(FakeAllocatableAction action) {
        ActionState state;
        List dataPredecessors = action.getDataPredecessors();
        LinkedList actionSuccessors = new LinkedList();
        this.actionSuccessors.put(action, actionSuccessors);
        this.dependencyCount.put(action, new int[]{dataPredecessors.size()});
        if (!action.hasDataPredecessors()) {
            FakeResourceDescription requirements = (FakeResourceDescription)action.getImplementations()[0].getDescription().getConstraints();
            boolean hasCompatibles = false;
            for (Map.Entry<String, FakeWorker> entry : this.resources.entrySet()) {
                FakeWorker worker = entry.getValue();
                FakeResourceDescription description = (FakeResourceDescription)worker.getDescription();
                if (description.getCoreCount() < requirements.getCoreCount()) continue;
                hasCompatibles = true;
            }
            if (hasCompatibles) {
                this.ready.add(action);
                state = ActionState.READY;
            } else {
                this.tsBlocked.add(action);
                state = ActionState.BLOCKED;
            }
        } else {
            for (AllocatableAction a : dataPredecessors) {
                List<FakeAllocatableAction> aSuccessors = this.actionSuccessors.get((Object)((FakeAllocatableAction)a));
                this.actionSuccessors.put((FakeAllocatableAction)a, aSuccessors);
                aSuccessors.add(action);
            }
            state = ActionState.REGISTERED;
        }
        this.actions.put(action, state);
        this.actionRegistered(action, state);
    }

    public abstract void actionRegistered(FakeAllocatableAction var1, ActionState var2);

    public void submittedAction(FakeAllocatableAction action) {
        boolean isBlocked = this.ts.getBlockedActions().contains((Object)action);
        if (action.hasDataPredecessors()) {
            Assert.assertFalse((String)((Object)((Object)action) + " is blocked and has pending data dependencies"), (boolean)isBlocked);
        } else {
            FakeResourceDescription requirements = (FakeResourceDescription)action.getImplementations()[0].getDescription().getConstraints();
            boolean hasCompatibles = false;
            for (Map.Entry<String, FakeWorker> entry : this.resources.entrySet()) {
                FakeWorker worker = entry.getValue();
                FakeResourceDescription description = (FakeResourceDescription)worker.getDescription();
                if (description.getCoreCount() < requirements.getCoreCount()) continue;
                hasCompatibles = true;
            }
            if (hasCompatibles) {
                Assert.assertFalse((String)((Object)((Object)action) + " is blocked and has compatible workers"), (boolean)isBlocked);
            } else {
                Assert.assertTrue((String)((Object)((Object)action) + " is not blocked and has  no compatible workers"), (boolean)isBlocked);
            }
        }
        this.actionSubmitted(action);
    }

    public abstract void actionSubmitted(FakeAllocatableAction var1);

    public final void executingAction(FakeAllocatableAction action) {
        this.ready.remove((Object)action);
        ResourceScheduler rs = action.getAssignedResource();
        String resourceName = rs.getName();
        FakeWorker worker = this.resources.get(resourceName);
        FakeResourceDescription available = worker.getAvailable();
        FakeResourceDescription consumption = (FakeResourceDescription)action.getResourceConsumption();
        Assert.assertTrue((String)(resourceName + " has not enough resources to host " + (Object)((Object)action)), (available.getCoreCount() >= consumption.getCoreCount() ? 1 : 0) != 0);
        available.reduceDynamic((ResourceDescription)consumption);
        this.actions.put(action, ActionState.RUNNING);
        this.actionExecuting(action, new LinkedList<FakeAllocatableAction>());
    }

    public abstract void actionExecuting(FakeAllocatableAction var1, List<FakeAllocatableAction> var2);

    public final void finishedAction(FakeAllocatableAction action) {
        Assert.assertEquals((String)("Completed action " + (Object)((Object)action) + " without being executed"), (Object)((Object)ActionState.RUNNING), (Object)((Object)this.actions.get((Object)action)));
        this.actions.put(action, ActionState.FINISHED);
        ResourceScheduler rs = action.getAssignedResource();
        String resourceName = rs.getName();
        FakeWorker worker = this.resources.get(resourceName);
        FakeResourceDescription available = worker.getAvailable();
        FakeResourceDescription consumption = (FakeResourceDescription)action.getResourceConsumption();
        available.increaseDynamic((ResourceDescription)consumption);
        LinkedList<FakeAllocatableAction> depFreeActions = new LinkedList<FakeAllocatableAction>();
        List<FakeAllocatableAction> aSuccessors = this.actionSuccessors.get((Object)action);
        for (FakeAllocatableAction successor : aSuccessors) {
            int[] predecessorsCount = this.dependencyCount.get((Object)successor);
            predecessorsCount[0] = predecessorsCount[0] - 1;
            if (predecessorsCount[0] != 0) continue;
            this.ready.add(successor);
            depFreeActions.add(successor);
            this.actions.put(successor, ActionState.READY);
        }
        this.actionFinished(action, depFreeActions);
    }

    public abstract void actionFinished(FakeAllocatableAction var1, List<FakeAllocatableAction> var2);

    public static enum ActionState {
        REGISTERED,
        BLOCKED,
        READY,
        RUNNING,
        FINISHED;

    }
}

