/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.types.fake;

import es.bsc.compss.components.impl.TaskScheduler;
import es.bsc.compss.scheduler.types.ActionOrchestrator;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.allocatableactions.StartWorkerAction;
import es.bsc.compss.worker.COMPSsException;
import java.util.concurrent.Semaphore;

public class FakeActionOrchestrator
implements ActionOrchestrator {
    private final TaskScheduler ts;
    private final Semaphore startedWorkers = new Semaphore(0);
    private final Semaphore startingWorker = new Semaphore(0);

    public FakeActionOrchestrator(TaskScheduler ts) {
        this.ts = ts;
    }

    public void actionRunning(AllocatableAction action) {
        this.ts.actionRunning(action);
    }

    public void actionCompletion(AllocatableAction action) {
        this.startingWorker.acquireUninterruptibly();
        this.ts.actionCompleted(action);
        if (action instanceof StartWorkerAction) {
            this.startedWorkers.release();
        }
    }

    public void waitForResourcesStarted() {
        this.startingWorker.release();
        this.startedWorkers.acquireUninterruptibly(1);
    }

    public void actionError(AllocatableAction action) {
        this.ts.errorOnAction(action);
    }

    public void actionException(AllocatableAction action, COMPSsException e) {
        this.ts.exceptionOnAction(action, e);
    }

    public void actionUpgrade(AllocatableAction action) {
        this.ts.upgradeAction(action);
    }
}

