/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.types.fake;

import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.resources.ResourceDescription;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class FakeResourceDescription
extends WorkerResourceDescription {
    private int coreCount = 0;

    public FakeResourceDescription(int coreCount) {
        this.coreCount = coreCount;
    }

    public boolean canHost(Implementation impl) {
        FakeResourceDescription desc = (FakeResourceDescription)impl.getRequirements();
        return this.canHost(desc);
    }

    public boolean canHost(FakeResourceDescription desc) {
        return desc.coreCount <= this.coreCount;
    }

    public boolean canHostDynamic(Implementation impl) {
        FakeResourceDescription desc = (FakeResourceDescription)impl.getRequirements();
        return desc.coreCount <= this.coreCount;
    }

    public void increase(ResourceDescription rd) {
        FakeResourceDescription desc = (FakeResourceDescription)rd;
        this.coreCount += desc.coreCount;
    }

    public void reduce(ResourceDescription rd) {
        FakeResourceDescription desc = (FakeResourceDescription)rd;
        this.coreCount -= desc.coreCount;
    }

    public void increaseDynamic(ResourceDescription rd) {
        FakeResourceDescription desc = (FakeResourceDescription)rd;
        this.coreCount += desc.coreCount;
    }

    public ResourceDescription reduceDynamic(ResourceDescription rd) {
        FakeResourceDescription desc = (FakeResourceDescription)rd;
        this.coreCount -= desc.coreCount;
        return desc;
    }

    public boolean isDynamicUseless() {
        return this.coreCount == 0;
    }

    public ResourceDescription getDynamicCommons(ResourceDescription other) {
        FakeResourceDescription otherFake = (FakeResourceDescription)other;
        int coreCommons = Math.min(this.coreCount, otherFake.coreCount);
        return new FakeResourceDescription(coreCommons);
    }

    public ResourceDescription copy() {
        return new FakeResourceDescription(this.coreCount);
    }

    public String toString() {
        return this.coreCount + " cores";
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.coreCount = in.readInt();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.coreCount);
    }

    public boolean checkEquals(FakeResourceDescription fakeResourceDescription) {
        return this.coreCount == fakeResourceDescription.coreCount;
    }

    public void mimic(ResourceDescription rd) {
        FakeResourceDescription frd = (FakeResourceDescription)rd;
        this.coreCount = frd.coreCount;
    }

    public boolean isDynamicConsuming() {
        return false;
    }

    public String getDynamicDescription() {
        return null;
    }

    public boolean usesCPUs() {
        return true;
    }

    public void scaleUpBy(int n) {
    }

    public void scaleDownBy(int n) {
    }

    public int getCoreCount() {
        return this.coreCount;
    }
}

