/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.types.fake;

import es.bsc.compss.scheduler.types.fake.FakeNode;
import es.bsc.compss.scheduler.types.fake.FakeResourceDescription;
import es.bsc.compss.types.COMPSsNode;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.ResourceDescription;
import es.bsc.compss.types.resources.ResourceType;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;

public class FakeWorker
extends Worker<FakeResourceDescription> {
    private final FakeResourceDescription available;

    public FakeWorker(String name, FakeResourceDescription description, int limitOfTasks) {
        super(name, (WorkerResourceDescription)description, (COMPSsNode)new FakeNode(name, null), limitOfTasks, null);
        this.available = new FakeResourceDescription(description.getCoreCount());
    }

    public ResourceType getType() {
        return ResourceType.WORKER;
    }

    public int compareTo(Resource rsrc) {
        return 0;
    }

    public String getMonitoringData(String prefix) {
        return "";
    }

    public boolean canRun(Implementation implementation) {
        return ((FakeResourceDescription)this.description).getCoreCount() >= ((FakeResourceDescription)implementation.getRequirements()).getCoreCount();
    }

    public Integer fitCount(Implementation impl) {
        return 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAvailable(FakeResourceDescription consumption) {
        FakeResourceDescription fakeResourceDescription = this.available;
        synchronized (fakeResourceDescription) {
            return consumption.getCoreCount() <= this.available.getCoreCount();
        }
    }

    public boolean hasAvailableSlots() {
        return true;
    }

    public FakeResourceDescription reserveResource(FakeResourceDescription consumption) {
        if (this.hasAvailable(consumption)) {
            return (FakeResourceDescription)this.available.reduceDynamic((ResourceDescription)consumption);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseResource(FakeResourceDescription consumption) {
        FakeResourceDescription fakeResourceDescription = this.available;
        synchronized (fakeResourceDescription) {
            this.available.increaseDynamic((ResourceDescription)consumption);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAllResources() {
        FakeResourceDescription fakeResourceDescription = this.available;
        synchronized (fakeResourceDescription) {
            this.available.reduceDynamic((ResourceDescription)this.available);
            this.available.increaseDynamic((ResourceDescription)this.description);
        }
    }

    public FakeWorker getSchedulingCopy() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public FakeResourceDescription getAvailable() {
        return this.available;
    }
}

