/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.types.fake;

import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.scheduler.exceptions.BlockedActionException;
import es.bsc.compss.scheduler.exceptions.FailedActionException;
import es.bsc.compss.scheduler.exceptions.UnassignedActionException;
import es.bsc.compss.scheduler.types.ActionOrchestrator;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.SchedulingInformation;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.scheduler.types.Validator;
import es.bsc.compss.scheduler.types.fake.FakeSI;
import es.bsc.compss.types.CoreElement;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.annotations.parameter.OnFailure;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.worker.COMPSsException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class FakeAllocatableAction
extends AllocatableAction {
    private Validator validator;
    private int fakeId;
    private final TaskDescription taskDescription;

    public FakeAllocatableAction(ActionOrchestrator td, int id, CoreElement ce, Validator v) {
        super((SchedulingInformation)new FakeSI(null), td);
        this.fakeId = id;
        this.taskDescription = new TaskDescription(null, null, ce.getSignature(), ce, null, false, 1, false, false, false, false, 0, null, 0L, new LinkedList());
        this.validator = v;
    }

    public int getFakeId() {
        return this.fakeId;
    }

    public void doAction() {
        this.validator.executingAction(this);
    }

    protected void doAbort() {
    }

    public void doCompleted() {
        this.validator.finishedAction(this);
    }

    public void doError() throws FailedActionException {
        throw new FailedActionException();
    }

    public void doFailed() {
    }

    protected boolean doCanceled() {
        return true;
    }

    protected void doFailIgnored() {
    }

    protected Collection<AllocatableAction> doException(COMPSsException e) {
        return new LinkedList<AllocatableAction>();
    }

    public String toString() {
        return "AllocatableAction " + this.fakeId;
    }

    public <T extends WorkerResourceDescription> List<Implementation> getCompatibleImplementations(ResourceScheduler<T> r) {
        return r.getExecutableImpls(this.taskDescription.getCoreElement().getCoreId());
    }

    public List<ResourceScheduler<? extends WorkerResourceDescription>> getCompatibleWorkers() {
        return this.getCoreElementExecutors(this.taskDescription.getCoreElement().getCoreId());
    }

    public Implementation[] getImplementations() {
        CoreElement ce = this.taskDescription.getCoreElement();
        List coreImpls = ce.getImplementations();
        int coreImplsSize = coreImpls.size();
        Implementation[] impls = new Implementation[coreImplsSize];
        for (int i = 0; i < coreImplsSize; ++i) {
            impls[i] = (Implementation)coreImpls.get(i);
        }
        return impls;
    }

    public <T extends WorkerResourceDescription> boolean isCompatible(Worker<T> r) {
        return true;
    }

    public boolean isToReserveResources() {
        return true;
    }

    public boolean isToReleaseResources() {
        return true;
    }

    public boolean isToStopResource() {
        return false;
    }

    public final <T extends WorkerResourceDescription> Score schedulingScore(ResourceScheduler<T> targetWorker, Score actionScore) {
        return targetWorker.generateResourceScore((AllocatableAction)this, this.taskDescription, actionScore);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void schedule(Score actionScore) throws BlockedActionException, UnassignedActionException {
        List<Object> candidates = new LinkedList();
        List<ResourceScheduler<? extends WorkerResourceDescription>> compatibleWorkers = this.getCompatibleWorkers();
        if (this.isTargetResourceEnforced()) {
            ResourceScheduler target = this.getEnforcedTargetResource();
            if (!compatibleWorkers.contains(target)) throw new UnassignedActionException();
            candidates.add(target);
        } else if (this.isSchedulingConstrained()) {
            for (AllocatableAction a : this.getConstrainingPredecessors()) {
                ResourceScheduler target = a.getAssignedResource();
                if (!compatibleWorkers.contains(target)) continue;
                candidates.add(target);
            }
        } else {
            candidates = compatibleWorkers;
        }
        if (candidates.isEmpty()) {
            throw new BlockedActionException();
        }
        List prevExecutors = this.getExecutingResources();
        if (candidates.size() > prevExecutors.size() && prevExecutors.size() > 0) {
            candidates.removeAll(prevExecutors);
        }
        this.scheduleSecuredCandidates(actionScore, candidates);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void schedule(Collection<ResourceScheduler<? extends WorkerResourceDescription>> candidates, Score actionScore) throws UnassignedActionException {
        List<ResourceScheduler<? extends WorkerResourceDescription>> compatibleWorkers = this.getCompatibleWorkers();
        LinkedList<ResourceScheduler<? extends WorkerResourceDescription>> verifiedCandidates = new LinkedList<ResourceScheduler<? extends WorkerResourceDescription>>();
        if (this.isTargetResourceEnforced()) {
            ResourceScheduler target = this.getEnforcedTargetResource();
            if (!candidates.contains(target) || !compatibleWorkers.contains(target)) throw new UnassignedActionException();
            verifiedCandidates.add(target);
        } else if (this.isSchedulingConstrained()) {
            for (AllocatableAction a : this.getConstrainingPredecessors()) {
                ResourceScheduler target = a.getAssignedResource();
                if (!candidates.contains(target) || !compatibleWorkers.contains(target)) continue;
                verifiedCandidates.add((ResourceScheduler<? extends WorkerResourceDescription>)target);
            }
            if (verifiedCandidates.isEmpty()) {
                throw new UnassignedActionException();
            }
        } else {
            for (ResourceScheduler<? extends WorkerResourceDescription> candidate : candidates) {
                if (!compatibleWorkers.contains(candidate) || !compatibleWorkers.contains(candidate)) continue;
                verifiedCandidates.add(candidate);
            }
            if (verifiedCandidates.isEmpty()) {
                throw new UnassignedActionException();
            }
        }
        this.scheduleSecuredCandidates(actionScore, verifiedCandidates);
    }

    public final void schedule(ResourceScheduler<? extends WorkerResourceDescription> targetWorker, Score actionScore) throws UnassignedActionException {
        if (targetWorker == null || !this.validateWorker(targetWorker)) {
            throw new UnassignedActionException();
        }
        Implementation bestImpl = null;
        Score bestScore = null;
        Score resourceScore = targetWorker.generateResourceScore((AllocatableAction)this, this.taskDescription, actionScore);
        if (resourceScore != null) {
            for (Implementation impl : this.getCompatibleImplementations(targetWorker)) {
                Score implScore = targetWorker.generateImplementationScore((AllocatableAction)this, this.taskDescription, impl, resourceScore);
                if (!Score.isBetter((Score)implScore, bestScore)) continue;
                bestImpl = impl;
                bestScore = implScore;
            }
        }
        if (bestImpl == null) {
            throw new UnassignedActionException();
        }
        this.assignWorkerAndImpl(targetWorker, bestImpl);
    }

    public final void schedule(ResourceScheduler<? extends WorkerResourceDescription> targetWorker, Implementation impl) throws UnassignedActionException {
        if (targetWorker == null || impl == null) {
            this.assignResource(null);
            throw new UnassignedActionException();
        }
        if (!this.validateWorker(targetWorker)) {
            throw new UnassignedActionException();
        }
        if (!targetWorker.getResource().canRun(impl)) {
            throw new UnassignedActionException();
        }
        this.assignWorkerAndImpl(targetWorker, impl);
    }

    private boolean validateWorker(ResourceScheduler targetCandidate) {
        if (this.isTargetResourceEnforced()) {
            ResourceScheduler enforcedTarget = this.getEnforcedTargetResource();
            if (enforcedTarget != targetCandidate) {
                return false;
            }
        } else if (this.isSchedulingConstrained()) {
            boolean isPredecessor = false;
            for (AllocatableAction a : this.getConstrainingPredecessors()) {
                ResourceScheduler predecessorHost = a.getAssignedResource();
                if (targetCandidate != predecessorHost) continue;
                isPredecessor = true;
            }
            if (!isPredecessor) {
                return false;
            }
        }
        return !this.getExecutingResources().contains(targetCandidate) || this.getCompatibleWorkers().size() <= 1;
    }

    private void scheduleSecuredCandidates(Score actionScore, List<ResourceScheduler<? extends WorkerResourceDescription>> candidates) throws UnassignedActionException {
        ResourceScheduler<? extends WorkerResourceDescription> bestWorker = null;
        Implementation bestImpl = null;
        Score bestScore = null;
        for (ResourceScheduler<? extends WorkerResourceDescription> worker : candidates) {
            Score resourceScore = worker.generateResourceScore((AllocatableAction)this, this.taskDescription, actionScore);
            if (resourceScore == null) continue;
            for (Implementation impl : this.getCompatibleImplementations(worker)) {
                Score implScore = worker.generateImplementationScore((AllocatableAction)this, this.taskDescription, impl, resourceScore);
                if (!Score.isBetter((Score)implScore, bestScore)) continue;
                bestWorker = worker;
                bestImpl = impl;
                bestScore = implScore;
            }
        }
        if (bestWorker == null) {
            throw new UnassignedActionException();
        }
        this.assignWorkerAndImpl(bestWorker, bestImpl);
    }

    private void assignWorkerAndImpl(ResourceScheduler worker, Implementation impl) {
        this.assignImplementation(impl);
        this.assignResource(worker);
        worker.scheduleAction((AllocatableAction)this);
    }

    public Integer getCoreId() {
        return this.taskDescription.getCoreElement().getCoreId();
    }

    public int getPriority() {
        return 0;
    }

    public long getGroupPriority() {
        return Long.MAX_VALUE;
    }

    public OnFailure getOnFailure() {
        return OnFailure.RETRY;
    }

    public boolean checkIfCanceled(AllocatableAction aa) {
        return false;
    }

    protected void stopAction() throws Exception {
    }
}

