/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.tracing;

import es.bsc.compss.types.tracing.ApplicationComposition;
import es.bsc.compss.types.tracing.Thread;
import es.bsc.compss.types.tracing.ThreadIdentifier;
import es.bsc.compss.types.tracing.Trace;
import es.bsc.compss.types.tracing.TraceEventType;
import es.bsc.compss.types.tracing.paraver.PRVLine;
import es.bsc.compss.types.tracing.paraver.PRVThreadIdentifier;
import es.bsc.compss.types.tracing.paraver.PRVTrace;
import es.bsc.compss.util.tracing.ThreadTranslator;
import es.bsc.compss.util.tracing.Threads;
import es.bsc.compss.util.tracing.transformations.ThreadTranslation;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PrvSorter
implements ThreadTranslator {
    protected static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Components.Tracing");
    private static final String THREAD_ID_EVENT_TYPE = Integer.toString(TraceEventType.THREAD_IDENTIFICATION.code);
    private Map<ThreadIdentifier, ThreadIdentifier> threadTranslations;
    private ApplicationComposition system;

    public PrvSorter(PRVTrace trace) throws FileNotFoundException, IOException {
        List<Machine> machines = PrvSorter.identifyThreads(trace);
        this.computeTranslationMap(machines);
    }

    private static List<Machine> identifyThreads(PRVTrace trace) throws FileNotFoundException, IOException {
        ArrayList<Machine> machines = new ArrayList<Machine>();
        try (Trace.RecordScanner events = trace.getRecords();){
            String line;
            while ((line = events.next()) != null && !line.isEmpty()) {
                PRVLine prvLine = PRVLine.parse(line);
                String identifierEventValue = prvLine.getEventValue(THREAD_ID_EVENT_TYPE);
                if (identifierEventValue == null) continue;
                PRVThreadIdentifier threadId = prvLine.getEmisorThreadIdentifier();
                int machineId = Integer.parseInt(threadId.getTask());
                while (machines.size() < machineId) {
                    machines.add(new Machine());
                }
                Machine machine = (Machine)machines.get(machineId - 1);
                machine.registerThread(threadId, identifierEventValue);
            }
        }
        return machines;
    }

    private void computeTranslationMap(List<Machine> machines) {
        this.threadTranslations = new HashMap<ThreadIdentifier, ThreadIdentifier>();
        this.system = new ApplicationComposition();
        for (int i = 0; i < machines.size(); ++i) {
            String oldLabel;
            PRVThreadIdentifier newThread;
            Threads.ExtraeTaskType task;
            ApplicationComposition runtime = new ApplicationComposition();
            String machineId = Integer.toString(i + 1);
            PRVThreadIdentifier oldMainId = new PRVThreadIdentifier("1", machineId, "1");
            PRVThreadIdentifier newMainId = PrvSorter.computeNewThreadId(oldMainId, Threads.ExtraeTaskType.RUNTIME, 1);
            this.threadTranslations.put(oldMainId, newMainId);
            String label = i == 0 ? "MAIN APP (1.1.1)" : "WORKER MAIN (" + machineId + ".1.1)";
            Thread main = new Thread(newMainId, label);
            runtime.appendComponent(main);
            Machine m = machines.get(i);
            int runtimeThreadsNum = 2;
            Map runtimeIdentifiedThreads = m.getRuntimeIdentifiers();
            for (int idEvent = 0; idEvent < Threads.EXEC.id; ++idEvent) {
                PRVThreadIdentifier oldThread = (PRVThreadIdentifier)runtimeIdentifiedThreads.get(idEvent);
                if (oldThread == null) continue;
                int threadId = runtimeThreadsNum++;
                Threads.ExtraeTaskType task2 = Threads.ExtraeTaskType.RUNTIME;
                PRVThreadIdentifier newThread2 = PrvSorter.computeNewThreadId(oldThread, task2, threadId);
                this.threadTranslations.put(oldThread, newThread2);
                String oldLabel2 = ((Object)newThread2).toString();
                String newThreadId = oldLabel2.replace(":", ".");
                String newLabel = this.createLabel(newThreadId, idEvent);
                Thread runtimeThread = new Thread(newThread2, newLabel);
                runtime.appendComponent(runtimeThread);
            }
            ApplicationComposition executors = new ApplicationComposition();
            int executorsNum = 1;
            for (PRVThreadIdentifier oldThread : m.getExecutors()) {
                int threadId = executorsNum++;
                task = Threads.ExtraeTaskType.EXECUTOR;
                newThread = PrvSorter.computeNewThreadId(oldThread, task, threadId);
                this.threadTranslations.put(oldThread, newThread);
                oldLabel = ((Object)newThread).toString();
                String newThreadId = oldLabel.replace(":", ".");
                String newLabel = this.createLabel(newThreadId, Threads.EXEC.id);
                Thread executorThread = new Thread(newThread, newLabel);
                executors.appendComponent(executorThread);
            }
            for (PRVThreadIdentifier oldThread : m.getThreads()) {
                if (this.threadTranslations.containsKey(oldThread)) continue;
                int threadId = runtimeThreadsNum++;
                task = Threads.ExtraeTaskType.RUNTIME;
                newThread = PrvSorter.computeNewThreadId(oldThread, task, threadId);
                this.threadTranslations.put(oldThread, newThread);
                oldLabel = newThread.toString();
                String newLabel = "THREAD " + oldLabel.replace(":", ".");
                Thread runtimeThread = new Thread(newThread, newLabel);
                runtime.appendComponent(runtimeThread);
            }
            ApplicationComposition machine = new ApplicationComposition();
            if (runtime.getNumberOfDirectSubcomponents() > 0) {
                machine.appendComponent(runtime);
            }
            if (executors.getNumberOfDirectSubcomponents() > 0) {
                machine.appendComponent(executors);
            }
            if (machine.getNumberOfDirectSubcomponents() <= 0) continue;
            this.system.appendComponent(machine);
        }
    }

    private static PRVThreadIdentifier computeNewThreadId(PRVThreadIdentifier id, Threads.ExtraeTaskType type, int threadId) {
        String thread = Integer.toString(threadId++);
        String task = type.getLabel();
        String app = id.getTask();
        return new PRVThreadIdentifier(app, task, thread);
    }

    public ThreadIdentifier getNewThreadId(ThreadIdentifier oldThreadId) {
        return this.threadTranslations.get(oldThreadId);
    }

    private String createLabel(String threadId, int identifierEvent) {
        String label = Threads.getLabelByID(identifierEvent);
        return label + " (" + threadId + ")";
    }

    @Override
    public ApplicationComposition getNewThreadOrganization() {
        return this.system;
    }

    public static void main(String[] args) throws Exception {
        String workingDir = args[0];
        String traceName = args[1];
        PRVTrace trace = new PRVTrace(workingDir, traceName);
        if (!trace.exists()) {
            throw new FileNotFoundException("Trace " + traceName + " not found at directory " + workingDir);
        }
        PrvSorter sorter = new PrvSorter(trace);
        trace.applyTransformations(new ThreadTranslation(sorter));
    }

    private static class Machine {
        private Map<Integer, PRVThreadIdentifier> runtimeIdentifiers;
        private Set<PRVThreadIdentifier> threads = new HashSet<PRVThreadIdentifier>();
        private Set<PRVThreadIdentifier> executors = new HashSet<PRVThreadIdentifier>();

        public Machine() {
            this.runtimeIdentifiers = new HashMap<Integer, PRVThreadIdentifier>();
        }

        private Set<PRVThreadIdentifier> getThreads() {
            return this.threads;
        }

        private Set<PRVThreadIdentifier> getExecutors() {
            return this.executors;
        }

        private Map<Integer, PRVThreadIdentifier> getRuntimeIdentifiers() {
            return this.runtimeIdentifiers;
        }

        public void registerThread(PRVThreadIdentifier threadId, String threadTypeIdString) {
            this.threads.add(threadId);
            if (threadTypeIdString != null) {
                Integer threadTypeId = new Integer(threadTypeIdString);
                if (threadTypeId == Threads.EXEC.id) {
                    this.executors.add(threadId);
                } else if (threadTypeId != 0) {
                    this.runtimeIdentifiers.put(threadTypeId, threadId);
                }
            }
        }
    }
}

