/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.tracing;

import es.bsc.compss.types.tracing.ApplicationComposition;
import es.bsc.compss.types.tracing.EventsDefinition;
import es.bsc.compss.types.tracing.InfrastructureElement;
import es.bsc.compss.types.tracing.SynchEvent;
import es.bsc.compss.types.tracing.Thread;
import es.bsc.compss.types.tracing.ThreadIdentifier;
import es.bsc.compss.types.tracing.Trace;
import es.bsc.compss.types.tracing.paraver.PRVThreadIdentifier;
import es.bsc.compss.types.tracing.paraver.PRVTrace;
import es.bsc.compss.util.tracing.ThreadTranslator;
import es.bsc.compss.util.tracing.TraceMerger;
import es.bsc.compss.util.tracing.TraceTransformation;
import es.bsc.compss.util.tracing.transformations.ThreadTranslation;
import es.bsc.compss.util.tracing.transformations.TimeOffset;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PythonTraceMerger
extends TraceMerger {
    private final Trace mergeOnTrace;

    public PythonTraceMerger(Trace[] workerTraces, Trace outputTrace) throws FileNotFoundException, IOException {
        super(workerTraces);
        LOGGER.debug("Trace's merger initialization successful");
        this.mergeOnTrace = outputTrace;
    }

    public void merge() throws Exception {
        Trace masterTrace = this.mergeOnTrace;
        String dir = masterTrace.getDirectory();
        String tmpName = masterTrace.getName() + ".tmp";
        String date = masterTrace.getDate();
        String duration = masterTrace.getDuration();
        ApplicationComposition threads = masterTrace.getThreadOrganization();
        ArrayList<InfrastructureElement> infrastructure = masterTrace.getInfrastructure();
        EventsDefinition events = masterTrace.getEventsDefinition();
        events.defineNewHWCounters(this.getAllHWCounters());
        LOGGER.debug("Parsing master sync events");
        Map<Integer, List<SynchEvent>> masterSyncEvents = masterTrace.getSyncEvents(-1);
        LOGGER.debug("Merging task traces into master which contains " + masterSyncEvents.size() + " lines.");
        TraceTransformation[][] modifications = new TraceTransformation[this.inputTraces.length + 1][];
        for (int idx = 0; idx < this.inputTraces.length; ++idx) {
            Trace workerTrace = this.inputTraces[idx];
            if (workerTrace != masterTrace) {
                Integer workerIdx;
                LOGGER.debug("Merging worker " + workerTrace);
                String workerFileName = workerTrace.getName();
                try {
                    String wID = "";
                    int i = 0;
                    while (workerFileName.charAt(i) != '_') {
                        wID = wID + workerFileName.charAt(i);
                        ++i;
                    }
                    workerIdx = Integer.parseInt(wID);
                }
                catch (Exception e) {
                    workerIdx = 0;
                }
                Integer workerID = workerIdx + 1;
                Map<Integer, List<SynchEvent>> workerSyncEvents = workerTrace.getSyncEvents(workerID);
                SynchEvent synchOffset = this.computeOffset(masterSyncEvents.get(workerID), workerSyncEvents.get(workerID));
                long timeOffset = synchOffset.getTimestamp();
                modifications[idx] = new TraceTransformation[2];
                modifications[idx][0] = new TimeOffset(timeOffset);
                PythonMergeTranslation translation = new PythonMergeTranslation(threads, workerIdx);
                modifications[idx][1] = new ThreadTranslation(translation);
                continue;
            }
            modifications[idx] = new TraceTransformation[0];
        }
        PRVTrace tmpTrace = PRVTrace.generateNew(dir, tmpName, date, duration, infrastructure, threads, events);
        PythonTraceMerger.mergeEvents(this.inputTraces, modifications, tmpTrace);
        tmpTrace.renameAs(masterTrace.getDirectory(), masterTrace.getName());
        LOGGER.debug("Merging finished.");
    }

    private SynchEvent computeOffset(List<SynchEvent> referenceSyncEvents, List<SynchEvent> localSyncEvents) throws Exception {
        if (referenceSyncEvents.size() < 3) {
            throw new Exception("ERROR: Malformed master trace. Master sync events not found");
        }
        if (localSyncEvents.size() < 3) {
            throw new Exception("ERROR: Malformed worker trace. Worker sync events not found");
        }
        SynchEvent refStart = referenceSyncEvents.get(0);
        SynchEvent refSync = referenceSyncEvents.get(2);
        SynchEvent localSync = localSyncEvents.get(2);
        Long syncDifference = Math.abs(refSync.getValue() / 1000L - localSync.getValue());
        Long realStart = Math.abs(refSync.getTimestamp() - localSync.getTimestamp()) - syncDifference;
        return new SynchEvent(refStart.getResourceId(), "", realStart, refStart.getValue());
    }

    public static void main(String[] args) throws Exception {
        String workingDir = args[0];
        String traceName = args[1];
        PRVTrace mainTrace = new PRVTrace(workingDir, traceName);
        if (!mainTrace.exists()) {
            throw new FileNotFoundException("Master trace " + traceName + " not found at directory " + workingDir);
        }
        int numPythonTraces = args.length - 2;
        if (numPythonTraces > 0) {
            Trace[] traces = new PRVTrace[numPythonTraces + 1];
            traces[0] = mainTrace;
            for (int i = 2; i < args.length; ++i) {
                File trace = new File(args[i]);
                traces[i - 1] = new PRVTrace(trace);
            }
            PythonTraceMerger merger = new PythonTraceMerger(traces, mainTrace);
            merger.merge();
        }
    }

    private static class PythonMergeTranslation
    implements ThreadTranslator {
        private final ApplicationComposition threads;
        private final ApplicationComposition task;

        public PythonMergeTranslation(ApplicationComposition threads, int workerId) {
            this.threads = threads;
            ApplicationComposition app = (ApplicationComposition)threads.getSubComponents().get(0);
            this.task = (ApplicationComposition)app.getSubComponents().get(workerId);
        }

        public ThreadIdentifier getNewThreadId(ThreadIdentifier threadId) {
            PRVThreadIdentifier prvId = (PRVThreadIdentifier)threadId;
            String oldId = prvId.getApp();
            int oldApp = Integer.parseInt(oldId);
            int newThreadId = this.task.getNumberOfDirectSubcomponents() - oldApp;
            Thread thread = (Thread)this.task.getSubComponents().get(newThreadId);
            return thread.getIdentifier();
        }

        @Override
        public ApplicationComposition getNewThreadOrganization() {
            return this.threads;
        }
    }
}

