/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.tracing.paraver;

import es.bsc.compss.types.tracing.ApplicationComposition;
import es.bsc.compss.types.tracing.ApplicationStructure;
import es.bsc.compss.types.tracing.InfrastructureElement;
import es.bsc.compss.types.tracing.Thread;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class RowFile {
    private static final String CPU_TITLE = "LEVEL CPU SIZE";
    private static final String NODE_TITLE = "LEVEL NODE SIZE";
    private static final String THREAD_TITLE = "LEVEL THREAD SIZE";

    public RowFile(String path) {
    }

    public static void updateStructuresWithRowContent(String source, ArrayList<InfrastructureElement> infrastructure, ApplicationComposition applications) throws FileNotFoundException, IOException {
        ArrayList nodes = new ArrayList();
        ArrayList<String> cpus = new ArrayList<String>();
        ArrayList threads = new ArrayList();
        File rowFile = new File(source);
        ArrayList<String> reading = null;
        try (BufferedReader br = new BufferedReader(new FileReader(rowFile));){
            String line = "";
            while ((line = br.readLine()) != null) {
                if (line.isEmpty()) continue;
                if (line.startsWith(CPU_TITLE)) {
                    reading = cpus;
                    continue;
                }
                if (line.startsWith(NODE_TITLE)) {
                    reading = nodes;
                    continue;
                }
                if (line.startsWith(THREAD_TITLE)) {
                    reading = threads;
                    continue;
                }
                reading.add(line);
            }
        }
        int globalCPUIdx = 0;
        for (int nodeIdx = 0; nodeIdx < infrastructure.size(); ++nodeIdx) {
            InfrastructureElement node = infrastructure.get(nodeIdx);
            node.setLabel((String)nodes.get(nodeIdx));
            List<InfrastructureElement> nodeCpus = node.getSubComponents();
            for (int nodeCPUIdx = 0; nodeCPUIdx < nodeCpus.size(); ++nodeCPUIdx) {
                nodeCpus.get(nodeCPUIdx).setLabel((String)cpus.get(globalCPUIdx));
                ++globalCPUIdx;
            }
        }
        int globalthreadIdx = 0;
        for (ApplicationStructure systemElement : applications.getSubComponents()) {
            ApplicationComposition app = (ApplicationComposition)systemElement;
            for (ApplicationStructure appElement : app.getSubComponents()) {
                ApplicationComposition task = (ApplicationComposition)appElement;
                for (ApplicationStructure taskElement : task.getSubComponents()) {
                    Thread thread = (Thread)taskElement;
                    thread.setLabel((String)threads.get(globalthreadIdx++));
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void generateRowFile(ArrayList<InfrastructureElement> infrastructure, ApplicationComposition application, String target) throws IOException {
        void var9_14;
        int i;
        File outputFile = new File(target);
        if (outputFile.exists()) {
            outputFile.delete();
            outputFile.createNewFile();
        }
        LinkedList<String> cpus = new LinkedList<String>();
        ArrayList<String> nodes = new ArrayList<String>(infrastructure.size());
        for (InfrastructureElement node : infrastructure) {
            nodes.add(node.getLabel());
            for (InfrastructureElement infrastructureElement : node.getSubComponents()) {
                cpus.add(infrastructureElement.getLabel());
            }
        }
        PrintWriter rowWriter = new PrintWriter(new FileWriter(outputFile.getAbsolutePath(), false));
        rowWriter.println("LEVEL CPU SIZE " + cpus.size());
        for (i = 0; i < cpus.size(); ++i) {
            rowWriter.println((String)cpus.get(i));
        }
        rowWriter.println();
        rowWriter.println("LEVEL NODE SIZE " + nodes.size());
        for (i = 0; i < nodes.size(); ++i) {
            rowWriter.println((String)nodes.get(i));
        }
        rowWriter.println();
        List<String> threads = application.getAllLabels();
        ArrayList<String> newThreads = new ArrayList<String>();
        for (String label : threads) {
            newThreads.add(label);
        }
        newThreads.sort(new RowThreadIdComparator());
        rowWriter.println("LEVEL THREAD SIZE " + newThreads.size());
        boolean bl = false;
        while (var9_14 < newThreads.size()) {
            rowWriter.println((String)newThreads.get((int)var9_14));
            ++var9_14;
        }
        rowWriter.close();
    }

    private static class RowThreadIdComparator
    implements Comparator<String> {
        private RowThreadIdComparator() {
        }

        @Override
        public int compare(String a, String b) {
            a = a.startsWith("THREAD ") ? a.substring(7, a.length()) : a.substring(a.indexOf("(") + 1, a.indexOf(")"));
            b = b.startsWith("THREAD ") ? b.substring(7, b.length()) : b.substring(b.indexOf("(") + 1, b.indexOf(")"));
            String[] valuesA = a.split("\\.");
            String[] valuesB = b.split("\\.");
            for (int i = 0; i < 3; ++i) {
                int intB;
                int intA = Integer.parseInt(valuesA[i]);
                if (intA > (intB = Integer.parseInt(valuesB[i]))) {
                    return 1;
                }
                if (intA >= intB) continue;
                return -1;
            }
            return 0;
        }
    }
}

