/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.tracing.paraver;

import es.bsc.compss.types.tracing.SynchEvent;
import es.bsc.compss.types.tracing.TraceEventType;
import es.bsc.compss.types.tracing.paraver.PRVThreadIdentifier;
import es.bsc.compss.util.tracing.EventTranslator;
import es.bsc.compss.util.tracing.ThreadTranslator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PRVLine {
    protected static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Components.Tracing");
    private static final Integer SYNC_TYPE = TraceEventType.SYNC.code;
    private static final String SYNC_REGEX = "(^\\d+:\\d+:\\d+):(\\d+):(\\d+):(\\d+).*:" + SYNC_TYPE + ":(\\d+)";
    private static final Pattern SYNC_PATTERN = Pattern.compile(SYNC_REGEX);
    private static final Integer R_ID_INDEX = 1;
    private static final Integer TIMESTAMP_INDEX = 4;
    private static final Integer WORKER_ID_INDEX = 2;
    private static final Integer VALUE_INDEX = 5;
    public static final int EVENT_TYPE_POS = 0;
    public static final int EMISOR_CPU_ID_POS = 1;
    public static final int EMISOR_APP_POS = 2;
    public static final int EMISOR_TASK_POS = 3;
    public static final int EMISOR_THREAD_POS = 4;
    public static final int TIMESTAMP_POS = 5;
    protected String[] values;

    private PRVLine(String[] values) {
        this.values = values;
    }

    public static PRVLine parse(String line) {
        PRVLine parsedLine;
        String[] values = line.split(":");
        switch (values[0]) {
            case "1": {
                parsedLine = new StatePRVLine(values);
                break;
            }
            case "2": {
                parsedLine = new EventPRVLine(values);
                break;
            }
            case "3": {
                parsedLine = new CommPRVLine(values);
                break;
            }
            default: {
                parsedLine = null;
            }
        }
        return parsedLine;
    }

    public static final SynchEvent parseSynchEvent(String line) {
        SynchEvent event = null;
        Matcher m = SYNC_PATTERN.matcher(line);
        if (m.find()) {
            String workerId = m.group(WORKER_ID_INDEX);
            String resourceID = m.group(R_ID_INDEX);
            Long timestamp = Long.parseLong(m.group(TIMESTAMP_INDEX));
            Long value = Long.parseLong(m.group(VALUE_INDEX));
            event = new SynchEvent(resourceID, workerId, timestamp, value);
        }
        return event;
    }

    public void applyCPUOffset(int offset) {
        this.values[1] = PRVLine.computeOffset(this.values[1], offset);
    }

    public PRVThreadIdentifier getEmisorThreadIdentifier() {
        String machine = this.values[2];
        String task = this.values[3];
        String thread = this.values[4];
        return new PRVThreadIdentifier(machine, task, thread);
    }

    private void setEmisorThreadIdentifier(PRVThreadIdentifier id) {
        this.values[2] = id.getApp();
        this.values[3] = id.getTask();
        this.values[4] = id.getThread();
    }

    public String getEventValue(String type) {
        return null;
    }

    public void translateEventsFromGroup(String eventGroupIdentifier, EventTranslator<String> translator) {
    }

    public void applyTimeOffset(long offset) {
        this.values[5] = PRVLine.computeOffset(this.values[5], offset);
    }

    public void translateLineThreads(ThreadTranslator<PRVThreadIdentifier> translator) {
        PRVThreadIdentifier threadId = this.getEmisorThreadIdentifier();
        if ((threadId = translator.getNewThreadId(threadId)) != null) {
            this.setEmisorThreadIdentifier(threadId);
        }
    }

    private static String computeOffset(String original, long offset) {
        return Long.toString(Long.parseLong(original) + offset);
    }

    public String toString() {
        return String.join((CharSequence)":", this.values);
    }

    public boolean goesBefore(String otherLine) {
        if (otherLine == null) {
            return false;
        }
        return this.goesBefore(PRVLine.parse(otherLine));
    }

    public boolean goesBefore(PRVLine otherLine) {
        int typeB;
        long timeB;
        long timeA = new Long(this.values[5]);
        if (timeA < (timeB = new Long(otherLine.values[5]).longValue())) {
            return true;
        }
        if (timeA > timeB) {
            return false;
        }
        int typeA = new Integer(this.values[0]);
        return typeA <= (typeB = new Integer(otherLine.values[0]).intValue());
    }

    private static class CommPRVLine
    extends PRVLine {
        private static final int COM_EMISSOR_END_TIMESTAMP_POS = 6;
        private static final int COM_RECIV_CPU_ID_POS = 7;
        private static final int COM_RECIV_MACHINE_POS = 8;
        private static final int COM_RECIV_RUNTIME_EXECUTOR_POS = 9;
        private static final int COM_RECIV_THREAD_NUMBER_POS = 10;
        private static final int COM_RECIV_START_TIMESTAMP_POS = 11;
        private static final int COM_REVIC_END_TIMESTAMP_POS = 12;
        private static final int COM_SIZE_POS = 13;
        private static final int COM_TAG_POS = 14;

        private CommPRVLine(String[] values) {
            super(values);
        }

        @Override
        public void applyCPUOffset(int offset) {
            super.applyCPUOffset(offset);
            this.values[7] = PRVLine.computeOffset(this.values[7], offset);
        }

        private PRVThreadIdentifier getComRecivThreadIdentifier() {
            String machine = this.values[8];
            String task = this.values[9];
            String thread = this.values[10];
            return new PRVThreadIdentifier(machine, task, thread);
        }

        private void setComRecivThreadIdentifier(PRVThreadIdentifier id) {
            this.values[8] = id.getApp();
            this.values[9] = id.getTask();
            this.values[10] = id.getThread();
        }

        @Override
        public void translateLineThreads(ThreadTranslator<PRVThreadIdentifier> translator) {
            super.translateLineThreads(translator);
            PRVThreadIdentifier recivThreadId = this.getComRecivThreadIdentifier();
            recivThreadId = translator.getNewThreadId(recivThreadId);
            if (recivThreadId != null) {
                this.setComRecivThreadIdentifier(recivThreadId);
            }
        }

        @Override
        public void applyTimeOffset(long offset) {
            super.applyTimeOffset(offset);
            this.values[6] = PRVLine.computeOffset(this.values[6], offset);
            this.values[11] = PRVLine.computeOffset(this.values[11], offset);
            this.values[12] = PRVLine.computeOffset(this.values[12], offset);
            this.values[6] = this.values[6] + offset;
            this.values[11] = this.values[11] + offset;
            this.values[12] = this.values[12] + offset;
        }
    }

    private static class EventPRVLine
    extends PRVLine {
        private static final int STATE_EVENTS_START_POS = 6;

        private EventPRVLine(String[] values) {
            super(values);
        }

        @Override
        public String getEventValue(String type) {
            String result = null;
            for (int i = 6; i < this.values.length; i += 2) {
                if (this.values[i].compareTo(type) != 0) continue;
                result = this.values[i + 1];
            }
            return result;
        }

        @Override
        public void translateEventsFromGroup(String eventGroupIdentifier, EventTranslator<String> translator) {
            for (int i = 6; i < this.values.length; i += 2) {
                String globalValue;
                if (!eventGroupIdentifier.equals(this.values[i])) continue;
                String eventValue = this.values[i + 1];
                this.values[i + 1] = globalValue = translator.translateEvent(eventValue);
            }
        }
    }

    private static class StatePRVLine
    extends PRVLine {
        private static final int END_TIMESTAMP_POS = 6;
        private static final int STATE_POS = 7;

        private StatePRVLine(String[] values) {
            super(values);
        }

        @Override
        public void applyTimeOffset(long offset) {
            super.applyTimeOffset(offset);
            this.values[6] = PRVLine.computeOffset(this.values[6], offset);
        }
    }
}

