/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.tracing.paraver;

import es.bsc.compss.types.tracing.ThreadIdentifier;
import java.util.Objects;

public class PRVThreadIdentifier
extends ThreadIdentifier {
    private String app;
    private String task;
    private String thread;

    public PRVThreadIdentifier(int app, int task, int thread) {
        this(Integer.toString(app), Integer.toString(task), Integer.toString(thread));
    }

    public PRVThreadIdentifier(String app, String task, String thread) {
        this.app = app;
        this.task = task;
        this.thread = thread;
    }

    public String getApp() {
        return this.app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public String getTask() {
        return this.task;
    }

    public void setTask(String task) {
        this.task = task;
    }

    public String getThread() {
        return this.thread;
    }

    public void setThread(String thread) {
        this.thread = thread;
    }

    public String toString() {
        return this.app + ":" + this.task + ":" + this.thread;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PRVThreadIdentifier other = (PRVThreadIdentifier)obj;
        if (!Objects.equals(this.app, other.app)) {
            return false;
        }
        if (!Objects.equals(this.task, other.task)) {
            return false;
        }
        return Objects.equals(this.thread, other.thread);
    }

    @Override
    public int getIdAtLevel(int level) {
        switch (level) {
            case 0: {
                return Integer.parseInt(this.app);
            }
            case 1: {
                return Integer.parseInt(this.task);
            }
            case 2: {
                return Integer.parseInt(this.thread);
            }
        }
        return -1;
    }
}

