/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.tracing;

import es.bsc.compss.types.tracing.ApplicationComposition;
import es.bsc.compss.types.tracing.Thread;
import es.bsc.compss.types.tracing.ThreadIdentifier;
import es.bsc.compss.types.tracing.Threads;
import es.bsc.compss.types.tracing.Trace;
import es.bsc.compss.types.tracing.TraceEventType;
import es.bsc.compss.types.tracing.paraver.PRVLine;
import es.bsc.compss.types.tracing.paraver.PRVThreadIdentifier;
import es.bsc.compss.types.tracing.paraver.PRVTrace;
import es.bsc.compss.util.tracing.ThreadTranslator;
import es.bsc.compss.util.tracing.transformations.ThreadTranslation;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PrvSorter
implements ThreadTranslator {
    protected static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Components.Tracing");
    private static final String THREAD_ID_EVENT_TYPE = Integer.toString(TraceEventType.THREAD_IDENTIFICATION.code);
    private static final String EXEC_ID_EVENT_TYPE = Integer.toString(TraceEventType.EXECUTOR_IDENTIFICATION.code);
    private Map<ThreadIdentifier, ThreadIdentifier> threadTranslations;
    private ApplicationComposition system;

    public PrvSorter(PRVTrace trace) throws FileNotFoundException, IOException {
        List<Machine> machines = PrvSorter.identifyThreads(trace);
        this.computeTranslationMap(machines);
    }

    private static List<Machine> identifyThreads(PRVTrace trace) throws FileNotFoundException, IOException {
        ArrayList<Machine> machines = new ArrayList<Machine>();
        try (Trace.RecordScanner events = trace.getRecords();){
            String line;
            while ((line = events.next()) != null && !line.isEmpty()) {
                String executorIdValue;
                PRVLine prvLine = PRVLine.parse(line);
                PRVThreadIdentifier threadId = prvLine.getEmisorThreadIdentifier();
                int machineId = Integer.parseInt(threadId.getTask());
                while (machines.size() < machineId) {
                    machines.add(new Machine());
                }
                Machine machine = (Machine)machines.get(machineId - 1);
                machine.registerThread(threadId);
                String identifierEventValue = prvLine.getEventValue(THREAD_ID_EVENT_TYPE);
                if (identifierEventValue != null) {
                    machine.identifiedThreadFunction(threadId, identifierEventValue);
                }
                if ((executorIdValue = prvLine.getEventValue(EXEC_ID_EVENT_TYPE)) == null) continue;
                machine.identifiedExecutor(threadId, executorIdValue);
            }
        }
        return machines;
    }

    private void computeTranslationMap(List<Machine> machines) {
        this.threadTranslations = new HashMap<ThreadIdentifier, ThreadIdentifier>();
        this.system = new ApplicationComposition();
        for (int i = 0; i < machines.size(); ++i) {
            ApplicationComposition runtime = new ApplicationComposition();
            String machineId = Integer.toString(i + 1);
            PRVThreadIdentifier oldMainId = new PRVThreadIdentifier("1", machineId, "1");
            PRVThreadIdentifier newMainId = PrvSorter.computeNewThreadId(oldMainId, Threads.ExtraeTaskType.RUNTIME, 1);
            this.threadTranslations.put(oldMainId, newMainId);
            String label = i == 0 ? "MAIN APP (1.1.1)" : "WORKER MAIN (" + machineId + ".1.1)";
            Thread main = new Thread(newMainId, label);
            runtime.appendComponent(main);
            Machine m = machines.get(i);
            int runtimeThreadsNum = 2;
            Map runtimeIdentifiedThreads = m.getRuntimeIdentifiers();
            for (Threads threads : Threads.values()) {
                int idEvent;
                PRVThreadIdentifier oldThread;
                if (!threads.isRuntime() || (oldThread = (PRVThreadIdentifier)runtimeIdentifiedThreads.get(idEvent = threads.id)) == null) continue;
                int threadId = runtimeThreadsNum++;
                Threads.ExtraeTaskType task = Threads.ExtraeTaskType.RUNTIME;
                PRVThreadIdentifier newThread = PrvSorter.computeNewThreadId(oldThread, task, threadId);
                this.threadTranslations.put(oldThread, newThread);
                String oldLabel = ((Object)newThread).toString();
                String newThreadId = oldLabel.replace(":", ".");
                String newLabel = this.createLabel(newThreadId, idEvent);
                Thread runtimeThread = new Thread(newThread, newLabel);
                runtime.appendComponent(runtimeThread);
            }
            ApplicationComposition executors = new ApplicationComposition();
            TreeSet<Map.Entry<PRVThreadIdentifier, String>> tree = new TreeSet<Map.Entry<PRVThreadIdentifier, String>>(new Comparator<Map.Entry<PRVThreadIdentifier, String>>(){

                @Override
                public int compare(Map.Entry<PRVThreadIdentifier, String> t, Map.Entry<PRVThreadIdentifier, String> t1) {
                    int tVal = Integer.parseInt(t.getValue());
                    int t1Val = Integer.parseInt(t1.getValue());
                    return Integer.compare(tVal, t1Val);
                }
            });
            for (Map.Entry entry : m.getKnownExecutors().entrySet()) {
                tree.add(entry);
            }
            for (Map.Entry<Object, Object> entry : tree) {
                PRVThreadIdentifier oldThread = (PRVThreadIdentifier)entry.getKey();
                int threadId = Integer.parseInt((String)entry.getValue());
                Threads.ExtraeTaskType task = Threads.ExtraeTaskType.EXECUTOR;
                PRVThreadIdentifier newThread = PrvSorter.computeNewThreadId(oldThread, task, threadId + 1);
                this.threadTranslations.put(oldThread, newThread);
                String oldLabel = ((Object)newThread).toString();
                String newThreadId = oldLabel.replace(":", ".");
                String newLabel = this.createLabel(newThreadId, Threads.EXEC.id);
                Thread executorThread = new Thread(newThread, newLabel);
                executors.appendComponent(executorThread);
            }
            for (PRVThreadIdentifier pRVThreadIdentifier : m.getThreads()) {
                if (this.threadTranslations.containsKey(pRVThreadIdentifier)) continue;
                int threadId = runtimeThreadsNum++;
                Threads.ExtraeTaskType task = Threads.ExtraeTaskType.RUNTIME;
                PRVThreadIdentifier newThread = PrvSorter.computeNewThreadId(pRVThreadIdentifier, task, threadId);
                this.threadTranslations.put(pRVThreadIdentifier, newThread);
                String oldLabel = newThread.toString();
                String newLabel = "THREAD " + oldLabel.replace(":", ".");
                Thread runtimeThread = new Thread(newThread, newLabel);
                runtime.appendComponent(runtimeThread);
            }
            ApplicationComposition machine = new ApplicationComposition();
            if (runtime.getNumberOfDirectSubcomponents() > 0) {
                machine.appendComponent(runtime);
            }
            if (executors.getNumberOfDirectSubcomponents() > 0) {
                machine.appendComponent(executors);
            }
            if (machine.getNumberOfDirectSubcomponents() <= 0) continue;
            this.system.appendComponent(machine);
        }
    }

    private static PRVThreadIdentifier computeNewThreadId(PRVThreadIdentifier id, Threads.ExtraeTaskType type, int threadId) {
        String thread = Integer.toString(threadId);
        String task = type.getLabel();
        String app = id.getTask();
        return new PRVThreadIdentifier(app, task, thread);
    }

    public ThreadIdentifier getNewThreadId(ThreadIdentifier oldThreadId) {
        return this.threadTranslations.get(oldThreadId);
    }

    private String createLabel(String threadId, int identifierEvent) {
        String label = Threads.getLabelByID((int)identifierEvent);
        return label + " (" + threadId + ")";
    }

    @Override
    public ApplicationComposition getNewThreadOrganization() {
        return this.system;
    }

    @Override
    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<ThreadIdentifier, ThreadIdentifier> entry : this.threadTranslations.entrySet()) {
            sb.append("\t * ").append(entry.getKey()).append("->").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        String workingDir = args[0];
        String traceName = args[1];
        PRVTrace trace = new PRVTrace(workingDir, traceName);
        if (!trace.exists()) {
            throw new FileNotFoundException("Trace " + traceName + " not found at directory " + workingDir);
        }
        PrvSorter sorter = new PrvSorter(trace);
        ThreadTranslation mod = new ThreadTranslation(sorter);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(mod.getDescription());
        }
        trace.applyTransformations(mod);
    }

    private static class Machine {
        private Map<Integer, PRVThreadIdentifier> runtimeIdentifiers;
        private Set<PRVThreadIdentifier> threads = new HashSet<PRVThreadIdentifier>();
        private Map<PRVThreadIdentifier, String> knownExecutors;
        private Set<PRVThreadIdentifier> unknownExecutors = new HashSet<PRVThreadIdentifier>();

        public Machine() {
            this.knownExecutors = new HashMap<PRVThreadIdentifier, String>();
            this.runtimeIdentifiers = new HashMap<Integer, PRVThreadIdentifier>();
        }

        private Set<PRVThreadIdentifier> getThreads() {
            return this.threads;
        }

        private Set<PRVThreadIdentifier> getUnknownExecutors() {
            return this.unknownExecutors;
        }

        private Map<PRVThreadIdentifier, String> getKnownExecutors() {
            return this.knownExecutors;
        }

        private Map<Integer, PRVThreadIdentifier> getRuntimeIdentifiers() {
            return this.runtimeIdentifiers;
        }

        public void registerThread(PRVThreadIdentifier threadId) {
            this.threads.add(threadId);
        }

        public void identifiedThreadFunction(PRVThreadIdentifier threadId, String function) {
            if (function != null) {
                Integer threadTypeId = new Integer(function);
                if (threadTypeId == Threads.EXEC.id) {
                    if (this.knownExecutors.get(threadId) != null) {
                        this.unknownExecutors.add(threadId);
                    }
                } else if (threadTypeId != 0) {
                    this.runtimeIdentifiers.put(threadTypeId, threadId);
                }
            }
        }

        public void identifiedExecutor(PRVThreadIdentifier threadId, String executorId) {
            this.unknownExecutors.remove(threadId);
            this.knownExecutors.put(threadId, executorId);
        }
    }
}

