/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.tracing;

import java.util.LinkedList;
import java.util.List;

public class InfrastructureElement {
    private final List<InfrastructureElement> components;
    private String label;

    public InfrastructureElement(String label) {
        this.label = label;
        this.components = new LinkedList<InfrastructureElement>();
    }

    public void appendComponent(InfrastructureElement c) {
        this.components.add(c);
    }

    public List<InfrastructureElement> getSubComponents() {
        return this.components;
    }

    public int getNumberOfDirectSubcomponents() {
        return this.components.size();
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public String print(String pad) {
        StringBuilder s = new StringBuilder(pad + this.label + "\n");
        for (InfrastructureElement component : this.components) {
            s.append(component.print(pad + "\t"));
        }
        return s.toString();
    }
}

