/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.tracing.paraver;

import es.bsc.compss.types.tracing.EventsDefinition;
import es.bsc.compss.types.tracing.MalformedException;
import es.bsc.compss.types.tracing.TraceEventType;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class PcfFile
implements EventsDefinition {
    private static final String EVENT_TYPE_HEADER = "EVENT_TYPE";
    private static final String VALUES_HEADER = "VALUES";
    private static final String ID_VALUE_SEPARATOR = "      ";
    private static final String CE_TYPE_DEFINITION = "0    " + TraceEventType.TASKS_FUNC.code + "    Task";
    private static final String HW_TYPE_DEFINITION = "7  41999999 Active hardware counter set";
    private static final String HW_COUNTER_LINE_HEADER = "7  4200";
    private final String original;
    private boolean checkedOriginal = false;
    private boolean hasCEsDefined = false;
    private boolean changedCEs = false;
    private Map<String, String> originalCEs = new HashMap<String, String>();
    private Map<String, String> newCEs = new HashMap<String, String>();
    private boolean hasHWCountersDefined = false;
    private List<String> originalHWCounters = new ArrayList<String>();
    private List<String> newHWCounters = new LinkedList<String>();

    public PcfFile(String original) {
        this.original = new File(original).getAbsolutePath();
    }

    public String getPath() {
        return this.original;
    }

    private void parse() throws IOException, MalformedException {
        List<String> lines = Files.readAllLines(Paths.get(this.original, new String[0]), StandardCharsets.UTF_8);
        Iterator<String> linesItr = lines.iterator();
        String line = null;
        boolean hasContent = false;
        if (linesItr.hasNext()) {
            line = linesItr.next();
            hasContent = true;
        }
        while (hasContent && line != null) {
            if (line.startsWith(EVENT_TYPE_HEADER)) {
                String header = linesItr.next();
                if (HW_TYPE_DEFINITION.compareTo(header) == 0) {
                    this.hasHWCountersDefined = true;
                    this.parseHWCounters(linesItr);
                } else if (CE_TYPE_DEFINITION.compareTo(header) == 0) {
                    this.hasCEsDefined = true;
                    this.parseCEs(linesItr);
                }
            }
            if (linesItr.hasNext()) {
                line = linesItr.next();
                continue;
            }
            hasContent = false;
        }
        this.checkedOriginal = true;
    }

    private void parseCEs(Iterator<String> linesItr) throws MalformedException {
        Pattern numberPattern = Pattern.compile("[0-9]+");
        boolean endedParsing = false;
        while (linesItr.hasNext() && !endedParsing) {
            String line = linesItr.next();
            if (line.isEmpty()) {
                endedParsing = true;
                continue;
            }
            if (line.compareTo(VALUES_HEADER) == 0) continue;
            String[] values = line.split(ID_VALUE_SEPARATOR);
            if (values.length != 2 || values[1].isEmpty() || !numberPattern.matcher(values[0]).matches()) {
                throw new MalformedException("ERROR: Malformed CE in PFC " + this.original + "  line: " + line);
            }
            this.originalCEs.put(values[0], values[1]);
        }
    }

    private void parseHWCounters(Iterator<String> linesItr) {
        boolean endedParsing = false;
        while (linesItr.hasNext() && !endedParsing) {
            String line = linesItr.next();
            if (line.isEmpty()) {
                endedParsing = true;
                continue;
            }
            if (line.compareTo(VALUES_HEADER) == 0 || !line.startsWith(HW_COUNTER_LINE_HEADER)) continue;
            this.originalHWCounters.add(line);
        }
    }

    @Override
    public Map<String, String> getCEsMapping() throws IOException, MalformedException {
        if (!this.checkedOriginal) {
            this.parse();
        }
        return this.originalCEs;
    }

    @Override
    public List<String> getHWCounters() throws IOException, MalformedException {
        if (!this.checkedOriginal) {
            this.parse();
        }
        return this.originalHWCounters;
    }

    public void create() throws IOException {
        File f = new File(this.original);
        if (!f.exists()) {
            f.createNewFile();
        }
    }

    @Override
    public void redefineCEs(Map<String, String> cores) {
        this.newCEs = cores;
    }

    @Override
    public void defineNewHWCounters(Collection<String> newHWCounters) {
        for (String newHWCounter : newHWCounters) {
            for (String originalHWCounter : this.originalHWCounters) {
                if (originalHWCounter.compareTo(newHWCounter) == 0) continue;
                newHWCounters.add(newHWCounter);
            }
        }
    }

    public void saveToFile(String location) throws IOException {
        boolean appendedHWCounters = false;
        List<String> lines = Files.readAllLines(Paths.get(this.original, new String[0]), StandardCharsets.UTF_8);
        String targetPath = new File(location).getAbsolutePath();
        try (PrintWriter pcfWriter = new PrintWriter(new FileWriter(targetPath, false));){
            Iterator<String> linesItr = lines.iterator();
            while (linesItr.hasNext()) {
                String line = linesItr.next();
                if (line.startsWith(EVENT_TYPE_HEADER)) {
                    pcfWriter.println(line);
                    String header = linesItr.next();
                    pcfWriter.println(header);
                    if (HW_TYPE_DEFINITION.compareTo(header) == 0) {
                        this.copyEventValues(linesItr, pcfWriter);
                        this.appendNewHWCounters(pcfWriter);
                        appendedHWCounters = true;
                        pcfWriter.println();
                        continue;
                    }
                    if (CE_TYPE_DEFINITION.compareTo(header) != 0 || this.newCEs.isEmpty()) continue;
                    this.skipEventValues(linesItr);
                    pcfWriter.println(VALUES_HEADER);
                    this.appendCEs(pcfWriter);
                    pcfWriter.println();
                    continue;
                }
                pcfWriter.println(line);
            }
            if (!this.newHWCounters.isEmpty() && !appendedHWCounters) {
                if (!this.hasHWCountersDefined) {
                    pcfWriter.println(EVENT_TYPE_HEADER);
                    pcfWriter.println(HW_TYPE_DEFINITION);
                    pcfWriter.println(VALUES_HEADER);
                }
                this.appendNewHWCounters(pcfWriter);
            }
        }
        this.checkedOriginal = false;
    }

    private void skipEventValues(Iterator<String> linesItr) {
        boolean endedParsing = false;
        while (linesItr.hasNext() && !endedParsing) {
            String line = linesItr.next();
            if (!line.isEmpty()) continue;
            endedParsing = true;
        }
    }

    private void copyEventValues(Iterator<String> linesItr, PrintWriter pw) {
        while (linesItr.hasNext()) {
            String line = linesItr.next();
            if (line.isEmpty()) {
                return;
            }
            pw.println(line);
        }
    }

    private void appendCEs(PrintWriter writer) {
        for (Map.Entry<String, String> ce : this.newCEs.entrySet()) {
            writer.println(ce.getValue() + ID_VALUE_SEPARATOR + ce.getKey());
        }
    }

    private void appendNewHWCounters(PrintWriter writer) {
        for (String line : this.newHWCounters) {
            writer.println(line);
        }
    }

    public static void generatePCFFile(EventsDefinition definitions, String pcfFilePath) throws IOException {
        ((PcfFile)definitions).saveToFile(pcfFilePath);
    }
}

