/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.tracing;

import es.bsc.compss.types.tracing.ApplicationComposition;
import es.bsc.compss.types.tracing.ApplicationStructure;
import es.bsc.compss.types.tracing.EventsDefinition;
import es.bsc.compss.types.tracing.InfrastructureElement;
import es.bsc.compss.types.tracing.SynchEvent;
import es.bsc.compss.types.tracing.Thread;
import es.bsc.compss.types.tracing.ThreadIdentifier;
import es.bsc.compss.types.tracing.Threads;
import es.bsc.compss.types.tracing.Trace;
import es.bsc.compss.types.tracing.TraceEventType;
import es.bsc.compss.types.tracing.paraver.PRVLine;
import es.bsc.compss.types.tracing.paraver.PRVThreadIdentifier;
import es.bsc.compss.types.tracing.paraver.PRVTrace;
import es.bsc.compss.util.tracing.ThreadTranslator;
import es.bsc.compss.util.tracing.TraceMerger;
import es.bsc.compss.util.tracing.TraceTransformation;
import es.bsc.compss.util.tracing.transformations.ThreadTranslation;
import es.bsc.compss.util.tracing.transformations.TimeOffset;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class PythonTraceMerger
extends TraceMerger {
    private final Trace mergeOnTrace;
    private static final String THREAD_ID_EVENT_TYPE = Integer.toString(TraceEventType.THREAD_IDENTIFICATION.code);
    private static final String EXEC_ID_EVENT_TYPE = Integer.toString(TraceEventType.EXECUTOR_IDENTIFICATION.code);

    public PythonTraceMerger(Trace[] workerTraces, Trace outputTrace) throws FileNotFoundException, IOException {
        super(workerTraces);
        LOGGER.debug("Trace's merger initialization successful");
        this.mergeOnTrace = outputTrace;
    }

    public void merge() throws Exception {
        Trace masterTrace = this.mergeOnTrace;
        String dir = masterTrace.getDirectory();
        String tmpName = masterTrace.getName() + ".tmp";
        String date = masterTrace.getDate();
        String duration = masterTrace.getDuration();
        ApplicationComposition masterThreads = masterTrace.getThreadOrganization();
        ArrayList<InfrastructureElement> infrastructure = masterTrace.getInfrastructure();
        EventsDefinition events = masterTrace.getEventsDefinition();
        events.defineNewHWCounters(this.getAllHWCounters());
        LOGGER.debug("Parsing master sync events");
        Map<Integer, List<SynchEvent>> masterSyncEvents = masterTrace.getSyncEvents(-1);
        LOGGER.debug("Merging task traces into master which contains " + masterSyncEvents.size() + " lines.");
        int numApps = masterThreads.getSubComponents().size();
        ThreadIdentifier[][][] executorIds = new ThreadIdentifier[masterThreads.getSubComponents().size()][][];
        for (int appId = 0; appId < numApps; ++appId) {
            ApplicationComposition app = (ApplicationComposition)masterThreads.getSubComponents().get(appId);
            int numWorkers = app.getSubComponents().size();
            executorIds[appId] = new ThreadIdentifier[numWorkers][];
            for (int workerId = 0; workerId < numWorkers; ++workerId) {
                ApplicationComposition worker = (ApplicationComposition)app.getSubComponents().get(workerId);
                int numThreads = worker.getSubComponents().size();
                executorIds[appId][workerId] = new ThreadIdentifier[numThreads];
            }
        }
        try (Trace.RecordScanner records = masterTrace.getRecords();){
            String line;
            while ((line = records.next()) != null && !line.isEmpty()) {
                PRVLine prvLine = PRVLine.parse(line);
                String executorIdValue = prvLine.getEventValue(EXEC_ID_EVENT_TYPE);
                if (executorIdValue == null) continue;
                PRVThreadIdentifier threadId = prvLine.getEmisorThreadIdentifier();
                int appId = Integer.parseInt(threadId.getApp()) - 1;
                int workerId = Integer.parseInt(threadId.getTask()) - 1;
                int executorId = Integer.parseInt(executorIdValue);
                executorIds[appId][workerId][executorId] = threadId;
            }
        }
        TraceTransformation[][] modifications = new TraceTransformation[this.inputTraces.length + 1][];
        for (int idx = 0; idx < this.inputTraces.length; ++idx) {
            Trace workerTrace = this.inputTraces[idx];
            if (workerTrace != masterTrace) {
                Integer workerIdx;
                LOGGER.debug("Merging worker " + workerTrace);
                String workerFileName = workerTrace.getName();
                try {
                    String wID = "";
                    int i = 0;
                    while (workerFileName.charAt(i) != '_') {
                        wID = wID + workerFileName.charAt(i);
                        ++i;
                    }
                    workerIdx = Integer.parseInt(wID);
                }
                catch (Exception e) {
                    workerIdx = 0;
                }
                Integer workerID = workerIdx + 1;
                Map<Integer, List<SynchEvent>> workerSyncEvents = workerTrace.getSyncEvents(workerID);
                SynchEvent synchOffset = this.computeOffset(masterSyncEvents.get(workerID), workerSyncEvents.get(workerID));
                long timeOffset = synchOffset.getTimestamp();
                modifications[idx] = new TraceTransformation[2];
                modifications[idx][0] = new TimeOffset(timeOffset);
                HashMap<PRVThreadIdentifier, Integer> pythonRuntime = new HashMap<PRVThreadIdentifier, Integer>();
                HashMap<PRVThreadIdentifier, String> pythonExecutors = new HashMap<PRVThreadIdentifier, String>();
                try (Trace.RecordScanner records = workerTrace.getRecords();){
                    String line;
                    while ((line = records.next()) != null && !line.isEmpty()) {
                        String executorIdValue;
                        PRVLine prvLine = PRVLine.parse(line);
                        String identifierEventValue = prvLine.getEventValue(THREAD_ID_EVENT_TYPE);
                        if (identifierEventValue != null) {
                            PRVThreadIdentifier threadId = prvLine.getEmisorThreadIdentifier();
                            Integer threadTypeId = new Integer(identifierEventValue);
                            if (threadTypeId != Threads.EXEC.id) {
                                pythonRuntime.put(threadId, threadTypeId);
                            }
                        }
                        if ((executorIdValue = prvLine.getEventValue(EXEC_ID_EVENT_TYPE)) == null) continue;
                        PRVThreadIdentifier threadId = prvLine.getEmisorThreadIdentifier();
                        pythonExecutors.put(threadId, executorIdValue);
                    }
                }
                ThreadIdentifier[] wExec2Thread = executorIds[0][workerIdx];
                ApplicationComposition pyThreads = workerTrace.getThreadOrganization();
                PythonMergeTranslation translation = new PythonMergeTranslation(masterThreads, pyThreads, workerIdx, pythonRuntime, pythonExecutors, wExec2Thread);
                modifications[idx][1] = new ThreadTranslation(translation);
                continue;
            }
            modifications[idx] = new TraceTransformation[0];
        }
        if (LOGGER.isDebugEnabled()) {
            for (int i = 0; i < this.inputTraces.length; ++i) {
                LOGGER.debug("*** Modifications applied to trace " + this.inputTraces[i].getName());
                for (TraceTransformation mod : modifications[i]) {
                    LOGGER.debug(mod.getDescription());
                }
            }
        }
        PRVTrace tmpTrace = PRVTrace.generateNew(dir, tmpName, date, duration, infrastructure, masterThreads, events);
        PythonTraceMerger.mergeEvents(this.inputTraces, modifications, tmpTrace);
        tmpTrace.renameAs(masterTrace.getDirectory(), masterTrace.getName());
        LOGGER.debug("Merging finished.");
    }

    private SynchEvent computeOffset(List<SynchEvent> referenceSyncEvents, List<SynchEvent> localSyncEvents) throws Exception {
        if (referenceSyncEvents.size() < 3) {
            throw new Exception("ERROR: Malformed master trace. Master sync events not found");
        }
        if (localSyncEvents.size() < 3) {
            throw new Exception("ERROR: Malformed worker trace. Worker sync events not found");
        }
        SynchEvent refStart = referenceSyncEvents.get(0);
        SynchEvent refSync = referenceSyncEvents.get(2);
        SynchEvent localSync = localSyncEvents.get(2);
        Long syncDifference = Math.abs(refSync.getValue() / 1000L - localSync.getValue());
        Long realStart = Math.abs(refSync.getTimestamp() - localSync.getTimestamp()) - syncDifference;
        return new SynchEvent(refStart.getResourceId(), "", realStart, refStart.getValue());
    }

    public static void main(String[] args) throws Exception {
        String workingDir = args[0];
        String traceName = args[1];
        PRVTrace mainTrace = new PRVTrace(workingDir, traceName);
        if (!mainTrace.exists()) {
            throw new FileNotFoundException("Master trace " + traceName + " not found at directory " + workingDir);
        }
        int numPythonTraces = args.length - 2;
        if (numPythonTraces > 0) {
            Trace[] traces = new PRVTrace[numPythonTraces + 1];
            traces[0] = mainTrace;
            for (int i = 2; i < args.length; ++i) {
                File trace = new File(args[i]);
                traces[i - 1] = new PRVTrace(trace);
            }
            PythonTraceMerger merger = new PythonTraceMerger(traces, mainTrace);
            merger.merge();
        }
    }

    private static class PythonMergeTranslation
    implements ThreadTranslator {
        private final ApplicationComposition threads;
        private final ApplicationComposition task;
        private final ThreadIdentifier[] appToExec;

        public PythonMergeTranslation(ApplicationComposition mainTO, ApplicationComposition pyTO, int workerId, HashMap<PRVThreadIdentifier, Integer> pythonRuntime, HashMap<PRVThreadIdentifier, String> pythonExecutors, ThreadIdentifier[] exec2Thread) {
            this.threads = mainTO;
            ApplicationComposition app = (ApplicationComposition)mainTO.getSubComponents().get(0);
            this.task = (ApplicationComposition)app.getSubComponents().get(workerId);
            int numMainThreads = this.task.getSubComponents().size();
            int numPyThreads = 0;
            HashSet<PRVThreadIdentifier> unknownThreads = new HashSet<PRVThreadIdentifier>();
            for (ApplicationStructure applicationStructure : pyTO.getSubComponents()) {
                ApplicationComposition pyApp = (ApplicationComposition)applicationStructure;
                for (ApplicationStructure tk : pyApp.getSubComponents()) {
                    ApplicationComposition pyTask = (ApplicationComposition)tk;
                    for (ApplicationStructure t : pyTask.getSubComponents()) {
                        Thread thread = (Thread)t;
                        PRVThreadIdentifier tId = (PRVThreadIdentifier)thread.getIdentifier();
                        unknownThreads.add(tId);
                        ++numPyThreads;
                    }
                }
            }
            this.appToExec = new ThreadIdentifier[numPyThreads];
            for (Map.Entry entry : pythonExecutors.entrySet()) {
                PRVThreadIdentifier id = (PRVThreadIdentifier)entry.getKey();
                int appId = Integer.parseInt(id.getApp()) - 1;
                int executorId = Integer.parseInt((String)entry.getValue());
                this.appToExec[appId] = exec2Thread[executorId];
                unknownThreads.remove(id);
            }
            Thread refThread = (Thread)this.task.getSubComponents().get(0);
            PRVThreadIdentifier pRVThreadIdentifier = (PRVThreadIdentifier)refThread.getIdentifier();
            String refLabel = refThread.getLabel();
            String refApp = pRVThreadIdentifier.getApp();
            String refTask = pRVThreadIdentifier.getTask();
            for (Map.Entry<PRVThreadIdentifier, Integer> entry : pythonRuntime.entrySet()) {
                PRVThreadIdentifier pythonId = entry.getKey();
                unknownThreads.remove(pythonId);
                String newThreadId = Integer.toString(numMainThreads + 1);
                PRVThreadIdentifier newId = new PRVThreadIdentifier(refApp, refTask, newThreadId);
                String newLabel = refLabel.substring(0, refLabel.length() - 1) + newThreadId;
                this.task.appendComponent(new Thread(newId, newLabel));
                ++numMainThreads;
                int appId = Integer.parseInt(pythonId.getApp()) - 1;
                this.appToExec[appId] = newId;
            }
            for (PRVThreadIdentifier pythonId : unknownThreads) {
                String newThreadId = Integer.toString(numMainThreads + 1);
                PRVThreadIdentifier newId = new PRVThreadIdentifier(refApp, refTask, newThreadId);
                String newLabel = refLabel.substring(0, refLabel.length() - 1) + newThreadId;
                this.task.appendComponent(new Thread(newId, newLabel));
                ++numMainThreads;
                int appId = Integer.parseInt(pythonId.getApp()) - 1;
                this.appToExec[appId] = newId;
            }
        }

        public ThreadIdentifier getNewThreadId(ThreadIdentifier threadId) {
            PRVThreadIdentifier prvId = (PRVThreadIdentifier)threadId;
            String oldId = prvId.getApp();
            int appId = Integer.parseInt(oldId) - 1;
            return this.appToExec[appId];
        }

        @Override
        public ApplicationComposition getNewThreadOrganization() {
            return this.threads;
        }

        @Override
        public String getDescription() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.appToExec.length; ++i) {
                ThreadIdentifier tid = this.appToExec[i];
                sb.append("\t * ").append(i + 1).append(".1.1").append("->").append(tid).append("\n");
            }
            return sb.toString();
        }
    }
}

