/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.tracing.paraver;

import es.bsc.compss.types.tracing.ApplicationComposition;
import es.bsc.compss.types.tracing.ApplicationStructure;
import es.bsc.compss.types.tracing.InfrastructureElement;
import es.bsc.compss.types.tracing.MalformedException;
import es.bsc.compss.types.tracing.Thread;
import es.bsc.compss.types.tracing.paraver.PRVThreadIdentifier;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PRVHeader {
    private static final String MALFORMED_HEADER = "Prv header doesn't have the expected format";
    private static final String MALFORMED_HEADER_PARTS = "Prv header doesn't have the expected format (wrong number of parts)";
    private static final String SPLIT_HEADER_REGEX = ":\\s*(?![^()]*\\))";
    public static final Pattern INSIDE_PARENTHESIS_PATTERN = Pattern.compile("\\(.+\\)");
    protected static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Components.Tracing");
    private String date;
    private String duration;
    private ArrayList<InfrastructureElement> infrastructureOrganization;
    private ApplicationComposition threadOrganization;

    public PRVHeader(String header) throws MalformedException {
        String[] headerParts;
        if (header.endsWith(",0")) {
            header = header.substring(0, header.length() - 2);
        }
        if ((headerParts = header.split(SPLIT_HEADER_REGEX)).length < 4) {
            throw new MalformedException("Prv header doesn't have the expected format (wrong number of parts): " + header);
        }
        this.date = this.getInsideParenthesis(headerParts[0]);
        this.duration = headerParts[1];
        String[] cpusPerNode = this.getInsideParenthesis(headerParts[2]).split(",");
        int numNodes = cpusPerNode.length;
        this.infrastructureOrganization = new ArrayList(numNodes);
        for (int nodeIdx = 0; nodeIdx < numNodes; ++nodeIdx) {
            InfrastructureElement node = new InfrastructureElement("NODE" + nodeIdx);
            this.infrastructureOrganization.add(node);
            for (int cpuIdx = 0; cpuIdx < Integer.parseInt(cpusPerNode[nodeIdx]); ++cpuIdx) {
                InfrastructureElement cpu = new InfrastructureElement("cpu" + nodeIdx + "." + cpuIdx);
                node.appendComponent(cpu);
            }
        }
        this.threadOrganization = new ApplicationComposition();
        String systemDescription = headerParts[4];
        Matcher m = Pattern.compile("\\((.*?)\\)").matcher(systemDescription);
        int appId = 1;
        while (m.find()) {
            ApplicationComposition app = new ApplicationComposition();
            String appDescription = m.group(1);
            String[] taskDescriptions = appDescription.split(",");
            int taskId = 1;
            for (String taskDescription : taskDescriptions) {
                ApplicationComposition task = new ApplicationComposition();
                String[] threads = taskDescription.split(":");
                int numThreads = Integer.parseInt(threads[0]);
                for (int threadId = 0; threadId < numThreads; ++threadId) {
                    PRVThreadIdentifier threadIdentifier = new PRVThreadIdentifier(appId, taskId, threadId + 1);
                    Thread thread = new Thread(threadIdentifier, "");
                    task.appendComponent(thread);
                }
                app.appendComponent(task);
                ++taskId;
            }
            this.threadOrganization.appendComponent(app);
            ++appId;
        }
    }

    public String getDate() {
        return this.date;
    }

    public String getDuration() {
        return this.duration;
    }

    public ArrayList<InfrastructureElement> getInfrastructure() {
        return this.infrastructureOrganization;
    }

    public ApplicationComposition getThreadOrganization() {
        return this.threadOrganization;
    }

    private String getInsideParenthesis(String block) {
        Matcher numThreadMatcher = INSIDE_PARENTHESIS_PATTERN.matcher(block);
        numThreadMatcher.find();
        String inside = numThreadMatcher.group(0);
        inside = inside.substring(1, inside.length() - 1);
        return inside;
    }

    public String toString() {
        return PRVHeader.generateTraceHeader(this.date, this.duration, this.infrastructureOrganization, this.threadOrganization);
    }

    public void setStructure(ArrayList<InfrastructureElement> cpusPerNode, ApplicationComposition system) {
        this.infrastructureOrganization = cpusPerNode;
        this.threadOrganization = system;
    }

    public static String generateTraceHeader(String date, String duration, ArrayList<InfrastructureElement> infrastructureOrganization, ApplicationComposition threadOrganization) {
        ArrayList<String> cpusPerNode = new ArrayList<String>();
        for (InfrastructureElement node : infrastructureOrganization) {
            cpusPerNode.add(Integer.toString(node.getNumberOfDirectSubcomponents()));
        }
        int numNode = 1;
        ArrayList<String> tasksPerApp = new ArrayList<String>();
        for (ApplicationStructure systemComponent : threadOrganization.getSubComponents()) {
            ApplicationComposition app = (ApplicationComposition)systemComponent;
            ArrayList<String> threadsPerTask = new ArrayList<String>();
            for (ApplicationStructure appComponent : app.getSubComponents()) {
                ApplicationComposition task = (ApplicationComposition)appComponent;
                int numThreadsPerTask = task.getNumberOfDirectSubcomponents();
                threadsPerTask.add(numThreadsPerTask + ":" + numNode);
            }
            int numTasks = app.getNumberOfDirectSubcomponents();
            String taskDescription = numTasks + "(" + String.join((CharSequence)",", threadsPerTask) + ")";
            tasksPerApp.add(taskDescription);
            ++numNode;
        }
        String nodesString = cpusPerNode.size() + "(" + String.join((CharSequence)",", cpusPerNode) + ")";
        String applicationsString = tasksPerApp.size() + ":" + String.join((CharSequence)",", tasksPerApp);
        return "#Paraver (" + date + "):" + duration + ":" + nodesString + ":" + applicationsString;
    }
}

