/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.tracing;

import es.bsc.compss.types.tracing.ApplicationStructure;
import java.util.LinkedList;
import java.util.List;

public class ApplicationComposition<T extends ApplicationStructure>
implements ApplicationStructure {
    private final List<T> components = new LinkedList<T>();

    public void appendComponent(T c) {
        this.components.add(c);
    }

    public void replaceSubcomponents(List<T> subComponents) {
        this.components.clear();
        this.components.addAll(subComponents);
    }

    public List<T> getSubComponents() {
        return this.components;
    }

    @Override
    public int getNumberOfDirectSubcomponents() {
        return this.components.size();
    }

    @Override
    public int getNumberOfTotalLowestSubcomponents() {
        int total = 0;
        for (ApplicationStructure component : this.components) {
            total += component.getNumberOfTotalLowestSubcomponents();
        }
        return total;
    }

    @Override
    public List<String> getAllLabels() {
        LinkedList<String> labels = new LinkedList<String>();
        for (ApplicationStructure component : this.components) {
            labels.addAll(component.getAllLabels());
        }
        return labels;
    }

    @Override
    public void print(String pad) {
        System.out.println(pad + "-");
        for (ApplicationStructure component : this.components) {
            component.print(pad + "\t");
        }
    }
}

