/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.tracing.paraver;

import es.bsc.compss.types.tracing.ApplicationComposition;
import es.bsc.compss.types.tracing.CPU;
import es.bsc.compss.types.tracing.MalformedException;
import es.bsc.compss.types.tracing.SystemComposition;
import es.bsc.compss.types.tracing.SystemStructure;
import es.bsc.compss.types.tracing.Thread;
import es.bsc.compss.types.tracing.paraver.PRVApplication;
import es.bsc.compss.types.tracing.paraver.PRVNode;
import es.bsc.compss.types.tracing.paraver.PRVTask;
import es.bsc.compss.types.tracing.paraver.PRVThreadIdentifier;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PRVHeader {
    private static final String MALFORMED_HEADER = "Prv header doesn't have the expected format";
    private static final String MALFORMED_HEADER_PARTS = "Prv header doesn't have the expected format (wrong number of parts)";
    private static final String SPLIT_HEADER_REGEX = ":\\s*(?![^()]*\\))";
    public static final Pattern INSIDE_PARENTHESIS_PATTERN = Pattern.compile("\\(.+\\)");
    protected static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Components.Tracing");
    private String date;
    private String duration;
    private SystemComposition<PRVNode> infrastructureOrganization;
    private ApplicationComposition<PRVApplication> threadOrganization;

    public PRVHeader(String header) throws MalformedException {
        String[] headerParts;
        if (header.endsWith(",0")) {
            header = header.substring(0, header.length() - 2);
        }
        if ((headerParts = header.split(SPLIT_HEADER_REGEX)).length < 4) {
            throw new MalformedException("Prv header doesn't have the expected format (wrong number of parts): " + header);
        }
        this.date = this.getInsideParenthesis(headerParts[0]);
        this.duration = headerParts[1];
        String[] cpusPerNode = this.getInsideParenthesis(headerParts[2]).split(",");
        int numNodes = cpusPerNode.length;
        this.infrastructureOrganization = new SystemComposition("");
        for (int nodeIdx = 0; nodeIdx < numNodes; ++nodeIdx) {
            PRVNode node = new PRVNode(nodeIdx, "NODE" + nodeIdx);
            this.infrastructureOrganization.appendComponent(node);
            for (int cpuIdx = 0; cpuIdx < Integer.parseInt(cpusPerNode[nodeIdx]); ++cpuIdx) {
                CPU cpu = new CPU("cpu" + nodeIdx + "." + cpuIdx);
                node.appendComponent(cpu);
            }
        }
        this.threadOrganization = new ApplicationComposition();
        String systemDescription = headerParts[4];
        Matcher m = Pattern.compile("\\((.*?)\\)").matcher(systemDescription);
        int appId = 1;
        while (m.find()) {
            PRVApplication app = new PRVApplication();
            String appDescription = m.group(1);
            String[] taskDescriptions = appDescription.split(",");
            int taskId = 1;
            for (String taskDescription : taskDescriptions) {
                PRVTask task = new PRVTask();
                String[] threads = taskDescription.split(":");
                int numThreads = Integer.parseInt(threads[0]);
                int numNode = Integer.parseInt(threads[1]);
                for (int threadId = 0; threadId < numThreads; ++threadId) {
                    PRVThreadIdentifier threadIdentifier = new PRVThreadIdentifier(appId, taskId, threadId + 1);
                    Thread<PRVThreadIdentifier> thread = new Thread<PRVThreadIdentifier>(threadIdentifier, "");
                    task.appendComponent(thread);
                }
                PRVNode node = this.infrastructureOrganization.getSubComponents().get(numNode - 1);
                task.setNode(node);
                app.appendComponent(task);
                ++taskId;
            }
            this.threadOrganization.appendComponent(app);
            ++appId;
        }
    }

    public String getDate() {
        return this.date;
    }

    public String getDuration() {
        return this.duration;
    }

    public SystemComposition getInfrastructure() {
        return this.infrastructureOrganization;
    }

    public ApplicationComposition getThreadOrganization() {
        return this.threadOrganization;
    }

    private String getInsideParenthesis(String block) {
        Matcher numThreadMatcher = INSIDE_PARENTHESIS_PATTERN.matcher(block);
        numThreadMatcher.find();
        String inside = numThreadMatcher.group(0);
        inside = inside.substring(1, inside.length() - 1);
        return inside;
    }

    public String toString() {
        return PRVHeader.generateTraceHeader(this.date, this.duration, this.infrastructureOrganization, this.threadOrganization);
    }

    public void setStructure(SystemComposition cpusPerNode, ApplicationComposition system) {
        this.infrastructureOrganization = cpusPerNode;
        this.threadOrganization = system;
    }

    public static String generateTraceHeader(String date, String duration, SystemComposition<PRVNode> infrastructureOrganization, ApplicationComposition<PRVApplication> threadOrganization) {
        ArrayList<String> cpusPerNode = new ArrayList<String>();
        for (SystemStructure systemStructure : infrastructureOrganization.getSubComponents()) {
            cpusPerNode.add(Integer.toString(systemStructure.getNumberOfDirectSubcomponents()));
        }
        ArrayList<String> tasksPerApp = new ArrayList<String>();
        for (PRVApplication app : threadOrganization.getSubComponents()) {
            ArrayList<String> threadsPerTask = new ArrayList<String>();
            for (PRVTask task : app.getSubComponents()) {
                int numThreadsPerTask = task.getNumberOfDirectSubcomponents();
                PRVNode node = task.getNode();
                int numNode = node.getNodeId() + 1;
                threadsPerTask.add(numThreadsPerTask + ":" + numNode);
            }
            int numTasks = app.getNumberOfDirectSubcomponents();
            String taskDescription = numTasks + "(" + String.join((CharSequence)",", threadsPerTask) + ")";
            tasksPerApp.add(taskDescription);
        }
        String string = cpusPerNode.size() + "(" + String.join((CharSequence)",", cpusPerNode) + ")";
        String applicationsString = tasksPerApp.size() + ":" + String.join((CharSequence)",", tasksPerApp);
        return "#Paraver (" + date + "):" + duration + ":" + string + ":" + applicationsString;
    }
}

