/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.tracing;

import es.bsc.compss.types.tracing.SystemStructure;
import java.util.LinkedList;
import java.util.List;

public class SystemComposition<T extends SystemStructure>
implements SystemStructure {
    private final List<T> components;
    private String label;

    public SystemComposition(String label) {
        this.label = label;
        this.components = new LinkedList<T>();
    }

    public void appendComponent(T c) {
        this.components.add(c);
    }

    public List<T> getSubComponents() {
        return this.components;
    }

    @Override
    public int getNumberOfDirectSubcomponents() {
        return this.components.size();
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    public String print(String pad) {
        StringBuilder s = new StringBuilder(pad + this.label + "\n");
        for (SystemStructure component : this.components) {
            s.append(component.print(pad + "\t"));
        }
        return s.toString();
    }
}

