/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.loader.total;

import es.bsc.compss.loader.LoaderAPI;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ObjectRegistry {
    private LoaderAPI itApi;
    private String serialDir;
    private static final String EMPTY = "EMPTY";
    private Map<Integer, Object> appTaskObjects;
    private Map<Integer, Object> internalObjects;
    private static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Loader");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();

    public ObjectRegistry(LoaderAPI api) {
        this.itApi = api;
        this.serialDir = api.getTempDir();
        this.appTaskObjects = new TreeMap<Integer, Object>();
        this.internalObjects = new TreeMap<Integer, Object>();
        this.itApi.setObjectRegistry(this);
    }

    public int newObjectParameter(Object obj) {
        if (obj == null) {
            return Integer.MAX_VALUE;
        }
        int objHashCode = obj.hashCode();
        int finalHashCode = this.checkHashCode(obj, objHashCode);
        if (DEBUG) {
            LOGGER.debug("Object " + obj + " with hash code " + finalHashCode + " registered");
        }
        return finalHashCode;
    }

    private int checkHashCode(Object obj, int objHashCode) {
        Object objStored = this.appTaskObjects.get(objHashCode);
        while (objStored != obj) {
            if (objStored == null || objStored == EMPTY) {
                this.appTaskObjects.put(objHashCode, obj);
                this.internalObjects.put(objHashCode, obj);
                break;
            }
            objStored = this.appTaskObjects.get(++objHashCode);
        }
        return objHashCode;
    }

    public void newObjectAccess(Object o) {
        this.newObjectAccess(o, true);
    }

    public void newObjectAccess(Object o, boolean isWriter) {
        Object oUpdated;
        if (o == null) {
            return;
        }
        int hashCode = o.hashCode();
        Object oStored = this.appTaskObjects.get(hashCode);
        while (oStored != o) {
            if (oStored == null) {
                return;
            }
            oStored = this.appTaskObjects.get(++hashCode);
        }
        if (DEBUG) {
            LOGGER.debug("New access to object with hash code " + hashCode + ", for writing: " + isWriter);
        }
        if ((oUpdated = this.itApi.getObject(o, hashCode, this.serialDir)) != null) {
            this.internalObjects.put(hashCode, oUpdated);
        }
    }

    public void serializeLocally(Object o) {
        if (o == null) {
            return;
        }
        int hashCode = o.hashCode();
        Object oStored = this.appTaskObjects.get(hashCode);
        while (oStored != o) {
            if (oStored == null) {
                return;
            }
            oStored = this.appTaskObjects.get(++hashCode);
        }
        if (DEBUG) {
            LOGGER.debug("About to serialize locally object with hash code " + hashCode);
        }
        this.itApi.serializeObject(this.internalObjects.get(hashCode), hashCode, this.serialDir);
    }

    public Object getInternalObject(Object o) {
        if (o == null) {
            return null;
        }
        int hashCode = o.hashCode();
        Object oStored = this.appTaskObjects.get(hashCode);
        while (oStored != o) {
            if (oStored == null) {
                return null;
            }
            oStored = this.appTaskObjects.get(++hashCode);
        }
        Object internal = this.internalObjects.get(hashCode);
        if (DEBUG) {
            LOGGER.debug("Returning internal object " + internal + " with hash code " + hashCode);
        }
        return internal;
    }

    public boolean delete(Object o) {
        if (o == null) {
            return false;
        }
        int hashCode = o.hashCode();
        Object oStored = this.appTaskObjects.get(hashCode);
        while (oStored != o) {
            if (oStored == null) {
                return false;
            }
            oStored = this.appTaskObjects.get(++hashCode);
        }
        if (DEBUG) {
            LOGGER.debug("About to serialize locally object with hash code " + hashCode);
        }
        this.itApi.removeObject(o, hashCode);
        return this.deleteFromInternal(hashCode) && this.deleteFromApps(hashCode);
    }

    public boolean deleteFromInternal(int hashcode) {
        Object to_delete = this.internalObjects.get(hashcode);
        if (to_delete != null) {
            this.internalObjects.remove(hashcode);
            return true;
        }
        return false;
    }

    public boolean deleteFromApps(int hashcode) {
        Object to_delete = this.appTaskObjects.get(hashcode);
        if (to_delete != null) {
            this.appTaskObjects.put(hashcode, EMPTY);
            return true;
        }
        return false;
    }
}

