/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util;

import es.bsc.compss.components.impl.TaskScheduler;
import es.bsc.compss.scheduler.types.Profile;
import es.bsc.compss.scheduler.types.WorkloadState;
import es.bsc.compss.types.CloudProvider;
import es.bsc.compss.types.ResourceCreationRequest;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.MethodImplementation;
import es.bsc.compss.types.resources.CloudMethodWorker;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.components.Processor;
import es.bsc.compss.types.resources.description.CloudImageDescription;
import es.bsc.compss.types.resources.description.CloudInstanceTypeDescription;
import es.bsc.compss.types.resources.description.CloudMethodResourceDescription;
import es.bsc.compss.util.CoreManager;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.ResourceManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class ResourceOptimizer
extends Thread {
    private static final String WARN_NO_RESOURCE_MATCHES = "WARN: No resource matches the constraints";
    private static final String WARN_NO_COMPATIBLE_TYPE = "WARN: Cannot find any compatible instanceType";
    private static final String WARN_NO_COMPATIBLE_IMAGE = "WARN: Cannot find any compatible Image";
    private static final String WARN_NO_VALID_INSTANCE = "WARN: Cannot find a containing/contained instanceType";
    private static final String WARN_NO_MORE_INSTANCES = "WARN: Cloud Provider cannot host more instances";
    private static final String WARN_NO_POSIBLE_INCREASE = "WARN: Cloud Provider cannot increase resources";
    private static final String WARN_EXCEPTION_TURN_ON = "WARN: Connector exception on turn on resource";
    protected static final Logger RESOURCES_LOGGER = LogManager.getLogger((String)"es.bsc.compss.Resources");
    protected static final Logger RUNTIME_LOGGER = LogManager.getLogger((String)"es.bsc.compss.Components.ResourceManager");
    protected static final boolean DEBUG = RUNTIME_LOGGER.isDebugEnabled();
    private static final int SLEEP_TIME = 2000;
    private static final int EVERYTHING_BLOCKED_INTERVAL_TIME = 20000;
    private static final int EVERYTHING_BLOCKED_MAX_RETRIES = 3;
    private static final String ERROR_OPT_RES = "Error optimizing resources.";
    private static final String PERSISTENT_BLOCK_ERR = "Unschedulable tasks detected.\nCOMPSs has found tasks with constraints that cannot be fulfilled.\nShutting down COMPSs now...";
    protected final TaskScheduler ts;
    private boolean running;
    private static boolean cleanUp;
    private static boolean redo;
    private int everythingBlockedRetryCount = -1;
    private long lastPotentialBlockedCheck = System.currentTimeMillis();
    private Map<CloudInstanceTypeDescription, CloudTypeProfile> defaultProfiles;

    public ResourceOptimizer(TaskScheduler ts) {
        if (DEBUG) {
            RUNTIME_LOGGER.debug("[Resource Optimizer] Initializing Resource Optimizer");
        }
        this.setName("ResourceOptimizer");
        this.ts = ts;
        redo = false;
        this.defaultProfiles = new HashMap<CloudInstanceTypeDescription, CloudTypeProfile>();
        for (CloudProvider cp : ResourceManager.getAvailableCloudProviders()) {
            for (CloudInstanceTypeDescription citd : cp.getAllTypes()) {
                JSONObject citdJSON = ts.getJSONForCloudInstanceTypeDescription(cp, citd);
                JSONObject implsJSON = ts.getJSONForImplementations();
                CloudTypeProfile prof = this.generateCloudTypeProfile(citdJSON, implsJSON);
                this.defaultProfiles.put(citd, prof);
                RUNTIME_LOGGER.debug("[ResourceOptimizer] JSONProfile for " + citd.getName() + " --> " + citdJSON);
            }
        }
        RUNTIME_LOGGER.info("[Resource Optimizer] Initialization finished");
    }

    protected CloudTypeProfile generateCloudTypeProfile(JSONObject citdJSON, JSONObject implsJSON) {
        return new CloudTypeProfile(citdJSON, implsJSON);
    }

    protected CloudTypeProfile getCloudTypeProfile(CloudInstanceTypeDescription citd) {
        return this.defaultProfiles.get(citd);
    }

    public void coreElementsUpdated() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        this.running = true;
        if (ResourceManager.useCloud()) {
            if (CoreManager.getCoreCount() <= 0) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            RUNTIME_LOGGER.info("[Resource Optimizer] Checking initial creations.");
            this.initialCreations();
        }
        while (this.running) {
            try {
                if (CoreManager.getCoreCount() > 0) {
                    do {
                        boolean potentialBlock;
                        redo = false;
                        int blockedTasks = this.ts.getNumberOfBlockedActions();
                        boolean bl = potentialBlock = blockedTasks > 0;
                        if (ResourceManager.useCloud()) {
                            if (!this.ts.isExternalAdaptationEnabled()) {
                                WorkloadState workload = this.ts.getWorkload();
                                this.applyPolicies(workload);
                            }
                            int VMsBeingCreated = ResourceManager.getPendingCreationRequests().size();
                            potentialBlock = potentialBlock && VMsBeingCreated == 0;
                        }
                        this.handlePotentialBlock(potentialBlock);
                    } while (redo);
                }
                try {
                    ResourceOptimizer blockedTasks = this;
                    synchronized (blockedTasks) {
                        if (this.running) {
                            this.wait(2000L);
                        }
                    }
                }
                catch (InterruptedException blockedTasks) {
                }
            }
            catch (Exception e) {
                RUNTIME_LOGGER.error(ERROR_OPT_RES, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void optimizeNow() {
        ResourceOptimizer resourceOptimizer = this;
        synchronized (resourceOptimizer) {
            this.notify();
            redo = true;
        }
    }

    public void cleanUp() {
        cleanUp = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutdown() {
        ResourceOptimizer resourceOptimizer = this;
        synchronized (resourceOptimizer) {
            this.running = false;
            this.notify();
            cleanUp = true;
        }
        RESOURCES_LOGGER.info((Object)this.ts.getWorkload());
    }

    public final void handlePotentialBlock(boolean potentialBlock) {
        if (potentialBlock) {
            if (System.currentTimeMillis() - this.lastPotentialBlockedCheck > 20000L) {
                this.lastPotentialBlockedCheck = System.currentTimeMillis();
                ++this.everythingBlockedRetryCount;
                if (this.everythingBlockedRetryCount > 0) {
                    if (this.everythingBlockedRetryCount < 3) {
                        int retriesLeft = 3 - this.everythingBlockedRetryCount;
                        ErrorManager.warn((String)("No task could be scheduled to any of the available resources.\nThis could end up blocking COMPSs. Will check it again in 20 seconds.\nPossible causes: \n    -Network problems: non-reachable nodes, sshd service not started, etc.\n    -There isn't any computing resource that fits the defined tasks constraints.\nIf this happens " + retriesLeft + " more time" + (retriesLeft > 1 ? "s" : "") + ", the runtime will shutdown."));
                    } else {
                        ErrorManager.error((String)PERSISTENT_BLOCK_ERR);
                    }
                }
            }
        } else {
            this.everythingBlockedRetryCount = 0;
            this.lastPotentialBlockedCheck = System.currentTimeMillis();
        }
    }

    protected void initialCreations() {
        int alreadyCreated = ResourceOptimizer.addBasicNodes();
        ResourceOptimizer.addExtraNodes(alreadyCreated);
    }

    public static int addBasicNodes() {
        int coreCount = CoreManager.getCoreCount();
        List<ConstraintsCore>[] unfulfilledConstraints = ResourceOptimizer.getUnfulfilledConstraints();
        int unfulfilledConstraintsCores = 0;
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            if (unfulfilledConstraints[coreId].size() <= 0) continue;
            unfulfilledConstraintsCores += unfulfilledConstraints[coreId].size();
            break;
        }
        if (unfulfilledConstraintsCores == 0) {
            return 0;
        }
        Map<String, List<ConstraintsCore>> arch2Constraints = ResourceOptimizer.classifyArchitectures(unfulfilledConstraints);
        ResourceOptimizer.reduceArchitecturesConstraints(arch2Constraints);
        ResourceOptimizer.reassignUnassignedConstraints(arch2Constraints);
        ResourceOptimizer.reduceArchitecturesConstraints(arch2Constraints);
        int createdCount = 0;
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            while (!unfulfilledConstraints[coreId].isEmpty()) {
                ConstraintsCore cc = unfulfilledConstraints[coreId].remove(0);
                cc.confirmed();
                ResourceCreationRequest rcr = ResourceOptimizer.askForResources((MethodResourceDescription)cc.desc, false);
                if (rcr == null) continue;
                rcr.print(RESOURCES_LOGGER, DEBUG);
                ++createdCount;
            }
        }
        if (DEBUG) {
            RESOURCES_LOGGER.debug("DEBUG_MSG = [\n\tIn order to be able to execute all cores, Resource Manager has asked for " + createdCount + " Cloud resources\n" + "]");
        }
        return createdCount;
    }

    private static List<ConstraintsCore>[] getUnfulfilledConstraints() {
        int coreCount = CoreManager.getCoreCount();
        LinkedList[] unfulfilledConstraints = new LinkedList[coreCount];
        int[] maxSimTasks = ResourceManager.getTotalSlots();
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            unfulfilledConstraints[coreId] = new LinkedList();
            if (maxSimTasks[coreId] != 0) continue;
            List impls = CoreManager.getCoreImplementations((int)coreId);
            for (Implementation impl : impls) {
                if (impl.getTaskType() != Implementation.TaskType.METHOD) continue;
                MethodResourceDescription requirements = (MethodResourceDescription)impl.getRequirements();
                CloudMethodResourceDescription cd = new CloudMethodResourceDescription(requirements);
                ConstraintsCore cc = new ConstraintsCore(cd, coreId, unfulfilledConstraints[coreId]);
                unfulfilledConstraints[coreId].add(cc);
            }
        }
        return unfulfilledConstraints;
    }

    private static Map<String, List<ConstraintsCore>> classifyArchitectures(List<ConstraintsCore>[] constraints) {
        HashMap<String, List<ConstraintsCore>> archs = new HashMap<String, List<ConstraintsCore>>();
        for (int coreId = 0; coreId < CoreManager.getCoreCount(); ++coreId) {
            if (constraints[coreId] == null) continue;
            for (ConstraintsCore cc : constraints[coreId]) {
                List runnableArchitectures = cc.desc.getArchitectures();
                for (String arch : runnableArchitectures) {
                    LinkedList<ConstraintsCore> archConstr = (LinkedList<ConstraintsCore>)archs.get(arch);
                    if (archConstr == null) {
                        archConstr = new LinkedList<ConstraintsCore>();
                        archs.put(arch, archConstr);
                    }
                    archConstr.add(cc);
                }
            }
        }
        return archs;
    }

    private static void reduceArchitecturesConstraints(Map<String, List<ConstraintsCore>> arch2Ctrs) {
        for (List<ConstraintsCore> arch : arch2Ctrs.values()) {
            ConstraintsCore[] ctrs = new ConstraintsCore[arch.size()];
            int i = 0;
            for (ConstraintsCore cc : arch) {
                ctrs[i++] = cc;
            }
            Integer[] mergedTo = new Integer[arch.size()];
            for (i = 0; i < ctrs.length; ++i) {
                if (mergedTo[i] != null) continue;
                String OS = ctrs[i].desc.getOperatingSystemType();
                for (int j = i + 1; j < ctrs.length; ++j) {
                    if (mergedTo[j] != null || OS.compareTo(ctrs[j].desc.getOperatingSystemType()) != 0 && OS.compareTo("[unassigned]") != 0 && ctrs[j].desc.getOperatingSystemType().compareTo("[unassigned]") != 0) continue;
                    mergedTo[j] = i;
                    ctrs[i].join(ctrs[j]);
                    arch.remove(ctrs[j]);
                }
            }
        }
    }

    private static void reassignUnassignedConstraints(Map<String, List<ConstraintsCore>> arch2Ctrs) {
        List<ConstraintsCore> unassignedList = arch2Ctrs.get("[unassigned]");
        if (unassignedList == null) {
            return;
        }
        if (arch2Ctrs.size() == 1) {
            return;
        }
        if (arch2Ctrs.size() == 2) {
            for (Map.Entry<String, List<ConstraintsCore>> ctrs : arch2Ctrs.entrySet()) {
                if (((String)ctrs.getKey()).compareTo("[unassigned]") == 0) continue;
                ((List)ctrs.getValue()).addAll(unassignedList);
                return;
            }
        }
        LinkedList assignedList = new LinkedList();
        for (Map.Entry entry : arch2Ctrs.entrySet()) {
            if (((String)entry.getKey()).compareTo("[unassigned]") == 0) continue;
            assignedList.addAll((Collection)entry.getValue());
        }
        while (!unassignedList.isEmpty()) {
            ConstraintsCore unassigned = unassignedList.remove(0);
            CloudMethodResourceDescription cloudMethodResourceDescription = unassigned.desc;
            String bestArch = "[unassigned]";
            Float bestDifference = Float.valueOf(Float.MAX_VALUE);
            for (ConstraintsCore assigned : assignedList) {
                List avail_archs;
                CloudMethodResourceDescription option = assigned.desc;
                float difference = cloudMethodResourceDescription.difference((MethodResourceDescription)option);
                if (bestDifference.floatValue() < 0.0f) {
                    if (!(difference < 0.0f) || !(difference > bestDifference.floatValue())) continue;
                    avail_archs = option.getArchitectures();
                    if (avail_archs != null && !avail_archs.isEmpty()) {
                        bestArch = (String)avail_archs.get(0);
                    }
                    bestDifference = Float.valueOf(difference);
                    continue;
                }
                if (!(difference < bestDifference.floatValue())) continue;
                avail_archs = option.getArchitectures();
                if (avail_archs != null && !avail_archs.isEmpty()) {
                    bestArch = (String)avail_archs.get(0);
                }
                bestDifference = Float.valueOf(difference);
            }
            LinkedList<Processor> procs = unassigned.desc.getProcessors();
            if (procs == null) {
                procs = new LinkedList<Processor>();
            }
            if (!procs.isEmpty()) {
                ((Processor)procs.get(0)).setArchitecture(bestArch);
            } else {
                Processor p = new Processor();
                p.setArchitecture(bestArch);
                procs.add(p);
            }
            arch2Ctrs.get(bestArch).add(unassigned);
        }
    }

    public static int addExtraNodes(int alreadyCreated) {
        int initialVMsCount = ResourceManager.getInitialCloudVMs();
        int vmCount = initialVMsCount - alreadyCreated;
        if (vmCount <= 0) {
            return 0;
        }
        if (DEBUG) {
            RESOURCES_LOGGER.debug("DEBUG_MSG = [\n\tALREADY_CREATED_INSTANCES = " + alreadyCreated + "\n" + "\tMAXIMUM_NEW_PETITIONS = " + vmCount + "\n" + "]");
        }
        return vmCount;
    }

    protected void applyPolicies(WorkloadState workload) {
        long creationTime;
        int currentCloudVMCount = ResourceManager.getCurrentVMCount();
        Integer maxNumberOfVMs = ResourceManager.getMaxCloudVMs();
        Integer minNumberOfVMs = ResourceManager.getMinCloudVMs();
        try {
            creationTime = ResourceManager.getNextCreationTime();
        }
        catch (Exception ex) {
            creationTime = 120000L;
        }
        int coreCount = workload.getCoreCount();
        int noResourceCount = workload.getNoResourceCount();
        int[] noResourceCounts = workload.getNoResourceCounts();
        long[] minCoreTime = new long[coreCount];
        long[] meanCoreTime = new long[coreCount];
        long[] maxCoreTime = new long[coreCount];
        long[] minRemainingCoreTime = new long[coreCount];
        long[] meanRemainingCoreTime = new long[coreCount];
        long[] maxRemainingCoreTime = new long[coreCount];
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            minCoreTime[coreId] = Math.min(workload.getCoreMinTime(coreId), creationTime);
            meanCoreTime[coreId] = Math.min(workload.getCoreMeanTime(coreId), creationTime);
            maxCoreTime[coreId] = Math.min(workload.getCoreMaxTime(coreId), creationTime);
            long meanRunningCoreTime = workload.getRunningCoreMeanTime(coreId);
            minRemainingCoreTime[coreId] = minCoreTime[coreId] - meanRunningCoreTime < 0L ? 0L : Math.min(minCoreTime[coreId] - meanRunningCoreTime, creationTime);
            meanRemainingCoreTime[coreId] = meanCoreTime[coreId] - meanRunningCoreTime < 0L ? 0L : Math.min(meanCoreTime[coreId] - meanRunningCoreTime, creationTime);
            maxRemainingCoreTime[coreId] = maxCoreTime[coreId] - meanRunningCoreTime < 0L ? 0L : Math.min(maxCoreTime[coreId] - meanRunningCoreTime, creationTime);
        }
        long[] runningMinCoreTime = new long[coreCount];
        long[] runningMeanCoreTime = new long[coreCount];
        long[] runningMaxCoreTime = new long[coreCount];
        long[] readyMinCoreTime = new long[coreCount];
        long[] readyMeanCoreTime = new long[coreCount];
        long[] readyMaxCoreTime = new long[coreCount];
        long[] pendingMinCoreTime = new long[coreCount];
        long[] pendingMeanCoreTime = new long[coreCount];
        long[] pendingMaxCoreTime = new long[coreCount];
        int[] realSlots = ResourceManager.getAvailableSlots();
        int[] totalSlots = ResourceManager.getTotalSlots();
        int[] runningCounts = workload.getRunningTaskCounts();
        int[] readyCounts = workload.getReadyCounts();
        int[] pendingCounts = new int[coreCount];
        long totalPendingTasks = 0L;
        for (int i = 0; i < coreCount; ++i) {
            runningMinCoreTime[i] = minRemainingCoreTime[i] * (long)runningCounts[i];
            readyMinCoreTime[i] = runningMinCoreTime[i] + minCoreTime[i] * (long)readyCounts[i];
            pendingMinCoreTime[i] = readyMinCoreTime[i] + minCoreTime[i] * (long)pendingCounts[i];
            runningMeanCoreTime[i] = meanRemainingCoreTime[i] * (long)runningCounts[i];
            readyMeanCoreTime[i] = runningMeanCoreTime[i] + meanCoreTime[i] * (long)readyCounts[i];
            pendingMeanCoreTime[i] = readyMeanCoreTime[i] + meanCoreTime[i] * (long)pendingCounts[i];
            runningMaxCoreTime[i] = maxRemainingCoreTime[i] * (long)runningCounts[i];
            readyMaxCoreTime[i] = runningMaxCoreTime[i] + maxCoreTime[i] * (long)readyCounts[i];
            pendingMaxCoreTime[i] = readyMaxCoreTime[i] + maxCoreTime[i] * (long)pendingCounts[i];
            totalPendingTasks += (long)pendingCounts[i];
        }
        if (DEBUG) {
            RUNTIME_LOGGER.debug("[Resource Optimizer] Applying VM optimization policies (currentVMs: " + currentCloudVMCount + " maxVMs: " + maxNumberOfVMs + " minVMs: " + minNumberOfVMs + ")");
        }
        if (!cleanUp) {
            List<Integer> requiredVMs = this.checkNeededMachines(noResourceCount, noResourceCounts, totalSlots);
            if (!requiredVMs.isEmpty()) {
                RUNTIME_LOGGER.debug("[Resource Optimizer] Required VMs. Mandatory Increase");
                float[] creationRecommendations = this.recommendCreations(coreCount, creationTime, readyMinCoreTime, readyMeanCoreTime, readyMaxCoreTime, totalSlots, realSlots);
                for (Integer coreId : requiredVMs) {
                    creationRecommendations[coreId.intValue()] = Math.max(creationRecommendations[coreId], 1.0f);
                }
                this.mandatoryIncrease(creationRecommendations, requiredVMs);
                return;
            }
            if (minNumberOfVMs != null && minNumberOfVMs > currentCloudVMCount) {
                RUNTIME_LOGGER.debug("[Resource Optimizer] Current VM (" + currentCloudVMCount + ") count smaller than minimum VMs (" + minNumberOfVMs + "). Mandatory Increase");
                float[] creationRecommendations = this.orderCreations(coreCount, creationTime, readyMinCoreTime, readyMeanCoreTime, readyMaxCoreTime, totalSlots, realSlots);
                this.mandatoryIncrease(creationRecommendations, new LinkedList<Integer>());
                return;
            }
            if (maxNumberOfVMs != null && maxNumberOfVMs < currentCloudVMCount) {
                RUNTIME_LOGGER.debug("[Resource Optimizer] Current VM (" + currentCloudVMCount + ") count bigger than maximum VMs (" + maxNumberOfVMs + "). Mandatory reduction");
                float[] destroyRecommendations = this.deleteRecommendations(coreCount, 2000L, pendingMinCoreTime, pendingMeanCoreTime, pendingMaxCoreTime, totalSlots, realSlots);
                this.mandatoryReduction(destroyRecommendations);
                return;
            }
        }
        if ((maxNumberOfVMs == null || maxNumberOfVMs > currentCloudVMCount) && workload.getReadyCount() > 1) {
            RUNTIME_LOGGER.debug("[Resource Optimizer] Current VM (" + currentCloudVMCount + ") count smaller than maximum VMs (" + maxNumberOfVMs + ")");
            float[] creationRecommendations = this.recommendCreations(coreCount, creationTime, readyMinCoreTime, readyMeanCoreTime, readyMaxCoreTime, totalSlots, realSlots);
            if (this.optionalIncrease(creationRecommendations)) {
                return;
            }
        }
        if ((minNumberOfVMs == null || minNumberOfVMs < currentCloudVMCount) && totalPendingTasks == 0L && workload.getReadyCount() == 0) {
            RUNTIME_LOGGER.debug("[Resource Optimizer] Current VM (" + currentCloudVMCount + ") count bigger than minimum VMs (" + minNumberOfVMs + ")");
            float[] destroyRecommendations = this.deleteRecommendations(coreCount, 2000L, pendingMinCoreTime, pendingMeanCoreTime, pendingMaxCoreTime, totalSlots, realSlots);
            if (this.optionalReduction(destroyRecommendations)) {
                return;
            }
        }
    }

    private void mandatoryIncrease(float[] creationRecommendations, List<Integer> requiredVMs) {
        PriorityQueue<ValueResourceDescription> pq = new PriorityQueue<ValueResourceDescription>();
        boolean[] required = new boolean[creationRecommendations.length];
        for (int coreId : requiredVMs) {
            required[coreId] = true;
        }
        for (int coreId = 0; coreId < creationRecommendations.length; ++coreId) {
            List impls = CoreManager.getCoreImplementations((int)coreId);
            for (Implementation impl : impls) {
                if (impl.getTaskType() == Implementation.TaskType.SERVICE) continue;
                MethodResourceDescription constraints = ((MethodImplementation)impl).getRequirements();
                ValueResourceDescription v = new ValueResourceDescription(constraints, creationRecommendations[coreId], false);
                pq.add(v);
            }
        }
        ResourceOptimizer.requestOneCreation(pq, true);
    }

    private boolean optionalIncrease(float[] creationRecommendations) {
        PriorityQueue<ValueResourceDescription> pq = new PriorityQueue<ValueResourceDescription>();
        for (int coreId = 0; coreId < creationRecommendations.length; ++coreId) {
            if (!(creationRecommendations[coreId] > 1.0f)) continue;
            List impls = CoreManager.getCoreImplementations((int)coreId);
            for (Implementation impl : impls) {
                if (impl.getTaskType() == Implementation.TaskType.SERVICE) continue;
                MethodResourceDescription constraints = ((MethodImplementation)impl).getRequirements();
                ValueResourceDescription v = new ValueResourceDescription(constraints, creationRecommendations[coreId], false);
                pq.add(v);
            }
        }
        ResourceCreationRequest rcr = ResourceOptimizer.requestOneCreation(pq, false);
        return rcr != null;
    }

    private boolean optionalReduction(float[] destroyRecommendations) {
        Object[] nonCriticalSolution;
        List<CloudMethodWorker> nonCritical = this.trimReductionOptions(ResourceManager.getNonCriticalDynamicResources(), destroyRecommendations);
        if (DEBUG) {
            RUNTIME_LOGGER.debug("[Resource Optimizer] Searching for best destruction");
        }
        if ((nonCriticalSolution = this.getBestDestruction(nonCritical, destroyRecommendations)) == null || nonCriticalSolution[0] == null || nonCriticalSolution[1] == null || nonCriticalSolution[2] == null) {
            if (DEBUG) {
                RUNTIME_LOGGER.warn("[Resource Optimizer] No solution found");
            }
            return false;
        }
        CloudMethodWorker res = (CloudMethodWorker)nonCriticalSolution[0];
        CloudInstanceTypeDescription rd = (CloudInstanceTypeDescription)nonCriticalSolution[1];
        float[] record = (float[])nonCriticalSolution[2];
        if (DEBUG) {
            RUNTIME_LOGGER.debug("[Resource Optimizer] Best resource to remove is " + res.getName() + "and record is [" + record[0] + "," + record[1] + "," + record[2]);
        }
        if (record[1] > 0.0f && res.getUsedCPUTaskCount() > 0) {
            RUNTIME_LOGGER.debug("[Resource Optimizer] Optional destroy recommendation not applied");
            return false;
        }
        RUNTIME_LOGGER.debug("[Resource Optimizer] Optional destroy recommendation applied");
        CloudMethodResourceDescription finalDescription = new CloudMethodResourceDescription(rd, res.getDescription().getImage());
        finalDescription.setName(res.getName());
        ResourceManager.reduceCloudWorker((CloudMethodWorker)res, (CloudMethodResourceDescription)finalDescription);
        return true;
    }

    private void mandatoryReduction(float[] destroyRecommendations) {
        CloudInstanceTypeDescription citd;
        CloudMethodWorker res;
        boolean criticalIsBetter;
        List<CloudMethodWorker> critical = this.trimReductionOptions(ResourceManager.getCriticalDynamicResources(), destroyRecommendations);
        List<CloudMethodWorker> nonCritical = this.trimReductionOptions(ResourceManager.getNonCriticalDynamicResources(), destroyRecommendations);
        Object[] criticalSolution = this.getBestDestruction(critical, destroyRecommendations);
        Object[] nonCriticalSolution = this.getBestDestruction(nonCritical, destroyRecommendations);
        if (criticalSolution == null) {
            if (nonCriticalSolution == null) {
                return;
            }
            criticalIsBetter = false;
        } else if (nonCriticalSolution == null) {
            criticalIsBetter = true;
        } else {
            criticalIsBetter = false;
            float[] noncriticalValues = (float[])nonCriticalSolution[2];
            float[] criticalValues = (float[])criticalSolution[2];
            if (noncriticalValues[0] == criticalValues[0]) {
                if (noncriticalValues[1] == criticalValues[1]) {
                    if (noncriticalValues[2] < criticalValues[2]) {
                        criticalIsBetter = true;
                    }
                } else if (noncriticalValues[1] > criticalValues[1]) {
                    criticalIsBetter = true;
                }
            } else if (noncriticalValues[0] > criticalValues[0]) {
                criticalIsBetter = true;
            }
        }
        if (criticalIsBetter) {
            res = (CloudMethodWorker)criticalSolution[0];
            citd = (CloudInstanceTypeDescription)criticalSolution[1];
        } else {
            if (nonCriticalSolution == null) {
                return;
            }
            res = (CloudMethodWorker)nonCriticalSolution[0];
            citd = (CloudInstanceTypeDescription)nonCriticalSolution[1];
        }
        CloudMethodResourceDescription cmrd = res.getDescription();
        CloudImageDescription cid = cmrd.getImage();
        CloudMethodResourceDescription finalDescription = new CloudMethodResourceDescription(citd, cid);
        finalDescription.setName(res.getName());
        ResourceManager.reduceCloudWorker((CloudMethodWorker)res, (CloudMethodResourceDescription)finalDescription);
    }

    private List<CloudMethodWorker> trimReductionOptions(Collection<CloudMethodWorker> options, float[] recommendations) {
        if (DEBUG) {
            RUNTIME_LOGGER.debug("[Resource Optimizer] * Trimming reduction options");
        }
        LinkedList<CloudMethodWorker> resources = new LinkedList<CloudMethodWorker>();
        for (CloudMethodWorker resource : options) {
            boolean add;
            boolean aggressive = false;
            boolean bl = add = !aggressive;
            if (DEBUG) {
                RUNTIME_LOGGER.debug("\t Evaluating " + resource.getName() + ". Default reduction is " + add);
            }
            List executableCores = resource.getExecutableCores();
            Iterator iterator = executableCores.iterator();
            while (iterator.hasNext()) {
                int coreId = (Integer)iterator.next();
                if (!aggressive && recommendations[coreId] < 1.0f) {
                    if (DEBUG) {
                        RUNTIME_LOGGER.debug("\t\tVM not removed because of not agressive and recomendations < 1 (" + recommendations[coreId] + ")");
                    }
                    add = false;
                    break;
                }
                if (!aggressive || !(recommendations[coreId] > 0.0f)) continue;
                if (DEBUG) {
                    RUNTIME_LOGGER.debug("\t\tVM removed because of agressive and recomendations > 0 (" + recommendations[coreId] + ")");
                }
                add = true;
                break;
            }
            if (!add) continue;
            if (DEBUG) {
                RUNTIME_LOGGER.debug("\t\tVM added to candidate to remove.");
            }
            resources.add(resource);
        }
        return resources;
    }

    private static ResourceCreationRequest requestOneCreation(PriorityQueue<ValueResourceDescription> pq, boolean include) {
        ValueResourceDescription v;
        while ((v = pq.poll()) != null) {
            ResourceCreationRequest rcr = ResourceOptimizer.askForResources(v.value < 1.0f ? 1 : (int)v.value, v.constraints, include);
            if (rcr == null) continue;
            rcr.print(RESOURCES_LOGGER, DEBUG);
            return rcr;
        }
        return null;
    }

    private List<Integer> checkNeededMachines(int noResourceCount, int[] noResourceCountPerCore, int[] slotCountPerCore) {
        LinkedList<Integer> needed = new LinkedList<Integer>();
        if (noResourceCount == 0) {
            return needed;
        }
        for (int i = 0; i < CoreManager.getCoreCount(); ++i) {
            if (noResourceCountPerCore[i] <= 0 || slotCountPerCore[i] != 0) continue;
            needed.add(i);
        }
        return needed;
    }

    private float[] recommendCreations(int coreCount, long creationTime, long[] aggregatedMinCoreTime, long[] aggregatedMeanCoreTime, long[] aggregatedMaxCoreTime, int[] totalSlots, int[] realSlots) {
        float[] creations = new float[coreCount];
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            long totalTime;
            long embraceableLoad = totalTime = (long)totalSlots[coreId] * creationTime;
            long remainingLoad = aggregatedMeanCoreTime[coreId] - embraceableLoad;
            if (DEBUG) {
                RUNTIME_LOGGER.debug("[Resource Optimizer] * Calculating increase recomendations");
                RUNTIME_LOGGER.debug("\tRemaining load = " + aggregatedMeanCoreTime[coreId] + "-( " + totalSlots[coreId] + " * " + creationTime + " ) = " + remainingLoad);
            }
            if (remainingLoad > 0L) {
                creations[coreId] = (int)(remainingLoad / creationTime);
                if (!DEBUG) continue;
                RUNTIME_LOGGER.debug("\tRecomended slots = " + creations[coreId] + " ( " + remainingLoad + " / " + creationTime + " )");
                continue;
            }
            creations[coreId] = 0.0f;
        }
        return creations;
    }

    private float[] orderCreations(int coreCount, long creationTime, long[] aggregatedMinCoreTime, long[] aggregatedMeanCoreTime, long[] aggregatedMaxCoreTime, int[] totalSlots, int[] realSlots) {
        float[] creations = new float[coreCount];
        int maxI = 0;
        float maxRatio = 0.0f;
        for (int i = 0; i < CoreManager.getCoreCount(); ++i) {
            float ratio;
            if (aggregatedMeanCoreTime[i] <= 0L || totalSlots[i] <= 0 || !((ratio = (float)(aggregatedMeanCoreTime[i] / (long)totalSlots[i])) > maxRatio)) continue;
            maxI = i;
            maxRatio = ratio;
        }
        creations[maxI] = 1.0f;
        return creations;
    }

    private float[] deleteRecommendations(int coreCount, long limitTime, long[] aggregatedMinCoreTime, long[] aggregatedMeanCoreTime, long[] aggregatedMaxCoreTime, int[] totalSlots, int[] realSlots) {
        if (DEBUG) {
            RUNTIME_LOGGER.debug("[Resource Optimizer] * Delete Recomendations calculations:\n\tcoreCount: " + coreCount + " limitTime: " + limitTime);
        }
        float[] destructions = new float[coreCount];
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            long embraceableLoad = limitTime * (long)realSlots[coreId];
            if (embraceableLoad == 0L) {
                destructions[coreId] = 0.0f;
                if (!DEBUG) continue;
                RUNTIME_LOGGER.debug("\tembraceableLoad [ " + coreId + "] = " + limitTime + " * " + realSlots[coreId] + " = " + embraceableLoad);
                RUNTIME_LOGGER.debug("\tdestructions [ " + coreId + "] = 0");
                continue;
            }
            if (aggregatedMinCoreTime[coreId] > 0L) {
                double unusedTime = (double)embraceableLoad / 2.0 - (double)aggregatedMeanCoreTime[coreId];
                destructions[coreId] = (float)(unusedTime / (double)limitTime);
                if (!DEBUG) continue;
                RUNTIME_LOGGER.debug("\tembraceableLoad [ " + coreId + "] = " + limitTime + " * " + realSlots[coreId] + " = " + embraceableLoad);
                RUNTIME_LOGGER.debug("\tunused [ " + coreId + "] =  ( " + embraceableLoad + " / 2) - " + aggregatedMeanCoreTime[coreId] + " = " + unusedTime);
                RUNTIME_LOGGER.debug("\tdestructions [ " + coreId + "] = " + destructions[coreId]);
                continue;
            }
            destructions[coreId] = embraceableLoad / limitTime;
        }
        return destructions;
    }

    public ResourceCreationRequest askForResources(CloudProvider cp, String instanceName, String imageName) {
        CloudMethodResourceDescription constraints = cp.getResourceDescription(instanceName, imageName);
        if (constraints == null) {
            RUNTIME_LOGGER.warn(WARN_EXCEPTION_TURN_ON);
            return null;
        }
        return cp.requestResourceCreation(constraints);
    }

    public static ResourceCreationRequest askForResources(MethodResourceDescription requirements, boolean contained) {
        return ResourceOptimizer.askForResources(1, requirements, contained);
    }

    public static ResourceCreationRequest askForResources(Integer amount, MethodResourceDescription requirements, boolean contained) {
        CloudProvider bestProvider = null;
        CloudMethodResourceDescription bestConstraints = null;
        Float bestValue = Float.valueOf(Float.MAX_VALUE);
        for (CloudProvider cp : ResourceManager.getAvailableCloudProviders()) {
            CloudMethodResourceDescription rc = ResourceOptimizer.getBestIncreaseOnProvider(cp, amount, requirements, contained);
            if (rc != null && rc.getValue().floatValue() < bestValue.floatValue()) {
                bestProvider = cp;
                bestConstraints = rc;
                bestValue = rc.getValue();
                continue;
            }
            if (rc != null && bestConstraints == null) {
                bestProvider = cp;
                bestConstraints = rc;
                bestValue = rc.getValue();
                continue;
            }
            RUNTIME_LOGGER.warn("WARN: Cloud Provider cannot increase resources (" + cp.getName() + ")");
        }
        if (bestConstraints == null) {
            RUNTIME_LOGGER.warn(WARN_NO_RESOURCE_MATCHES);
            return null;
        }
        return bestProvider.requestResourceCreation(bestConstraints);
    }

    public static CloudMethodResourceDescription getBestIncreaseOnProvider(CloudProvider cp, Integer amount, MethodResourceDescription requirements, boolean contained) {
        RUNTIME_LOGGER.debug("[Resource Optimizer] Getting best increase in provider " + cp.getName());
        if (!cp.canHostMoreInstances()) {
            RUNTIME_LOGGER.warn(WARN_NO_MORE_INSTANCES);
            return null;
        }
        List instances = cp.getCompatibleTypes(requirements);
        RUNTIME_LOGGER.debug("[Resource Optimizer] There are " + instances.size() + " instances compatible.");
        if (instances.isEmpty()) {
            RUNTIME_LOGGER.warn(WARN_NO_COMPATIBLE_TYPE);
            return null;
        }
        CloudMethodResourceDescription result = null;
        CloudInstanceTypeDescription type = null;
        type = contained ? ResourceOptimizer.selectContainedInstance(instances, requirements, amount) : ResourceOptimizer.selectContainingInstance(instances, requirements, amount);
        if (type != null) {
            List images = cp.getCompatibleImages(requirements);
            RUNTIME_LOGGER.debug("[Resource Optimizer] There are " + images.size() + " images compatible.");
            if (!images.isEmpty()) {
                CloudImageDescription image = (CloudImageDescription)images.get(0);
                result = new CloudMethodResourceDescription(type, image);
                result.setValue(cp.getInstanceCostPerHour(result));
            } else {
                RUNTIME_LOGGER.warn(WARN_NO_COMPATIBLE_IMAGE);
            }
        } else {
            RUNTIME_LOGGER.warn(WARN_NO_VALID_INSTANCE);
        }
        return result;
    }

    private static CloudInstanceTypeDescription selectContainingInstance(List<CloudInstanceTypeDescription> instances, MethodResourceDescription constraints, int amount) {
        CloudInstanceTypeDescription result = null;
        MethodResourceDescription bestDescription = null;
        float bestDistance = -2.1474836E9f;
        for (CloudInstanceTypeDescription type : instances) {
            MethodResourceDescription rd = type.getResourceDescription();
            int slots = rd.canHostSimultaneously(constraints);
            float distance = slots - amount;
            RUNTIME_LOGGER.debug("[Resource Optimizer] Can host: slots = " + slots + " amount = " + amount + " distance = " + distance + " bestDistance = " + bestDistance);
            if ((double)distance > 0.0) continue;
            if (distance > bestDistance) {
                result = type;
                bestDescription = type.getResourceDescription();
                bestDistance = distance;
                continue;
            }
            if (distance != bestDistance || bestDescription == null || bestDescription.getValue() == null || rd.getValue() == null || !(bestDescription.getValue().floatValue() > rd.getValue().floatValue())) continue;
            result = type;
            bestDescription = type.getResourceDescription();
            bestDistance = distance;
        }
        if (result == null) {
            return null;
        }
        return result;
    }

    private static CloudInstanceTypeDescription selectContainedInstance(List<CloudInstanceTypeDescription> instances, MethodResourceDescription constraints, int amount) {
        CloudInstanceTypeDescription bestType = null;
        MethodResourceDescription bestDescription = null;
        float bestDistance = 2.1474836E9f;
        for (CloudInstanceTypeDescription type : instances) {
            MethodResourceDescription rd = type.getResourceDescription();
            int slots = rd.canHostSimultaneously(constraints);
            float distance = slots - amount;
            RUNTIME_LOGGER.debug("[Resource Optimizer] Can host: slots = " + slots + " amount = " + amount + " distance = " + distance + " bestDistance = " + bestDistance);
            if ((double)distance < 0.0) continue;
            if (distance < bestDistance) {
                bestType = type;
                bestDescription = type.getResourceDescription();
                bestDistance = distance;
                continue;
            }
            if (distance != bestDistance || bestDescription == null || bestDescription.getValue() == null || rd.getValue() == null || !(bestDescription.getValue().floatValue() > rd.getValue().floatValue())) continue;
            bestType = type;
            bestDescription = type.getResourceDescription();
            bestDistance = distance;
        }
        if (bestType == null) {
            return null;
        }
        return bestType;
    }

    private Object[] getBestDestruction(Collection<CloudMethodWorker> resourceSet, float[] destroyRecommendations) {
        float[] bestRecord = new float[]{Float.MAX_VALUE, Float.MAX_VALUE, Float.MIN_VALUE};
        CloudMethodWorker bestResource = null;
        CloudInstanceTypeDescription bestType = null;
        for (CloudMethodWorker res : resourceSet) {
            CloudProvider cp = res.getProvider();
            if (cp == null) {
                if (!DEBUG) continue;
                RUNTIME_LOGGER.debug("Resource " + res.getName() + " is not cloud. Skipping...");
                continue;
            }
            Map<CloudInstanceTypeDescription, float[]> typeToPoints = this.getPossibleReductions(res, destroyRecommendations);
            for (Map.Entry<CloudInstanceTypeDescription, float[]> destruction : typeToPoints.entrySet()) {
                CloudInstanceTypeDescription type = destruction.getKey();
                float[] values = destruction.getValue();
                if (DEBUG) {
                    RUNTIME_LOGGER.debug("Type: " + type.getName() + " value 0: " + values[0] + " (" + bestRecord[0] + ") " + " value 1: " + values[1] + " (" + bestRecord[1] + ") " + " value 2: " + values[2] + " (" + bestRecord[2] + ")");
                }
                if (bestRecord[0] == values[0]) {
                    if (bestRecord[1] == values[1]) {
                        if (!(bestRecord[2] < values[2])) continue;
                        bestRecord = values;
                        bestResource = res;
                        bestType = type;
                        continue;
                    }
                    if (!(bestRecord[1] > values[1])) continue;
                    bestRecord = values;
                    bestResource = res;
                    bestType = type;
                    continue;
                }
                if (!(bestRecord[0] > values[0])) continue;
                bestRecord = values;
                bestResource = res;
                bestType = type;
            }
        }
        if (bestResource != null) {
            Object[] ret = new Object[]{bestResource, bestType, bestRecord};
            return ret;
        }
        RUNTIME_LOGGER.warn("Best resource to remove not found");
        return null;
    }

    private Map<CloudInstanceTypeDescription, float[]> getPossibleReductions(CloudMethodWorker res, float[] recommendedSlots) {
        HashMap<CloudInstanceTypeDescription, float[]> reductions = new HashMap<CloudInstanceTypeDescription, float[]>();
        List types = res.getDescription().getPossibleReductions();
        for (CloudInstanceTypeDescription type : types) {
            int[] reducedSlots = type.getSlotsCore();
            float[] values = new float[3];
            for (int coreId = 0; coreId < CoreManager.getCoreCount(); ++coreId) {
                if (!res.canRun(coreId)) continue;
                if (recommendedSlots[coreId] < 1.0f && reducedSlots[coreId] > 0) {
                    values[0] = values[0] + 1.0f;
                    values[1] = values[1] + (float)reducedSlots[coreId];
                    continue;
                }
                float dif = (float)reducedSlots[coreId] - recommendedSlots[coreId];
                if (dif < 0.0f) {
                    values[2] = values[2] + (float)reducedSlots[coreId];
                    continue;
                }
                values[2] = values[2] + recommendedSlots[coreId];
                values[1] = values[1] + dif;
            }
            reductions.put(type, values);
        }
        return reductions;
    }

    private static class ValueResourceDescription
    implements Comparable<ValueResourceDescription> {
        private final MethodResourceDescription constraints;
        private final float value;
        private final boolean prioritary;

        public ValueResourceDescription(MethodResourceDescription constraints, float value, boolean prioritary) {
            this.constraints = constraints;
            this.value = value;
            this.prioritary = prioritary;
        }

        @Override
        public int compareTo(ValueResourceDescription o) {
            if (this.prioritary && !o.prioritary) {
                return 1;
            }
            if (!this.prioritary && o.prioritary) {
                return -1;
            }
            float dif = this.value - o.value;
            if (dif > 0.0f) {
                return 1;
            }
            if (dif < 0.0f) {
                return -1;
            }
            return 0;
        }

        public String toString() {
            return this.value + (this.prioritary ? "!" : "") + this.constraints;
        }
    }

    private static class ConstraintsCore {
        private CloudMethodResourceDescription desc;
        private List<ConstraintsCore>[] cores;

        public ConstraintsCore(CloudMethodResourceDescription desc, int core, List<ConstraintsCore> coreList) {
            this.desc = desc;
            this.cores = new LinkedList[CoreManager.getCoreCount()];
            this.cores[core] = coreList;
        }

        public void join(ConstraintsCore c2) {
            this.desc.increase(c2.desc);
            c2.desc = this.desc;
            for (int coreId = 0; coreId < CoreManager.getCoreCount(); ++coreId) {
                if (this.cores[coreId] != null) {
                    if (c2.cores[coreId] != null) {
                        this.cores[coreId].remove(c2);
                        continue;
                    }
                    c2.cores[coreId] = this.cores[coreId];
                    continue;
                }
                this.cores[coreId] = c2.cores[coreId];
            }
        }

        public void confirmed() {
            for (int coreId = 0; coreId < CoreManager.getCoreCount(); ++coreId) {
                if (this.cores[coreId] == null) continue;
                this.cores[coreId].clear();
            }
        }

        public String toString() {
            LinkedList<Integer> cores = new LinkedList<Integer>();
            for (int i = 0; i < CoreManager.getCoreCount(); ++i) {
                if (this.cores[i] == null) continue;
                cores.add(i);
            }
            return this.desc.toString() + " meets constraints for cores " + cores;
        }
    }

    protected class CloudTypeProfile {
        private Profile[][] implProfiles;

        public CloudTypeProfile(JSONObject typeJSON, JSONObject implsJSON) {
            this.implProfiles = this.loadProfiles(typeJSON, implsJSON);
        }

        public Profile getImplProfiles(int coreId, int implId) {
            return this.implProfiles[coreId][implId];
        }

        private final Profile[][] loadProfiles(JSONObject resMap, JSONObject implMap) {
            int coreCount = CoreManager.getCoreCount();
            Profile[][] profiles = new Profile[coreCount][];
            for (int coreId = 0; coreId < coreCount; ++coreId) {
                List impls = CoreManager.getCoreImplementations((int)coreId);
                int implCount = impls.size();
                profiles[coreId] = new Profile[implCount];
                for (Implementation impl : impls) {
                    String signature = CoreManager.getSignature((int)coreId, (int)impl.getImplementationId());
                    JSONObject jsonImpl = null;
                    if (resMap != null) {
                        try {
                            jsonImpl = resMap.getJSONObject(signature);
                            profiles[coreId][impl.getImplementationId().intValue()] = this.generateProfileForImplementation(impl, jsonImpl);
                        }
                        catch (JSONException jSONException) {
                            // empty catch block
                        }
                    }
                    if (profiles[coreId][impl.getImplementationId()] != null) continue;
                    if (implMap != null) {
                        try {
                            jsonImpl = implMap.getJSONObject(signature);
                        }
                        catch (JSONException jSONException) {
                            // empty catch block
                        }
                    }
                    profiles[coreId][impl.getImplementationId().intValue()] = this.generateProfileForImplementation(impl, jsonImpl);
                    profiles[coreId][impl.getImplementationId()].clearExecutionCount();
                }
            }
            return profiles;
        }

        protected Profile generateProfileForImplementation(Implementation impl, JSONObject jsonImpl) {
            return new Profile(jsonImpl);
        }
    }
}

