/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.types.allocatableactions;

import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.components.impl.TaskScheduler;
import es.bsc.compss.scheduler.exceptions.BlockedActionException;
import es.bsc.compss.scheduler.exceptions.FailedActionException;
import es.bsc.compss.scheduler.exceptions.UnassignedActionException;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.SchedulingInformation;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.MethodImplementation;
import es.bsc.compss.types.implementations.ServiceImplementation;
import es.bsc.compss.types.resources.CloudMethodWorker;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.types.resources.updates.PendingReduction;
import es.bsc.compss.types.resources.updates.ResourceUpdate;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.ResourceManager;
import java.util.LinkedList;

public class ReduceWorkerAction<T extends WorkerResourceDescription>
extends AllocatableAction {
    private final ResourceScheduler<T> worker;
    private final TaskScheduler ts;
    private final Implementation impl;
    private final PendingReduction<T> ru;

    public ReduceWorkerAction(SchedulingInformation schedulingInformation, ResourceScheduler<T> worker, TaskScheduler ts, ResourceUpdate<T> modification) {
        super(schedulingInformation, ts.getOrchestrator());
        this.worker = worker;
        this.ts = ts;
        this.ru = (PendingReduction)modification;
        this.impl = worker.getResource().getType() == Resource.Type.WORKER ? new MethodImplementation("", "", null, null, (MethodResourceDescription)modification.getModification()) : new ServiceImplementation(null, "", "", "", "");
    }

    @Override
    public boolean isToReserveResources() {
        return true;
    }

    @Override
    public boolean isToReleaseResources() {
        return false;
    }

    @Override
    public boolean isToStopResource() {
        return false;
    }

    @Override
    protected void doAction() {
        new Thread(){

            @Override
            public void run() {
                Thread.currentThread().setName(ReduceWorkerAction.this.worker.getName() + " stopper");
                CloudMethodWorker w = (CloudMethodWorker)ReduceWorkerAction.this.worker.getResource();
                PendingReduction crd = ReduceWorkerAction.this.ru;
                ResourceManager.reduceResource((CloudMethodWorker)w, (PendingReduction)crd);
                w.endTask((MethodResourceDescription)ReduceWorkerAction.this.getResourceConsumption());
                try {
                    ReduceWorkerAction.this.ru.waitForCompletion();
                }
                catch (Exception e) {
                    LOGGER.error("ERROR: Exception raised on worker reduction", (Throwable)e);
                    ErrorManager.warn((String)"Exception reducing worker. Check runtime.log for more details", (Exception)e);
                    ReduceWorkerAction.this.notifyError();
                }
                ReduceWorkerAction.this.notifyCompleted();
            }
        }.start();
    }

    @Override
    protected void doCompleted() {
        this.ts.completedResourceUpdate(this.worker, this.ru);
    }

    @Override
    protected void doError() throws FailedActionException {
        throw new FailedActionException();
    }

    @Override
    protected void doFailed() {
        LOGGER.error("Error waiting for tasks to end");
        this.ts.completedResourceUpdate(this.worker, this.ru);
    }

    @Override
    public Integer getCoreId() {
        return null;
    }

    public LinkedList<ResourceScheduler<? extends WorkerResourceDescription>> getCompatibleWorkers() {
        LinkedList<ResourceScheduler<? extends WorkerResourceDescription>> workers = new LinkedList<ResourceScheduler<? extends WorkerResourceDescription>>();
        workers.add(this.worker);
        return workers;
    }

    @Override
    public Implementation[] getImplementations() {
        Implementation[] impls = new Implementation[]{this.impl};
        return impls;
    }

    public <R extends WorkerResourceDescription> boolean isCompatible(Worker<R> r) {
        return r == this.worker.getResource();
    }

    public <R extends WorkerResourceDescription> LinkedList<Implementation> getCompatibleImplementations(ResourceScheduler<R> r) {
        LinkedList<Implementation> impls = new LinkedList<Implementation>();
        if (r == this.worker) {
            impls.add(this.impl);
        }
        return impls;
    }

    public <R extends WorkerResourceDescription> Score schedulingScore(ResourceScheduler<R> targetWorker, Score actionScore) {
        return null;
    }

    @Override
    public void schedule(Score actionScore) throws BlockedActionException, UnassignedActionException {
        this.schedule((ResourceScheduler<R>)this.worker, this.impl);
    }

    @Override
    public void tryToSchedule(Score actionScore) throws BlockedActionException, UnassignedActionException {
        this.schedule(actionScore);
    }

    public <R extends WorkerResourceDescription> void schedule(ResourceScheduler<R> targetWorker, Score actionScore) throws BlockedActionException, UnassignedActionException {
        this.schedule(targetWorker, this.impl);
    }

    public <R extends WorkerResourceDescription> void schedule(ResourceScheduler<R> targetWorker, Implementation impl) throws BlockedActionException, UnassignedActionException {
        if (targetWorker != this.getEnforcedTargetResource()) {
            throw new UnassignedActionException();
        }
        this.assignResource(targetWorker);
        this.assignImplementation(impl);
        targetWorker.scheduleAction(this);
    }

    @Override
    public String toString() {
        return "ReduceWorkerAction (Worker " + this.worker.getName() + ")";
    }

    @Override
    public int getPriority() {
        return Integer.MAX_VALUE;
    }
}

