/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.dataScheduler;

import es.bsc.compss.scheduler.readyScheduler.ReadyResourceScheduler;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import org.json.JSONObject;

public class DataResourceScheduler<T extends WorkerResourceDescription>
extends ReadyResourceScheduler<T> {
    public DataResourceScheduler(Worker<T> w, JSONObject resJSON, JSONObject implJSON) {
        super(w, resJSON, implJSON);
    }

    public Score generateBlockedScore(AllocatableAction action) {
        long actionPriority = action.getPriority();
        long waitingScore = -this.blocked.size();
        long resourceScore = 0L;
        long implementationScore = 0L;
        return new Score(actionPriority, resourceScore, waitingScore, implementationScore);
    }

    public Score generateResourceScore(AllocatableAction action, TaskDescription params, Score actionScore) {
        long actionPriority = actionScore.getActionScore();
        long waitingScore = -this.blocked.size();
        long resourceScore = Score.calculateDataLocalityScore((TaskDescription)params, (Worker)this.myWorker);
        return new Score(actionPriority, resourceScore, waitingScore, 0L);
    }

    public Score generateImplementationScore(AllocatableAction action, TaskDescription params, Implementation impl, Score resourceScore) {
        if (this.hasBlockedActions()) {
            return null;
        }
        if (this.myWorker.canRunNow(impl.getRequirements())) {
            long actionPriority = resourceScore.getActionScore();
            long waitingScore = resourceScore.getWaitingScore();
            long resourcePriority = resourceScore.getResourceScore();
            long implScore = -this.getProfile(impl).getAverageExecutionTime();
            return new Score(actionPriority, resourcePriority, waitingScore, implScore);
        }
        return null;
    }

    public String toString() {
        return "DataResourceScheduler@" + this.getName();
    }
}

