/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.multiobjective.types;

import es.bsc.compss.scheduler.types.Profile;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import org.json.JSONException;
import org.json.JSONObject;

public class MOProfile
extends Profile {
    private static final double DEFAULT_PRICE = 0.0;
    private static final double DEFAULT_POWER = 0.0;
    private double power;
    private double price;

    public MOProfile() {
        this.power = 0.0;
        this.price = 0.0;
    }

    private MOProfile(MOProfile p) {
        super((Profile)p);
        this.power = p.power;
        this.price = p.price;
    }

    public MOProfile(JSONObject json) {
        super(json);
        if (json != null) {
            try {
                this.power = json.getDouble("power");
            }
            catch (JSONException je) {
                this.power = 0.0;
            }
            try {
                this.price = json.getDouble("price");
            }
            catch (JSONException je) {
                this.price = 0.0;
            }
        } else {
            this.power = 0.0;
            this.price = 0.0;
        }
    }

    public <T extends WorkerResourceDescription> MOProfile(Implementation impl, Worker<T> resource) {
        this.power = 0.0;
        this.price = 0.0;
    }

    public double getPower() {
        return this.power;
    }

    public double getPrice() {
        return this.price;
    }

    public void accumulate(MOProfile profile) {
        super.accumulate((Profile)profile);
    }

    public JSONObject toJSONObject() {
        JSONObject jo = super.toJSONObject();
        jo.put("power", this.power);
        jo.put("price", this.price);
        return jo;
    }

    public JSONObject updateJSON(JSONObject jo) {
        JSONObject difference = super.updateJSON(jo);
        double diff = this.power;
        if (jo.has("power")) {
            diff -= jo.getDouble("power");
        }
        difference.put("power", diff);
        jo.put("power", this.power);
        diff = this.price;
        if (jo.has("price")) {
            diff -= jo.getDouble("price");
        }
        difference.put("price", diff);
        jo.put("price", this.price);
        return difference;
    }

    public Profile copy() {
        return new MOProfile(this);
    }

    public String toString() {
        return "[MOProfile " + this.getContent() + "]";
    }

    protected String getContent() {
        return super.getContent() + " power=" + this.power + " price=" + this.price;
    }

    public static class Builder
    extends Profile.Builder {
        private double power = 0.0;
        private double price = 0.0;

        public MOProfile build() {
            MOProfile p = new MOProfile();
            this.update(p);
            return p;
        }

        public void setPower(double power) {
            this.power = power;
        }

        public void setPrice(double price) {
            this.price = price;
        }

        protected <P extends MOProfile> void update(P p) {
            super.update(p);
            P prof = p;
            ((MOProfile)prof).power = this.power;
            ((MOProfile)prof).price = this.price;
        }
    }
}

