/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.loadBalancingScheduler;

import es.bsc.compss.scheduler.readyScheduler.ReadyResourceScheduler;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.schedulerloadBalancingScheduler.types.LoadBalancingScore;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import org.json.JSONObject;

public class LoadBalancingResourceScheduler<T extends WorkerResourceDescription>
extends ReadyResourceScheduler<T> {
    public LoadBalancingResourceScheduler(Worker<T> w, JSONObject resJSON, JSONObject implJSON) {
        super(w, resJSON, implJSON);
    }

    public Score generateBlockedScore(AllocatableAction action) {
        long actionPriority = action.getPriority();
        long resourceScore = 0L;
        long waitingScore = this.blocked.size();
        long implementationScore = 0L;
        return new LoadBalancingScore(actionPriority, resourceScore, waitingScore, implementationScore);
    }

    public Score generateResourceScore(AllocatableAction action, TaskDescription params, Score actionScore) {
        long actionPriority = actionScore.getActionScore();
        long waitingScore = -action.getId();
        long resourceScore = this.calculateResourceScore(params);
        long implementationScore = -100L;
        LoadBalancingScore score = new LoadBalancingScore(actionPriority, resourceScore, waitingScore, implementationScore);
        return score;
    }

    public long calculateResourceScore(TaskDescription params) {
        long resourceScore = 0L;
        if (params != null) {
            Parameter[] parameters = params.getParameters();
            if (parameters.length == 0) {
                return 1L;
            }
            resourceScore = 2L * Score.calculateDataLocalityScore((TaskDescription)params, (Worker)this.myWorker);
        }
        return resourceScore;
    }

    public Score generateImplementationScore(AllocatableAction action, TaskDescription params, Implementation impl, Score resourceScore) {
        if (this.hasBlockedActions()) {
            return null;
        }
        if (this.myWorker.canRunNow(impl.getRequirements())) {
            long actionPriority = resourceScore.getActionScore();
            long resourcePriority = resourceScore.getResourceScore();
            long waitingScore = -action.getId();
            long implScore = -this.getProfile(impl).getAverageExecutionTime();
            return new LoadBalancingScore(actionPriority, resourcePriority, waitingScore, implScore);
        }
        return null;
    }

    public String toString() {
        return "LoadBalancingResourceScheduler@" + this.getName();
    }
}

