/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.maven.instrumentation;

import es.bsc.servicess.ide.CommonUtils;
import es.bsc.servicess.ide.ProjectMetadata;
import es.bsc.servicess.ide.model.ElementLabelUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.xml.sax.SAXException;

public class InstrumentMojo
extends AbstractMojo {
    private File outputDirectory;
    private MavenProject project;
    private File metadataFile;
    private String compssLocation;
    private String mainClass;
    private List<String> webServiceClasses;
    private String[] orchestrations;

    public void execute() throws MojoExecutionException {
        block13: {
            try {
                this.getLog().info((CharSequence)"COMPSs code instrumentation...");
                if (this.outputDirectory != null && this.outputDirectory.exists() && this.project != null) {
                    String classesFolder = this.outputDirectory.getAbsolutePath().concat(File.separator + "classes");
                    this.getLog().debug((CharSequence)("Classes folder " + classesFolder));
                    List ccp = this.project.getCompileClasspathElements();
                    List cp = this.project.getRuntimeClasspathElements();
                    cp.addAll(ccp);
                    if (this.metadataFile != null && this.metadataFile.exists()) {
                        this.getLog().info((CharSequence)"Getting values from metadata file...");
                        ProjectMetadata prMeta = new ProjectMetadata(this.metadataFile);
                        String[] extClasses = prMeta.getExternalOrchestrationClasses();
                        this.compssLocation = prMeta.getRuntimeLocation();
                        for (String cl : extClasses) {
                            this.getLog().warn((CharSequence)"External classses not supported yet, skipping cl");
                        }
                        String[] intClasses = prMeta.getNonExternalOrchestrationClasses();
                        CommonUtils.instrumentOrchestrations((String)this.compssLocation, (String[])intClasses, (String)classesFolder, (List)cp, (Map)prMeta.getOrchestrationClassesTypes(intClasses), (String)this.mainClass);
                    } else {
                        this.getLog().info((CharSequence)"Metadata does not exists.");
                    }
                    if (this.orchestrations != null && this.orchestrations.length > 0) {
                        this.getLog().info((CharSequence)"Treating defined orchestrations ...");
                        Map orchClassAndElements = ElementLabelUtils.getClassesAndElements((String[])this.orchestrations);
                        for (Map.Entry entry : orchClassAndElements.entrySet()) {
                            CommonUtils.preInstrumentOrchestration((String)this.compssLocation, (String)((String)entry.getKey()), (List)((List)entry.getValue()), (String)classesFolder, (List)cp);
                            String cl = (String)entry.getKey();
                            boolean isWs = this.webServiceClasses != null && this.webServiceClasses.contains(cl);
                            boolean isMainClass = this.mainClass != null && cl.equals(this.mainClass);
                            CommonUtils.instrumentOrchestration((String)this.compssLocation, (String)cl, (String)classesFolder, (List)cp, (boolean)isWs, (boolean)isMainClass);
                        }
                    } else {
                        this.getLog().info((CharSequence)"There are not defined orchestrations.");
                    }
                    break block13;
                }
                this.getLog().error((CharSequence)("Output dir " + this.outputDirectory.getAbsolutePath() + " or maven project does not exist"));
                throw new MojoExecutionException("Output dir or maven project does not exist");
            }
            catch (DependencyResolutionRequiredException e) {
                this.getLog().error((CharSequence)"Exception getting project classpath");
                this.getLog().error((Throwable)e);
                throw new MojoExecutionException("Exception getting project classpath", (Exception)((Object)e));
            }
            catch (SAXException e) {
                this.getLog().error((CharSequence)"Exception parsing metadata file");
                this.getLog().error((Throwable)e);
                throw new MojoExecutionException("Exception parsing metadata file", (Exception)e);
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"Exception parsing metadata file");
                this.getLog().error((Throwable)e);
                throw new MojoExecutionException("Exception parsing metadata file", (Exception)e);
            }
            catch (ParserConfigurationException e) {
                this.getLog().error((CharSequence)"Exception parsing metadata file");
                this.getLog().error((Throwable)e);
                throw new MojoExecutionException("Exception parsing metadata file", (Exception)e);
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)"Exception getting orchestration Classes");
                this.getLog().error((Throwable)e);
                throw new MojoExecutionException("Exception getting orchestration Classes", e);
            }
        }
    }
}

