/*
 * Decompiled with CFR 0.152.
 */
package storage;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.util.JedisClusterCRC16;
import storage.CallbackEvent;
import storage.CallbackHandler;
import storage.StorageException;
import storage.StorageObject;
import storage.utils.Serializer;

public final class StorageItf {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Storage");
    private static final String ERROR_HOSTNAME = "ERROR_HOSTNAME";
    private static final String MASTER_HOSTNAME;
    private static final int REDIS_PORT = 6379;
    private static final int REDIS_MAX_CLIENTS = 524288;
    private static final int REDIS_MAX_HASH_SLOTS = 16384;
    private static JedisCluster redisClusterConnection;
    private static JedisPool redisConnection;
    private static boolean clusterMode;
    private static List<String> hosts;
    private static HashMap<String, String> previousVersion;
    private static ArrayList<String>[] hostsBySlot;

    public static void init(String storageConf) throws StorageException, IOException {
        LOGGER.info("[LOG] Configuration received: " + storageConf);
        try (BufferedReader br = new BufferedReader(new FileReader(storageConf));){
            String line;
            while ((line = br.readLine()) != null) {
                hosts.add(line.trim());
                LOGGER.info("Adding " + line.trim() + " to list of known hosts...");
            }
        }
        catch (FileNotFoundException e) {
            throw new StorageException("Could not find configuration file", e);
        }
        catch (IOException e) {
            throw new StorageException("Could not open configuration file", e);
        }
        assert (!hosts.isEmpty());
        boolean bl = clusterMode = hosts.size() > 1;
        if (clusterMode) {
            LOGGER.info("More than one host detected, enabling Client Cluster Mode");
            redisClusterConnection = new JedisCluster(new HostAndPort(hosts.get(0), 6379));
            StorageItf.preComputeHostHashMap();
        } else {
            LOGGER.info("Only one host detect, using standalone client...");
            JedisPoolConfig poolConfig = new JedisPoolConfig();
            poolConfig.setMaxTotal(524288);
            redisConnection = new JedisPool((GenericObjectPoolConfig)poolConfig, hosts.get(0), 6379);
        }
    }

    private static void preComputeHostHashMap() {
        String someHost = (String)redisClusterConnection.getClusterNodes().keySet().toArray()[0];
        String clusterInfo = redisClusterConnection.getClusterNodes().get(someHost).getResource().clusterNodes();
        String[] clusterLines = clusterInfo.split("\n");
        ArrayList<Host> clusterHosts = new ArrayList<Host>();
        for (String line : clusterLines) {
            Host h = new Host(line);
            clusterHosts.add(h);
        }
        for (int i = 0; i < 16384; ++i) {
            ArrayList<String> validHosts = new ArrayList<String>();
            for (Host h : clusterHosts) {
                if (h.l > i || i > h.r) continue;
                validHosts.add(h.host);
            }
            StorageItf.hostsBySlot[i] = new ArrayList(new TreeSet(validHosts));
        }
    }

    public static void finish() throws StorageException {
        if (clusterMode) {
            try {
                redisClusterConnection.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            redisConnection.close();
        }
    }

    public static List<String> getLocations(String id) throws StorageException {
        if (id != null && clusterMode) {
            int slot = JedisClusterCRC16.getSlot(id);
            return hostsBySlot[slot];
        }
        return hosts;
    }

    public static void newReplica(String id, String hostName) throws StorageException {
        throw new StorageException("Redis does not support this feature.");
    }

    private static void putInRedis(byte[] serializedObject, String id) throws StorageException {
        String result;
        String string = result = clusterMode ? redisClusterConnection.set(id.getBytes(), serializedObject) : redisConnection.getResource().set(id.getBytes(), serializedObject);
        if (!result.equals("OK")) {
            throw new StorageException("Redis returned an error while trying to store object with id " + id);
        }
    }

    public static String newVersion(String id, boolean preserveSource, String hostName) throws StorageException, IOException, ClassNotFoundException {
        byte[] obj = StorageItf.getBytesByID(id);
        String newId = UUID.randomUUID().toString();
        previousVersion.put(newId, id);
        StorageItf.putInRedis(obj, newId);
        if (!preserveSource) {
            StorageItf.consolidateVersion(newId);
        }
        return newId;
    }

    public static Object getByID(String id) throws StorageException, IOException, ClassNotFoundException {
        byte[] serializedObject;
        byte[] byArray = serializedObject = clusterMode ? redisClusterConnection.get(id.getBytes()) : redisConnection.getResource().get(id.getBytes());
        if (serializedObject == null) {
            throw new StorageException("Object with id " + id + " is not in Redis!");
        }
        Object ret = Serializer.deserialize(serializedObject);
        ((StorageObject)ret).setID(id);
        return ret;
    }

    private static byte[] getBytesByID(String id) throws StorageException {
        byte[] ret;
        byte[] byArray = ret = clusterMode ? redisClusterConnection.get(id.getBytes()) : redisConnection.getResource().get(id.getBytes());
        if (ret == null) {
            throw new StorageException("Object with id " + id + " is not in Redis!");
        }
        return ret;
    }

    public static String executeTask(String id, String descriptor, Object[] values, String hostName, CallbackHandler callback) throws StorageException {
        throw new StorageException("Redis does not support this feature.");
    }

    public static Object getResult(CallbackEvent event) throws StorageException {
        throw new StorageException("Redis does not support this feature.");
    }

    public static void consolidateVersion(String idFinal) throws StorageException {
        LOGGER.info("Consolidating version for " + idFinal);
        idFinal = previousVersion.get(idFinal);
        while (idFinal != null) {
            LOGGER.info("Removing version " + idFinal);
            StorageItf.removeById(idFinal);
            String oldId = idFinal;
            idFinal = previousVersion.get(idFinal);
            previousVersion.remove(oldId);
        }
    }

    public static void makePersistent(Object o, String id) throws StorageException, IOException {
        String result;
        byte[] serializedObject = Serializer.serialize(o);
        String string = result = clusterMode ? redisClusterConnection.set(id.getBytes(), serializedObject) : redisConnection.getResource().set(id.getBytes(), serializedObject);
        if (!result.equals("OK")) {
            throw new StorageException("Redis returned an error while trying to store object with id " + id);
        }
    }

    public static void removeById(String id) {
        if (clusterMode) {
            redisClusterConnection.del(id.getBytes());
        } else {
            redisConnection.getResource().del(id.getBytes());
        }
    }

    public static void main(String[] args) throws ClassNotFoundException {
        try {
            StorageItf.init("/home/sergiorg/git/framework/utils/storage/redisPSCO/scripts/sample_hosts");
            if (clusterMode) {
                MyStorageObject myObject = new MyStorageObject("This is an object");
                myObject.makePersistent();
                Map<String, JedisPool> m = redisClusterConnection.getClusterNodes();
                Iterator<String> iterator = m.keySet().iterator();
                if (iterator.hasNext()) {
                    String s = iterator.next();
                    JedisPool jp = m.get(s);
                    Jedis j = jp.getResource();
                }
            } else {
                MyStorageObject myObject = new MyStorageObject("This is an object");
                StorageItf.makePersistent(myObject, "prueba");
                Object retrieved = StorageItf.getByID("prueba");
                System.out.println(((MyStorageObject)retrieved).getInnerString());
                myObject.updatePersistent();
                StorageItf.removeById("prueba");
            }
        }
        catch (IOException | StorageException e) {
            e.printStackTrace();
        }
    }

    static {
        clusterMode = true;
        hosts = new ArrayList<String>();
        previousVersion = new HashMap();
        hostsBySlot = new ArrayList[16384];
        String hostname = null;
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            hostname = localHost.getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            System.err.println(ERROR_HOSTNAME);
            e.printStackTrace();
            System.exit(1);
        }
        MASTER_HOSTNAME = hostname;
    }

    static class MyStorageObject
    extends StorageObject
    implements Serializable {
        private String innerString;

        public MyStorageObject(String myString) {
            this.innerString = myString;
        }

        public String getInnerString() {
            return this.innerString;
        }

        public void setInnerString(String innerString) {
            this.innerString = innerString;
        }
    }

    private static class Host {
        String host;
        int l;
        int r;

        Host(String clusterInfoLine) {
            String[] tokens = clusterInfoLine.split(" ");
            this.host = tokens[1].split("@")[0].split(":")[0];
            InetAddress addr = null;
            try {
                addr = InetAddress.getByName(this.host);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            this.host = addr.getHostName();
            String[] interval = tokens[tokens.length - 1].split("-");
            this.l = Integer.parseInt(interval[0]);
            this.r = Integer.parseInt(interval[1]);
        }

        void printHostInfo() {
            System.out.printf("Host %s covers slots [%d, %d]\n", this.host, this.l, this.r);
        }
    }
}

