/*
 * Decompiled with CFR 0.152.
 */
package storage;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import storage.StorageException;
import storage.StorageItf;
import storage.StubItf;

public class StorageObject
implements StubItf {
    private static final Logger logger = LogManager.getLogger("es.bsc.compss.Storage");
    private String host;
    private String id = null;

    public StorageObject() {
    }

    public StorageObject(String alias) {
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public void makePersistent(String id) throws IOException, StorageException {
        if (this.id != null) {
            return;
        }
        this.setHost();
        if (id == null) {
            id = UUID.randomUUID().toString();
        }
        this.id = id;
        StorageItf.makePersistent(this, id);
    }

    private void setHost() {
        String hostname = null;
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            hostname = localHost.getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            System.exit(1);
        }
        this.host = hostname;
    }

    public void makePersistent() throws IOException, StorageException {
        this.makePersistent(null);
    }

    @Override
    public void deletePersistent() {
        if (this.id == null) {
            return;
        }
        StorageItf.removeById(this.id);
        this.id = null;
    }

    protected void setID(String id) throws IOException, StorageException {
        this.id = id;
    }

    public void updatePersistent() {
        String pId = this.getID();
        this.deletePersistent();
        try {
            this.makePersistent(pId);
        }
        catch (IOException | StorageException e) {
            e.printStackTrace();
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }
}

