/*
 * Decompiled with CFR 0.152.
 */
package multiProcessor;

import commons.Action;
import es.bsc.compss.api.impl.COMPSsRuntimeImpl;
import es.bsc.compss.scheduler.types.ActionOrchestrator;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.MethodWorker;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.util.CoreManager;
import es.bsc.compss.util.ResourceManager;
import java.util.LinkedList;
import java.util.Map;

public class TestAvailable {
    private static final String NAME_CORE_ELEMENT_1 = "coreElement1";
    private static final String NAME_CORE_ELEMENT_2 = "coreElement2";
    private static final String NAME_CORE_ELEMENT_3 = "coreElement3";
    private static final String NAME_CORE_ELEMENT_4 = "coreElement4";
    private static final String NAME_WORKER = "COMPSsWorker01";
    private static int coreCount;
    private static LinkedList<String>[] idToSignatures;
    private static String[] coreToName;

    public static void main(String[] args) {
        System.out.println("[LOG] Waiting for Runtime to be loaded");
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        System.out.println("[LOG] Running Available Resource Manager Test");
        TestAvailable.availableResourcesTest();
    }

    private static void availableResourcesTest() {
        coreCount = CoreManager.getCoreCount();
        idToSignatures = new LinkedList[coreCount];
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            TestAvailable.idToSignatures[coreId] = new LinkedList();
        }
        for (Map.Entry entry : CoreManager.getSignaturesToId().entrySet()) {
            String signature = (String)entry.getKey();
            Integer coreId = (Integer)entry.getValue();
            idToSignatures[coreId].add(signature);
        }
        boolean found_ce1 = false;
        boolean found_ce2 = false;
        boolean found_ce3 = false;
        boolean found_ce4 = false;
        int ce1 = 0;
        int ce2 = 0;
        int ce3 = 0;
        int ce4 = 0;
        coreToName = new String[coreCount];
        for (int i = 0; i < coreCount; ++i) {
            int cutValue = idToSignatures[i].getFirst().indexOf("(");
            TestAvailable.coreToName[i] = idToSignatures[i].getFirst().substring(0, cutValue);
            if (coreToName[i].equals(NAME_CORE_ELEMENT_1)) {
                ce1 = i;
                found_ce1 = true;
            }
            if (coreToName[i].equals(NAME_CORE_ELEMENT_2)) {
                ce2 = i;
                found_ce2 = true;
            }
            if (coreToName[i].equals(NAME_CORE_ELEMENT_3)) {
                ce3 = i;
                found_ce3 = true;
            }
            if (!coreToName[i].equals(NAME_CORE_ELEMENT_4)) continue;
            ce4 = i;
            found_ce4 = true;
        }
        if (!found_ce1) {
            System.out.println("[ERROR] coreElement1 not found.");
            System.exit(-1);
        }
        if (!found_ce2) {
            System.out.println("[ERROR] coreElement2 not found.");
            System.exit(-1);
        }
        if (!found_ce3) {
            System.out.println("[ERROR] coreElement3 not found.");
            System.exit(-1);
        }
        if (!found_ce4) {
            System.out.println("[ERROR] coreElement4 not found.");
            System.exit(-1);
        }
        Worker worker = ResourceManager.getWorker((String)NAME_WORKER);
        System.out.println("Worker COMPSsWorker01: " + worker.getDescription());
        ActionOrchestrator orchestrator = COMPSsRuntimeImpl.getOrchestrator();
        Action a = new Action(orchestrator, ce3);
        if (a.findAvailableWorkers().containsKey(worker)) {
            System.out.println("[ERROR] Available resources internalMemorySize filter inside Processor annotation is not working");
            System.exit(-1);
        }
        if ((a = new Action(orchestrator, ce4)).findAvailableWorkers().containsKey(worker)) {
            System.out.println("[ERROR] Available resources processorInternalMemorySize filter is not working");
            System.exit(-1);
        }
        System.out.println("Worker COMPSsWorker01: " + worker.getDescription());
        System.out.println("Implementation 1: " + CoreManager.getCoreImplementations((int)ce1).get(0));
        MethodResourceDescription consumed1 = (MethodResourceDescription)worker.runTask(((Implementation)CoreManager.getCoreImplementations((int)ce1).get(0)).getRequirements());
        System.out.println("CONSUMED: " + consumed1);
        if (!TestAvailable.checkDescription(consumed1, 2, 2, 1, 0)) {
            System.out.println("[ERROR] consumed resources for CPU + GPU + FPGA is not working");
            System.exit(-1);
        }
        MethodResourceDescription remaining = ((MethodWorker)worker).getAvailable();
        System.out.println("REMAINING: " + remaining);
        if (!TestAvailable.checkDescription(remaining, 2, 1, 2, 3)) {
            System.out.println("[ERROR] remaining resources for CPU + GPU + FPGA is not working");
            System.exit(-1);
        }
        MethodResourceDescription consumed2 = (MethodResourceDescription)worker.runTask(((Implementation)CoreManager.getCoreImplementations((int)ce2).get(0)).getRequirements());
        System.out.println("CONSUMED: " + consumed2);
        if (!TestAvailable.checkDescription(consumed2, 1, 0, 1, 2)) {
            System.out.println("[ERROR] consumed resources for CPU + OTHER + FPGA is not working");
            System.exit(-1);
        }
        remaining = ((MethodWorker)worker).getAvailable();
        System.out.println("REMAINING: " + remaining);
        if (!TestAvailable.checkDescription(remaining, 1, 1, 1, 1)) {
            System.out.println("[ERROR] remaining resources for CPU + OTHER + FPGA is not working");
            System.exit(-1);
        }
        if ((a = new Action(orchestrator, ce1)).findAvailableWorkers().containsKey(worker)) {
            System.out.println("[ERROR] Available resources for CPU + GPU + FPGA reserve is not working");
            System.exit(-1);
        }
        if ((a = new Action(orchestrator, ce2)).findAvailableWorkers().containsKey(worker)) {
            System.out.println("[ERROR] Available resources for CPU + OTHER + FPGA reserve is not working");
            System.exit(-1);
        }
        worker.endTask((WorkerResourceDescription)consumed1);
        a = new Action(orchestrator, ce1);
        if (!a.findAvailableWorkers().containsKey(worker)) {
            System.out.println("[ERROR] Available resources for CPU + GPU + FPGA free is not working");
            System.exit(-1);
        }
        worker.endTask((WorkerResourceDescription)consumed2);
        a = new Action(orchestrator, ce2);
        if (!a.findAvailableWorkers().containsKey(worker)) {
            System.out.println("[ERROR] Available resources for CPU + OTHER + FPGA free is not working");
            System.exit(-1);
        }
        System.out.println("[LOG] * Multi-processors test passed");
    }

    private static boolean checkDescription(MethodResourceDescription description, int CPUcus, int GPUcus, int FPGAcus, int OTHERcus) {
        return description != null && description.getTotalCPUComputingUnits() == CPUcus && description.getTotalGPUComputingUnits() == GPUcus && description.getTotalFPGAComputingUnits() == FPGAcus && description.getTotalOTHERComputingUnits() == OTHERcus;
    }
}

