/*
 * Decompiled with CFR 0.152.
 */
package resourceManager;

import commons.Action;
import es.bsc.compss.api.impl.COMPSsRuntimeImpl;
import es.bsc.compss.scheduler.types.ActionOrchestrator;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.util.CoreManager;
import es.bsc.compss.util.ResourceManager;
import java.util.LinkedList;
import java.util.Map;

public class TestAvailable {
    private static final String NAME_CORE_ELEMENT_1 = "coreElement1";
    private static final String NAME_CORE_ELEMENT_2 = "coreElement2";
    private static final String NAME_WORKER = "COMPSsWorker01";
    private static int coreCount;
    private static LinkedList<String>[] idToSignatures;
    private static String[] coreToName;

    public static void main(String[] args) {
        System.out.println("[LOG] Waiting for Runtime to be loaded");
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        System.out.println("[LOG] Running Available Resource Manager Test");
        TestAvailable.availableResourcesTest();
    }

    private static void availableResourcesTest() {
        coreCount = CoreManager.getCoreCount();
        idToSignatures = new LinkedList[coreCount];
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            TestAvailable.idToSignatures[coreId] = new LinkedList();
        }
        for (Map.Entry entry : CoreManager.getSignaturesToId().entrySet()) {
            String signature = (String)entry.getKey();
            Integer coreId = (Integer)entry.getValue();
            idToSignatures[coreId].add(signature);
        }
        boolean found_ce1 = false;
        boolean found_ce2 = false;
        int ce1 = 0;
        int ce2 = 0;
        coreToName = new String[coreCount];
        for (int i = 0; i < coreCount; ++i) {
            int cutValue = idToSignatures[i].getFirst().indexOf("(");
            TestAvailable.coreToName[i] = idToSignatures[i].getFirst().substring(0, cutValue);
            if (coreToName[i].equals(NAME_CORE_ELEMENT_1)) {
                ce1 = i;
                found_ce1 = true;
            }
            if (!coreToName[i].equals(NAME_CORE_ELEMENT_2)) continue;
            ce2 = i;
            found_ce2 = true;
        }
        if (!found_ce1) {
            System.out.println("[ERROR] coreElement1 not found.");
            System.exit(-1);
        }
        if (!found_ce2) {
            System.out.println("[ERROR] coreElement2 not found.");
            System.exit(-1);
        }
        Worker worker = ResourceManager.getWorker((String)NAME_WORKER);
        System.out.println("Worker COMPSsWorker01: " + worker.getDescription());
        System.out.println("Implementation 1: " + CoreManager.getCoreImplementations((int)ce1).get(0));
        WorkerResourceDescription consumed1 = worker.runTask(((Implementation)CoreManager.getCoreImplementations((int)ce1).get(0)).getRequirements());
        WorkerResourceDescription consumed2 = worker.runTask(((Implementation)CoreManager.getCoreImplementations((int)ce1).get(0)).getRequirements());
        System.out.println("CONSUMED: " + consumed1);
        System.out.println("CONSUMED: " + consumed2);
        ActionOrchestrator orchestrator = COMPSsRuntimeImpl.getOrchestrator();
        Action a = new Action(orchestrator, ce1);
        if (a.findAvailableWorkers().containsKey(worker)) {
            System.out.println("[ERROR] Available resources for CORE reserve is not working");
            System.exit(-1);
        }
        worker.endTask(consumed1);
        if (!a.findAvailableWorkers().containsKey(worker)) {
            System.out.println("[ERROR] Available resources for CORE free is not working");
            System.exit(-1);
        }
        worker.endTask(consumed2);
        a = new Action(orchestrator, ce2);
        consumed1 = worker.runTask(((Implementation)CoreManager.getCoreImplementations((int)ce2).get(0)).getRequirements());
        consumed2 = worker.runTask(((Implementation)CoreManager.getCoreImplementations((int)ce2).get(0)).getRequirements());
        if (a.findAvailableWorkers().containsKey(worker)) {
            System.out.println("[ERROR] Available resources for MEMORY reserve is not working");
            System.exit(-1);
        }
        worker.endTask(consumed1);
        if (!a.findAvailableWorkers().containsKey(worker)) {
            System.out.println("[ERROR] Available resources for MEMORY free is not working");
            System.exit(-1);
        }
        worker.endTask(consumed2);
        System.out.println("[LOG] * Available Resources test passed");
    }
}

