/*
 * Decompiled with CFR 0.152.
 */
package resourceManager;

import commons.Action;
import es.bsc.compss.api.impl.COMPSsRuntimeImpl;
import es.bsc.compss.scheduler.types.ActionOrchestrator;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.MethodImplementation;
import es.bsc.compss.types.implementations.ServiceImplementation;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.MethodWorker;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.ServiceResourceDescription;
import es.bsc.compss.types.resources.ServiceWorker;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.components.Processor;
import es.bsc.compss.util.CoreManager;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class TestCompatible {
    private static int coreCount;

    public static void main(String[] args) {
        System.out.println("[LOG] Waiting for Runtime to be loaded");
        try {
            Thread.sleep(15000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("[LOG] Running Compatible Resource Manager Test");
        TestCompatible.resourceManagerTest();
    }

    private static void resourceManagerTest() {
        coreCount = CoreManager.getCoreCount();
        ActionOrchestrator orchestrator = COMPSsRuntimeImpl.getOrchestrator();
        System.out.println("[LOG] Number of cores = " + coreCount);
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            System.out.println("[LOG] Checking Core" + coreId);
            Action a = new Action(orchestrator, coreId);
            Map<Worker<?>, List<Implementation>> m = a.findAvailableWorkers();
            if (m.size() == 0) {
                System.err.println("[ERROR] CoreId " + coreId + " cannot be run");
                List impls = CoreManager.getCoreImplementations((int)coreId);
                for (Implementation impl : impls) {
                    System.out.println("-- Impl: " + impl.getRequirements().toString());
                }
                System.exit(-1);
            }
            TestCompatible.checkCoreResources(coreId, m);
        }
    }

    private static void checkCoreResources(int coreId, Map<Worker<?>, List<Implementation>> hm) {
        HashMap hm_reverted = new HashMap();
        for (Map.Entry<Worker<?>, List<Implementation>> entry : hm.entrySet()) {
            for (Implementation implementation : entry.getValue()) {
                LinkedList aux = (LinkedList)hm_reverted.get(implementation);
                if (aux == null) {
                    aux = new LinkedList();
                }
                aux.add(entry.getKey());
                hm_reverted.put(implementation, aux);
            }
        }
        for (Map.Entry<Object, List<Object>> entry : hm_reverted.entrySet()) {
            System.out.println("[LOG] ** Checking Implementation " + entry.getKey());
            System.out.println("[LOG] **** Number of resources = " + entry.getValue().size());
            for (Worker worker : entry.getValue()) {
                System.out.println("[LOG] **** Checking Resource " + worker.getName());
                String res = TestCompatible.checkResourcesAssignedToImpl((Implementation)entry.getKey(), worker);
                if (res == null) continue;
                String error = "Implementation: Core " + coreId + " Impl " + ((Implementation)entry.getKey()).getImplementationId() + " and Resource " + worker.getName() + ". ";
                error = error.concat("Implementation and resource not matching on: " + res);
                System.out.println(error);
                System.exit(-1);
            }
        }
    }

    private static String checkResourcesAssignedToImpl(Implementation impl, Worker<?> resource) {
        if (impl.getTaskType().equals((Object)Implementation.TaskType.METHOD) && resource.getType().equals((Object)Resource.Type.SERVICE) || impl.getTaskType().equals((Object)Implementation.TaskType.SERVICE) && resource.getType().equals((Object)Resource.Type.WORKER)) {
            return "types";
        }
        if (resource.getType() == Resource.Type.WORKER) {
            MethodImplementation mImpl = (MethodImplementation)impl;
            MethodResourceDescription iDescription = mImpl.getRequirements();
            MethodWorker worker = (MethodWorker)resource;
            MethodResourceDescription wDescription = (MethodResourceDescription)worker.getDescription();
            if (iDescription.getTotalCPUComputingUnits() >= 1 && wDescription.getTotalCPUComputingUnits() >= 1 && wDescription.getTotalCPUComputingUnits() < iDescription.getTotalCPUComputingUnits()) {
                return "computingUnits";
            }
            for (Processor ip : iDescription.getProcessors()) {
                boolean canBeHosted = false;
                for (Processor wp : wDescription.getProcessors()) {
                    if (!ip.getName().equals("[unassigned]") && !wp.getName().equals("[unassigned]") && !wp.getName().equals(ip.getName()) || ip.getSpeed() != -1.0f && wp.getSpeed() != -1.0f && wp.getSpeed() < ip.getSpeed() || !ip.getArchitecture().equals("[unassigned]") && !wp.getArchitecture().equals("[unassigned]") && !wp.getArchitecture().equals(ip.getArchitecture()) || !ip.getPropName().equals("[unassigned]") && !wp.getPropName().equals("[unassigned]") && !ip.getPropName().equals(wp.getPropName()) || !ip.getPropValue().equals("[unassigned]") && !wp.getPropValue().equals("[unassigned]") && !ip.getPropValue().equals(wp.getPropValue()) || wp.getComputingUnits() < ip.getComputingUnits()) continue;
                    canBeHosted = true;
                    break;
                }
                if (canBeHosted) continue;
                return "processor";
            }
            if (iDescription.getMemorySize() != -1.0f && wDescription.getMemorySize() != -1.0f && wDescription.getMemorySize() < iDescription.getMemorySize()) {
                return "memorySize";
            }
            if (!(iDescription.getMemoryType().equals("[unassigned]") || iDescription.getMemoryType().equals("[unassigned]") || wDescription.getMemoryType().equals(iDescription.getMemoryType()))) {
                return "memoryType";
            }
            if (iDescription.getStorageSize() != -1.0f && wDescription.getStorageSize() != -1.0f && wDescription.getStorageSize() < iDescription.getStorageSize()) {
                return "storageSize";
            }
            if (!(iDescription.getStorageType().equals("[unassigned]") || iDescription.getStorageType().equals("[unassigned]") || wDescription.getStorageType().equals(iDescription.getStorageType()))) {
                return "storageType";
            }
            if (!(iDescription.getOperatingSystemType().equals("[unassigned]") || iDescription.getOperatingSystemType().equals("[unassigned]") || wDescription.getOperatingSystemType().equals(iDescription.getOperatingSystemType()))) {
                return "operatingSystemType";
            }
            if (!(iDescription.getOperatingSystemDistribution().equals("[unassigned]") || iDescription.getOperatingSystemDistribution().equals("[unassigned]") || wDescription.getOperatingSystemDistribution().equals(iDescription.getOperatingSystemDistribution()))) {
                return "operatingSystemDistribution";
            }
            if (!(iDescription.getOperatingSystemVersion().equals("[unassigned]") || iDescription.getOperatingSystemVersion().equals("[unassigned]") || wDescription.getOperatingSystemVersion().equals(iDescription.getOperatingSystemVersion()))) {
                return "operatingSystemVersion";
            }
            if (!iDescription.getAppSoftware().isEmpty() && !wDescription.getAppSoftware().containsAll(iDescription.getAppSoftware())) {
                return "appSoftware";
            }
            if (!iDescription.getHostQueues().isEmpty() && !wDescription.getHostQueues().containsAll(iDescription.getHostQueues())) {
                return "hostQueues";
            }
        } else if (resource.getType() == Resource.Type.SERVICE) {
            ServiceImplementation sImpl = (ServiceImplementation)impl;
            ServiceResourceDescription iDescription = sImpl.getRequirements();
            ServiceWorker worker = (ServiceWorker)resource;
            ServiceResourceDescription wDescription = (ServiceResourceDescription)worker.getDescription();
            if (!wDescription.getServiceName().equals(iDescription.getServiceName())) {
                return "ServiceName";
            }
            if (!wDescription.getNamespace().equals(iDescription.getNamespace())) {
                return "Namespace";
            }
            if (!wDescription.getPort().equals(iDescription.getPort())) {
                return "Port";
            }
        } else {
            return "Unknown resource type";
        }
        return null;
    }
}

