/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.file;

import java.io.File;
import java.util.Locale;
import java.util.Set;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public final class Matcher {
    public static final String DEEP_TREE_MATCH = "**";
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
    private static final String PATH_SEP = System.getProperty("path.separator");
    private static final boolean ON_NETWARE = Matcher.isNetware();
    private static final boolean ON_DOS = Matcher.isDos();
    private static final StringManager sm = StringManager.getManager("org.apache.tomcat.util.file");
    private static final Log log = LogFactory.getLog(Matcher.class);

    public static boolean matchPath(Set<String[]> patternSet, String str) {
        for (String[] patternTokens : patternSet) {
            if (!Matcher.matchPath(patternTokens, Matcher.tokenizePathAsArray(str), true)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchPath(String pattern, String str) {
        String[] patDirs = Matcher.tokenizePathAsArray(pattern);
        return Matcher.matchPath(patDirs, Matcher.tokenizePathAsArray(str), true);
    }

    public static boolean matchPath(String pattern, String str, boolean isCaseSensitive) {
        String[] patDirs = Matcher.tokenizePathAsArray(pattern);
        return Matcher.matchPath(patDirs, Matcher.tokenizePathAsArray(str), isCaseSensitive);
    }

    public static boolean matchPath(String[] tokenizedPattern, String[] strDirs, boolean isCaseSensitive) {
        String patDir;
        int strIdxStart;
        int patIdxStart = 0;
        int patIdxEnd = tokenizedPattern.length - 1;
        int strIdxEnd = strDirs.length - 1;
        for (strIdxStart = 0; patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd && !(patDir = tokenizedPattern[patIdxStart]).equals(DEEP_TREE_MATCH); ++patIdxStart, ++strIdxStart) {
            if (Matcher.match(patDir, strDirs[strIdxStart], isCaseSensitive)) continue;
            return false;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i = patIdxStart; i <= patIdxEnd; ++i) {
                if (tokenizedPattern[i].equals(DEEP_TREE_MATCH)) continue;
                return false;
            }
            return true;
        }
        if (patIdxStart > patIdxEnd) {
            return false;
        }
        while (patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd && !(patDir = tokenizedPattern[patIdxEnd]).equals(DEEP_TREE_MATCH)) {
            if (!Matcher.match(patDir, strDirs[strIdxEnd], isCaseSensitive)) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i = patIdxStart; i <= patIdxEnd; ++i) {
                if (tokenizedPattern[i].equals(DEEP_TREE_MATCH)) continue;
                return false;
            }
            return true;
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i = patIdxStart + 1; i <= patIdxEnd; ++i) {
                if (!tokenizedPattern[i].equals(DEEP_TREE_MATCH)) continue;
                patIdxTmp = i;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block6: for (int i = 0; i <= strLength - patLength; ++i) {
                for (int j = 0; j < patLength; ++j) {
                    String subPat = tokenizedPattern[patIdxStart + j + 1];
                    String subStr = strDirs[strIdxStart + i + j];
                    if (!Matcher.match(subPat, subStr, isCaseSensitive)) continue block6;
                }
                foundIdx = strIdxStart + i;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (int i = patIdxStart; i <= patIdxEnd; ++i) {
            if (tokenizedPattern[i].equals(DEEP_TREE_MATCH)) continue;
            return false;
        }
        return true;
    }

    public static boolean match(String pattern, String str) {
        return Matcher.match(pattern, str, true);
    }

    public static boolean match(String pattern, String str, boolean caseSensitive) {
        char ch;
        int i;
        char[] patArr = pattern.toCharArray();
        char[] strArr = str.toCharArray();
        int patIdxStart = 0;
        int patIdxEnd = patArr.length - 1;
        int strIdxStart = 0;
        int strIdxEnd = strArr.length - 1;
        boolean containsStar = false;
        for (i = 0; i < patArr.length; ++i) {
            if (patArr[i] != '*') continue;
            containsStar = true;
            break;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            for (i = 0; i <= patIdxEnd; ++i) {
                char ch2 = patArr[i];
                if (ch2 == '?' || !Matcher.different(caseSensitive, ch2, strArr[i])) continue;
                return false;
            }
            return true;
        }
        if (patIdxEnd == 0) {
            return true;
        }
        while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?' && Matcher.different(caseSensitive, ch, strArr[strIdxStart])) {
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            return Matcher.allStars(patArr, patIdxStart, patIdxEnd);
        }
        while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?' && Matcher.different(caseSensitive, ch, strArr[strIdxEnd])) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            return Matcher.allStars(patArr, patIdxStart, patIdxEnd);
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i2 = patIdxStart + 1; i2 <= patIdxEnd; ++i2) {
                if (patArr[i2] != '*') continue;
                patIdxTmp = i2;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block6: for (int i3 = 0; i3 <= strLength - patLength; ++i3) {
                for (int j = 0; j < patLength; ++j) {
                    ch = patArr[patIdxStart + j + 1];
                    if (ch != '?' && Matcher.different(caseSensitive, ch, strArr[strIdxStart + i3 + j])) continue block6;
                }
                foundIdx = strIdxStart + i3;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        return Matcher.allStars(patArr, patIdxStart, patIdxEnd);
    }

    private static boolean allStars(char[] chars, int start, int end) {
        for (int i = start; i <= end; ++i) {
            if (chars[i] == '*') continue;
            return false;
        }
        return true;
    }

    private static boolean different(boolean caseSensitive, char ch, char other) {
        return caseSensitive ? ch != other : Character.toUpperCase(ch) != Character.toUpperCase(other);
    }

    public static String[] tokenizePathAsArray(String path) {
        if (log.isTraceEnabled()) {
            log.trace(sm.getString("matcher.tokenize", path));
        }
        String root = null;
        if (Matcher.isAbsolutePath(path)) {
            String[] s = Matcher.dissect(path);
            root = s[0];
            path = s[1];
        }
        char sep = File.separatorChar;
        int start = 0;
        int len = path.length();
        int count = 0;
        for (int pos = 0; pos < len; ++pos) {
            if (path.charAt(pos) != sep) continue;
            if (pos != start) {
                ++count;
            }
            start = pos + 1;
        }
        if (len != start) {
            ++count;
        }
        String[] l = new String[count + (root == null ? 0 : 1)];
        if (root != null) {
            l[0] = root;
            count = 1;
        } else {
            count = 0;
        }
        start = 0;
        for (int pos = 0; pos < len; ++pos) {
            if (path.charAt(pos) != sep) continue;
            if (pos != start) {
                String tok = path.substring(start, pos);
                l[count++] = tok;
            }
            start = pos + 1;
        }
        if (len != start) {
            String tok;
            l[count] = tok = path.substring(start);
        }
        return l;
    }

    private static String[] dissect(String path) {
        char sep = File.separatorChar;
        path = path.replace('/', sep).replace('\\', sep);
        String root = null;
        int colon = path.indexOf(58);
        if (colon > 0 && (ON_DOS || ON_NETWARE)) {
            int next = colon + 1;
            root = path.substring(0, next);
            char[] ca = path.toCharArray();
            root = root + sep;
            next = ca[next] == sep ? next + 1 : next;
            StringBuilder sbPath = new StringBuilder();
            for (int i = next; i < ca.length; ++i) {
                if (ca[i] == sep && ca[i - 1] == sep) continue;
                sbPath.append(ca[i]);
            }
            path = sbPath.toString();
        } else if (path.length() > 1 && path.charAt(1) == sep) {
            int nextsep = path.indexOf(sep, 2);
            root = (nextsep = path.indexOf(sep, nextsep + 1)) > 2 ? path.substring(0, nextsep + 1) : path;
            path = path.substring(root.length());
        } else {
            root = File.separator;
            path = path.substring(1);
        }
        return new String[]{root, path};
    }

    private static boolean isAbsolutePath(String filename) {
        int len = filename.length();
        if (len == 0) {
            return false;
        }
        char sep = File.separatorChar;
        filename = filename.replace('/', sep).replace('\\', sep);
        char c = filename.charAt(0);
        if (!ON_DOS && !ON_NETWARE) {
            return c == sep;
        }
        if (c == sep) {
            if (!ON_DOS || len <= 4 || filename.charAt(1) != sep) {
                return false;
            }
            int nextsep = filename.indexOf(sep, 2);
            return nextsep > 2 && nextsep + 1 < len;
        }
        int colon = filename.indexOf(58);
        return Character.isLetter(c) && colon == 1 && filename.length() > 2 && filename.charAt(2) == sep || ON_NETWARE && colon > 0;
    }

    private static boolean isNetware() {
        return OS_NAME.indexOf("netware") > -1;
    }

    private static boolean isDos() {
        return PATH_SEP.equals(";") && !Matcher.isNetware();
    }
}

