/*
 * Decompiled with CFR 0.152.
 */
package api.calls;

import api.calls.MainImpl;
import es.bsc.compss.api.COMPSs;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class Main {
    private static void initCounter(String counterName, int value) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(counterName);){
            fos.write(value);
            System.out.println("Initial " + counterName + " value is " + value);
        }
    }

    private static void printCounter(String counterName) throws IOException {
        System.out.println("After Sending task");
        try (FileInputStream fis = new FileInputStream(counterName);){
            System.out.println("Final " + counterName + " value is " + fis.read());
        }
    }

    private static void testBarrier(int initialValue) throws IOException {
        String counterName1 = "counter1";
        String counterName2 = "counter2";
        String counterName3 = "counter3";
        Main.initCounter(counterName1, initialValue);
        Main.initCounter(counterName2, initialValue);
        Main.initCounter(counterName3, initialValue);
        MainImpl.increment(counterName1);
        COMPSs.barrier();
        MainImpl.increment(counterName2);
        COMPSs.barrier((boolean)false);
        MainImpl.increment(counterName3);
        COMPSs.barrier((boolean)true);
        Main.printCounter(counterName1);
        Main.printCounter(counterName2);
        Main.printCounter(counterName3);
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.out.println("[ERROR] Bad number of parameters");
            System.out.println("    Usage: java_api_calls.Main <counterValue>");
            System.exit(-1);
        }
        int initialValue = Integer.parseInt(args[0]);
        Main.testBarrier(initialValue);
    }
}

