/*
 * Decompiled with CFR 0.152.
 */
package complexTest;

import complexTest.Block;

public class DataLocality {
    private static int MSIZE;
    private static final int BSIZE = 2;
    private Block[][] A;
    private Block[][] B;
    private Block[][] C;

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("[ERROR] Bad number of parameters");
            System.out.println("Usage: dataLocality <msize>");
            System.exit(-1);
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        MSIZE = Integer.parseInt(args[0]);
        System.out.println("[LOG] MSIZE parameter value = " + MSIZE);
        System.out.println("[LOG] BSIZE parameter value = 2");
        DataLocality matmul = new DataLocality();
        matmul.Run();
        System.out.println("[LOG] Main program finished. Result needs to be checked (result script)");
    }

    private void Run() {
        System.out.println("[LOG] Creating matrix A");
        this.A = new Block[MSIZE][MSIZE];
        this.create("A");
        System.out.println("[LOG] Creating matrix B");
        this.B = new Block[MSIZE][MSIZE];
        this.create("B");
        System.out.println("[LOG] Allocating C Matrix space");
        this.C = new Block[MSIZE][MSIZE];
        System.out.println("[LOG] Computing Result");
        for (int i = 0; i < MSIZE; ++i) {
            for (int j = 0; j < MSIZE; ++j) {
                this.C[i][j] = new Block(2);
                for (int k = 0; k < MSIZE; ++k) {
                    this.C[i][j].multiplyAccumulative(this.A[i][k], this.B[k][j]);
                }
            }
        }
    }

    private void create(String tag) {
        for (int i = 0; i < MSIZE; ++i) {
            for (int j = 0; j < MSIZE; ++j) {
                if (tag.equals("A")) {
                    this.A[i][j] = Block.initBlock(2);
                    continue;
                }
                if (!tag.equals("B")) continue;
                this.B[i][j] = Block.initBlock(2);
            }
        }
    }

    private void printMatrix(Block[][] matrix, String name) {
        System.out.println("MATRIX " + name);
        for (int i = 0; i < MSIZE; ++i) {
            for (int j = 0; j < MSIZE; ++j) {
                matrix[i][j].printBlock();
            }
            System.out.println("");
        }
    }
}

