/*
 * Decompiled with CFR 0.152.
 */
package matmul.files;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import matmul.files.MatmulImpl;

public class Matmul {
    private static final int MSIZE = 8;
    private static final int BSIZE = 2;
    private String[][] _A;
    private String[][] _B;
    private String[][] _C;

    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.println("[ERROR] Usage: matmul <Ain> <Bin> <Cout>");
            System.exit(-1);
        }
        String fA = args[0];
        String fB = args[1];
        String fC = args[2];
        System.out.println("[LOG] MSIZE parameter value = 8");
        System.out.println("[LOG] BSIZE parameter value = 2");
        Matmul matmul = new Matmul();
        matmul.Run(fA, fB);
        System.out.println("[LOG] Storing C matrix obtained");
        matmul.storeMatrix(fC);
        System.out.println("[LOG] Main program finished. Result needs to be checked (result script)");
    }

    private void Run(String fileA, String fileB) {
        System.out.println("[LOG] Initialising files' names for each matrix");
        this.initializeVariables();
        System.out.println("[LOG] Loading matrix A from file");
        this.loadMatrix("A", fileA);
        System.out.println("[LOG] Loading matrix B from file");
        this.loadMatrix("B", fileB);
        System.out.println("[LOG] Creating files for result computation");
        this.fillMatrix();
        System.out.println("[LOG] Computing result");
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                for (int k = 0; k < 8; ++k) {
                    MatmulImpl.multiplyAccumulative(this._C[i][j], this._A[i][k], this._B[k][j]);
                }
            }
        }
    }

    private void initializeVariables() {
        this._A = new String[8][8];
        this._B = new String[8][8];
        this._C = new String[8][8];
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                this._A[i][j] = "A." + i + "." + j;
                this._B[i][j] = "B." + i + "." + j;
                this._C[i][j] = "C." + i + "." + j;
            }
        }
    }

    private void loadMatrix(String tag, String fileName) {
        try {
            FileReader filereader = new FileReader(fileName);
            BufferedReader br = new BufferedReader(filereader);
            for (int i = 0; i < 8; ++i) {
                String nextLine;
                for (int j = 0; j < 8; ++j) {
                    nextLine = br.readLine();
                    StringTokenizer tokens = new StringTokenizer(nextLine);
                    FileOutputStream fos = null;
                    if (tag.equals("A")) {
                        fos = new FileOutputStream(this._A[i][j]);
                    } else if (tag.equals("B")) {
                        fos = new FileOutputStream(this._B[i][j]);
                    } else {
                        System.out.println("[ERROR] Bad load parameter.");
                        System.exit(1);
                    }
                    for (int iblock = 0; iblock < 2 && tokens.hasMoreTokens(); ++iblock) {
                        for (int jblock = 0; jblock < 2 && tokens.hasMoreTokens(); ++jblock) {
                            String value = tokens.nextToken() + " ";
                            fos.write(value.getBytes());
                        }
                        fos.write("\n".getBytes());
                    }
                    fos.close();
                }
                nextLine = br.readLine();
            }
            br.close();
            filereader.close();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            System.exit(-1);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(-1);
        }
    }

    private void fillMatrix() {
        try {
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < 8; ++j) {
                    FileOutputStream fos = new FileOutputStream(this._C[i][j]);
                    for (int ii = 0; ii < 2; ++ii) {
                        for (int jj = 0; jj < 2; ++jj) {
                            fos.write("0.0 ".getBytes());
                        }
                        fos.write("\n".getBytes());
                    }
                    fos.close();
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void storeMatrix(String fileName) {
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < 8; ++j) {
                    FileReader filereader = new FileReader(this._C[i][j]);
                    BufferedReader br = new BufferedReader(filereader);
                    for (int iblock = 0; iblock < 2; ++iblock) {
                        String nextLine = br.readLine();
                        StringTokenizer tokens = new StringTokenizer(nextLine);
                        for (int jblock = 0; jblock < 2 && tokens.hasMoreTokens(); ++jblock) {
                            String value = tokens.nextToken() + " ";
                            fos.write(value.getBytes());
                        }
                    }
                    fos.write("\n".getBytes());
                    br.close();
                    filereader.close();
                }
                fos.write("\n".getBytes());
            }
            fos.close();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

