/*
 * Decompiled with CFR 0.152.
 */
package matmul.objects;

import java.io.FileOutputStream;
import java.io.Serializable;

public class Block
implements Serializable {
    private int M;
    private double[][] data;

    public Block() {
    }

    public Block(int bSize) {
        this.M = bSize;
        this.data = new double[this.M][this.M];
        for (int i = 0; i < this.M; ++i) {
            for (int j = 0; j < this.M; ++j) {
                this.data[i][j] = 0.0;
            }
        }
    }

    public int getM() {
        return this.M;
    }

    public void setM(int i) {
        this.M = i;
    }

    public double[][] getData() {
        return this.data;
    }

    public void setData(double[][] d) {
        this.data = d;
    }

    public void printBlock() {
        for (int i = 0; i < this.M; ++i) {
            for (int j = 0; j < this.M; ++j) {
                System.out.print(this.data[i][j] + " ");
            }
        }
        System.out.println("");
    }

    public void blockToDisk(int i, int j, String name) {
        try {
            FileOutputStream fos = new FileOutputStream(name + "." + i + "." + j);
            for (int k1 = 0; k1 < this.M; ++k1) {
                for (int k2 = 0; k2 < this.M; ++k2) {
                    String str = this.data[k1][k2] + " ";
                    fos.write(str.getBytes());
                }
                fos.write("\n".getBytes());
            }
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public void multiplyAccumulative(Block a, Block b) {
        for (int i = 0; i < this.M; ++i) {
            for (int j = 0; j < this.M; ++j) {
                for (int k = 0; k < this.M; ++k) {
                    double[] dArray = this.data[i];
                    int n = j;
                    dArray[n] = dArray[n] + a.data[i][k] * b.data[k][j];
                }
            }
        }
    }

    public static Block initBlock(int M) {
        Block block = new Block(M);
        for (int i = 0; i < M; ++i) {
            for (int j = 0; j < M; ++j) {
                double value;
                block.data[i][j] = value = Math.random() * 10.0;
            }
        }
        return block;
    }
}

