/*
 * Decompiled with CFR 0.152.
 */
package matmul.objects;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import matmul.objects.Block;

public class Matmul {
    private static final int MSIZE = 8;
    private static final int BSIZE = 2;
    private Block[][] A;
    private Block[][] B;
    private Block[][] C;

    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.println("[ERROR] Usage: matmul <Ain> <Bin> <Cout>");
            System.exit(-1);
        }
        String fA = args[0];
        String fB = args[1];
        String fC = args[2];
        System.out.println("[LOG] MSIZE parameter value = 8");
        System.out.println("[LOG] BSIZE parameter value = 2");
        Matmul matmul = new Matmul();
        matmul.Run(fA, fB);
        System.out.println("[LOG] Storing C matrix obtained");
        matmul.storeMatrix(fC);
        System.out.println("[LOG] Main program finished. Result needs to be checked (result script)");
    }

    private void Run(String fileA, String fileB) {
        System.out.println("[LOG] Allocating A/B/C matrix space");
        this.A = new Block[8][8];
        this.B = new Block[8][8];
        this.C = new Block[8][8];
        System.out.println("[LOG] Loading A Matrix from file");
        this.loadMatrix(this.A, fileA);
        System.out.println("[LOG] Loading B Matrix from file");
        this.loadMatrix(this.B, fileB);
        System.out.println("[LOG] Computing Result");
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                this.C[i][j] = new Block(2);
                for (int k = 0; k < 8; ++k) {
                    this.C[i][j].multiplyAccumulative(this.A[i][k], this.B[k][j]);
                }
            }
        }
    }

    private void loadMatrix(Block[][] matrix, String fileName) {
        try {
            FileReader filereader = new FileReader(fileName);
            BufferedReader br = new BufferedReader(filereader);
            for (int i = 0; i < 8; ++i) {
                String nextLine;
                for (int j = 0; j < 8; ++j) {
                    nextLine = br.readLine();
                    StringTokenizer tokens = new StringTokenizer(nextLine);
                    double[][] aux = new double[2][2];
                    for (int iblock = 0; iblock < 2 && tokens.hasMoreTokens(); ++iblock) {
                        for (int jblock = 0; jblock < 2 && tokens.hasMoreTokens(); ++jblock) {
                            String value = tokens.nextToken();
                            aux[iblock][jblock] = Double.parseDouble(value);
                        }
                    }
                    matrix[i][j] = new Block(2);
                    matrix[i][j].setData(aux);
                }
                nextLine = br.readLine();
            }
            br.close();
            filereader.close();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            System.exit(-1);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(-1);
        }
    }

    private void storeMatrix(String fileName) {
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < 8; ++j) {
                    double[][] aux = this.C[i][j].getData();
                    for (int iblock = 0; iblock < 2; ++iblock) {
                        for (int jblock = 0; jblock < 2; ++jblock) {
                            String value = String.valueOf(aux[iblock][jblock]) + " ";
                            fos.write(value.getBytes());
                        }
                    }
                    fos.write("\n".getBytes());
                }
                fos.write("\n".getBytes());
            }
            fos.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(-1);
        }
    }

    private void printMatrix(Block[][] matrix, String name) {
        System.out.println("MATRIX " + name);
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                matrix[i][j].printBlock();
            }
            System.out.println("");
        }
    }
}

