/*
 * Decompiled with CFR 0.152.
 */
package matmul.arrays;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import matmul.arrays.MatmulImpl;

public class Matmul {
    private static final int MSIZE = 8;
    private static final int BSIZE = 2;
    private double[][][] A;
    private double[][][] B;
    private double[][][] C;

    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.println("[ERROR] Usage: matmul <Ain> <Bin> <Cout>");
            System.exit(-1);
        }
        String fA = args[0];
        String fB = args[1];
        String fC = args[2];
        System.out.println("[LOG] MSIZE parameter value = 8");
        System.out.println("[LOG] BSIZE parameter value = 2");
        Matmul matmul = new Matmul();
        matmul.Run(fA, fB);
        System.out.println("[LOG] Storing C matrix obtained");
        matmul.storeMatrix(fC);
        System.out.println("[LOG] Main program finished. Result needs to be checked (result script)");
    }

    private void Run(String fileA, String fileB) {
        System.out.println("[LOG] Allocating A/B/C matrix space");
        this.A = new double[8][8][4];
        this.B = new double[8][8][4];
        this.C = new double[8][8][4];
        System.out.println("[LOG] Loading A Matrix from file");
        this.loadMatrix(this.A, fileA);
        System.out.println("[LOG] Loading B Matrix from file");
        this.loadMatrix(this.B, fileB);
        System.out.println("[LOG] Computing Result");
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                for (int k = 0; k < 8; ++k) {
                    MatmulImpl.multiplyAccumulative(this.A[i][k], this.B[k][j], this.C[i][j]);
                }
            }
        }
    }

    private void loadMatrix(double[][][] matrix, String fileName) {
        try {
            FileReader filereader = new FileReader(fileName);
            BufferedReader br = new BufferedReader(filereader);
            for (int i = 0; i < 8; ++i) {
                String nextLine;
                for (int j = 0; j < 8; ++j) {
                    nextLine = br.readLine();
                    StringTokenizer tokens = new StringTokenizer(nextLine);
                    for (int block = 0; block < 4 && tokens.hasMoreTokens(); ++block) {
                        String value = tokens.nextToken();
                        matrix[i][j][block] = Double.parseDouble(value);
                    }
                }
                nextLine = br.readLine();
            }
            br.close();
            filereader.close();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            System.exit(-1);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(-1);
        }
    }

    private void storeMatrix(String fileName) {
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < 8; ++j) {
                    for (int block = 0; block < 4; ++block) {
                        String value = String.valueOf(this.C[i][j][block]) + " ";
                        fos.write(value.getBytes());
                    }
                    fos.write("\n".getBytes());
                }
                fos.write("\n".getBytes());
            }
            fos.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(-1);
        }
    }

    private void printMatrix(double[][][] matrix, String name) {
        System.out.println("MATRIX " + name);
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                MatmulImpl.printBlock(matrix[i][j]);
            }
            System.out.println("");
        }
    }
}

