/*
 * Decompiled with CFR 0.152.
 */
package generation;

import java.io.FileOutputStream;
import java.io.IOException;

public class MatmulGeneration {
    private static int MSIZE;
    private static final int BSIZE = 2;
    private static double[][][] A;
    private static double[][][] B;
    private static double[][][] C;

    public static void main(String[] args) {
        if (args.length != 4) {
            System.out.println("[ERROR] Usage: matmul <MSIZE> <Ain> <Bin> <Cout>");
            System.exit(-1);
        }
        MSIZE = Integer.parseInt(args[0]);
        String fA = args[1];
        String fB = args[2];
        String fC = args[3];
        System.out.println("[LOG] MSIZE parameter value = " + MSIZE);
        System.out.println("[LOG] BSIZE parameter value = 2");
        A = new double[MSIZE][MSIZE][4];
        B = new double[MSIZE][MSIZE][4];
        C = new double[MSIZE][MSIZE][4];
        System.out.println("[LOG] Generating Matrix A");
        MatmulGeneration.generate("A");
        System.out.println("[LOG] Generating Matrix B");
        MatmulGeneration.generate("B");
        System.out.println("[LOG] Calculating Matrix C");
        MatmulGeneration.calculate();
        System.out.println("[LOG] Storing A matrix");
        MatmulGeneration.storeMatrix("A", fA);
        System.out.println("[LOG] Storing B matrix");
        MatmulGeneration.storeMatrix("B", fB);
        System.out.println("[LOG] Storing C matrix");
        MatmulGeneration.storeMatrix("C", fC);
        System.out.println("[LOG] Main program finished");
    }

    private static void generate(String tag) {
        if (!tag.equals("A") && !tag.equals("B")) {
            System.out.println("[ERROR] Bad generation");
            System.exit(-1);
        }
        for (int i = 0; i < MSIZE; ++i) {
            for (int j = 0; j < MSIZE; ++j) {
                for (int block = 0; block < 4; ++block) {
                    if (tag.equals("A")) {
                        MatmulGeneration.A[i][j][block] = Math.random() * 10.0;
                        continue;
                    }
                    MatmulGeneration.B[i][j][block] = Math.random() * 10.0;
                }
            }
        }
    }

    private static void calculate() {
        for (int i = 0; i < MSIZE; ++i) {
            for (int j = 0; j < MSIZE; ++j) {
                for (int k = 0; k < MSIZE; ++k) {
                    for (int iblock = 0; iblock < 2; ++iblock) {
                        for (int jblock = 0; jblock < 2; ++jblock) {
                            for (int kblock = 0; kblock < 2; ++kblock) {
                                double[] dArray = C[i][j];
                                int n = iblock * 2 + jblock;
                                dArray[n] = dArray[n] + A[i][k][iblock * 2 + kblock] * B[k][j][kblock * 2 + jblock];
                            }
                        }
                    }
                }
            }
        }
    }

    private static void storeMatrix(String tag, String fileName) {
        if (!(tag.equals("A") || tag.equals("B") || tag.equals("C"))) {
            System.out.println("[ERROR] Bad store code");
            System.exit(-1);
        }
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            for (int i = 0; i < MSIZE; ++i) {
                for (int j = 0; j < MSIZE; ++j) {
                    for (int block = 0; block < 4; ++block) {
                        String value = tag.equals("A") ? String.valueOf(A[i][j][block]) + " " : (tag.equals("B") ? String.valueOf(B[i][j][block]) + " " : String.valueOf(C[i][j][block]) + " ");
                        fos.write(value.getBytes());
                    }
                    fos.write("\n".getBytes());
                }
                fos.write("\n".getBytes());
            }
            fos.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

