/*
 * Decompiled with CFR 0.152.
 */
package matmul.files;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import matmul.files.MatmulAppException;

public class Block {
    private final int BLOCK_SIZE = 2;
    private int bCols;
    private int bRows;
    private double[][] data;

    public Block() {
        this.bCols = 2;
        this.bRows = 2;
        this.data = new double[this.bRows][this.bCols];
        for (int i = 0; i < this.bRows; ++i) {
            for (int j = 0; j < this.bCols; ++j) {
                this.data[i][j] = 0.0;
            }
        }
    }

    public Block(int _bRows, int _bCols) {
        this.bRows = _bRows;
        this.bCols = _bCols;
        this.data = new double[this.bRows][this.bCols];
        for (int i = 0; i < this.bRows; ++i) {
            for (int j = 0; j < this.bCols; ++j) {
                this.data[i][j] = 0.0;
            }
        }
    }

    public Block(String filename) {
        this.bCols = 2;
        this.bRows = 2;
        this.data = new double[this.bRows][this.bCols];
        try {
            FileReader filereader = new FileReader(filename);
            BufferedReader br = new BufferedReader(filereader);
            for (int i = 0; i < this.bRows; ++i) {
                String nextLine = br.readLine();
                StringTokenizer tokens = new StringTokenizer(nextLine);
                for (int j = 0; j < this.bCols && tokens.hasMoreTokens(); ++j) {
                    this.data[i][j] = Double.parseDouble(tokens.nextToken());
                }
            }
            br.close();
            filereader.close();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            System.exit(-1);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(-1);
        }
    }

    protected void printBlock() {
        for (int i = 0; i < this.bRows; ++i) {
            for (int j = 0; j < this.bCols; ++j) {
                System.out.print(this.data[i][j] + " ");
            }
            System.out.println();
        }
    }

    public void blockToDisk(String filename) {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            for (int i = 0; i < this.bRows; ++i) {
                for (int j = 0; j < this.bCols; ++j) {
                    String str = new Double(this.data[i][j]).toString() + " ";
                    fos.write(str.getBytes());
                }
                fos.write("\n".getBytes());
            }
            fos.close();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            System.exit(-1);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(-1);
        }
    }

    public void sub(Block b) {
        for (int i = 0; i < this.bRows; ++i) {
            for (int j = 0; j < this.bCols; ++j) {
                double[] dArray = this.data[i];
                int n = j;
                dArray[n] = dArray[n] - b.data[i][j];
            }
        }
    }

    public void multiplyAccum(Block a, Block b) {
        for (int i = 0; i < this.bRows; ++i) {
            for (int j = 0; j < this.bCols; ++j) {
                for (int k = 0; k < this.bCols; ++k) {
                    double[] dArray = this.data[i];
                    int n = j;
                    dArray[n] = dArray[n] + a.data[i][k] * b.data[k][j];
                }
            }
        }
    }

    public void cholesky() throws MatmulAppException {
        Block L = new Block();
        for (int j = 0; j < 2; ++j) {
            int i;
            double tmp = 0.0;
            for (i = 0; i < j; ++i) {
                tmp += L.data[j][i] * L.data[j][i];
            }
            L.data[j][j] = this.data[j][j] - tmp;
            for (i = j + 1; i < 2; ++i) {
                tmp = 0.0;
                for (int k = 0; k < j; ++k) {
                    tmp += L.data[i][k] * L.data[j][k];
                }
                L.data[i][j] = this.data[i][j] - tmp;
            }
            if (L.data[j][j] <= 0.0) {
                throw new MatmulAppException("Diagonal element L[" + j + "][" + j + "] is negative");
            }
            L.data[j][j] = Math.sqrt(L.data[j][j]);
            for (i = j + 1; i < 2; ++i) {
                L.data[i][j] = L.data[i][j] / L.data[j][j];
            }
        }
        this.data = L.data;
    }

    public void inverse() throws MatmulAppException {
        int j;
        int l;
        Block R = new Block();
        Block I = new Block(2, 4);
        boolean found = false;
        for (l = 0; l < this.bRows; ++l) {
            for (j = 0; j < this.bCols; ++j) {
                I.data[l][j] = this.data[l][j];
            }
            I.data[l][l + this.bCols] = 1.0;
        }
        for (int j2 = 0; j2 < this.bCols; ++j2) {
            int i = j2;
            found = false;
            while (!found && i < I.bRows) {
                if (I.data[i][j2] != 0.0) {
                    found = true;
                    continue;
                }
                ++i;
            }
            if (!found) {
                throw new MatmulAppException("We can't find the inverse of this matrix...");
            }
            double swap = I.data[i][j2];
            int aux = 0;
            while (aux < I.bCols) {
                double[] dArray = I.data[i];
                int n = aux++;
                dArray[n] = dArray[n] / swap;
            }
            for (int k = 0; k < this.bRows; ++k) {
                if (k == i) continue;
                swap = I.data[k][j2];
                for (int aux2 = 0; aux2 < I.bCols; ++aux2) {
                    double[] dArray = I.data[k];
                    int n = aux2;
                    dArray[n] = dArray[n] - swap * I.data[i][aux2];
                }
            }
            if (i == j2) continue;
            for (aux = 0; aux < I.bCols; ++aux) {
                swap = I.data[i][aux];
                I.data[i][aux] = I.data[j2][aux];
                I.data[j2][aux] = swap;
            }
        }
        for (l = 0; l < R.bRows; ++l) {
            for (j = 0; j < R.bCols; ++j) {
                R.data[l][j] = I.data[l][j + this.bCols];
            }
        }
        this.data = R.data;
    }

    public void reverseColumns() {
        Block tmp = new Block();
        for (int i = 0; i < this.bRows; ++i) {
            for (int j = 0; j < this.bCols; ++j) {
                tmp.data[i][j] = this.data[i][1 - j];
            }
        }
        this.data = tmp.data;
    }
}

